/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.entity.construct.sigils.chanting;

import astramusfate.wizardry_tales.entity.construct.EntityMagicCircle;
import com.google.common.collect.Lists;
import electroblob.wizardry.util.NBTExtras;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class EntityCircleWords
extends EntityMagicCircle {
    public List<String> words = Lists.newArrayList();
    public int amount = -1;

    public EntityCircleWords(World world) {
        super(world);
    }

    public EntityCircleWords(World world, List<String> words) {
        super(world);
        this.setWords(words);
    }

    public void setWords(List<String> words) {
        this.words = words;
        this.amount = words.size() - 1;
    }

    @Override
    protected void func_70014_b(@Nonnull NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("amount", this.amount);
        NBTExtras.storeTagSafely((NBTTagCompound)tag, (String)"words", (NBTBase)NBTExtras.listToNBT(this.words, NBTTagString::new));
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.amount = tag.func_74762_e("amount");
        this.words = (List)NBTExtras.NBTToList((NBTTagList)tag.func_150295_c("words", 8), NBTTagString::func_150285_a_);
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeInt(this.amount);
        for (String word : this.words) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)word);
        }
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.amount = data.readInt();
        if (this.amount > -1) {
            for (int i = 0; i < this.amount; ++i) {
                this.words.add(i, ByteBufUtils.readUTF8String((ByteBuf)data));
            }
        }
    }
}

