/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.entity.living;

import astramusfate.wizardry_tales.api.Alchemy;
import astramusfate.wizardry_tales.api.Selena;
import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.api.classes.ISmartAnimatable;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.entity.construct.EntityRedGas;
import astramusfate.wizardry_tales.entity.living.EntityMushroom;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityBigMushroom
extends EntityMob
implements ISmartAnimatable,
IAnimationTickable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean spawnOnDeath;

    public EntityBigMushroom(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.8f, 2.2f);
        this.spawnOnDeath = false;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return super.func_184601_bQ(damageSourceIn);
    }

    public void func_70108_f(@Nonnull Entity entityIn) {
    }

    public void func_70653_a(@Nonnull Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public float func_70047_e() {
        return 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 14.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(75.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (Solver.doEvery(this.field_70173_aa, 5.0)) {
            if (!this.isAngry()) {
                EntityLivingBase nearest;
                List<EntityLivingBase> players = Selena.getAround(this.field_70170_p, this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), this.func_180425_c(), EntityLivingBase.class, e -> e instanceof EntityPlayer && ((EntityPlayer)e).func_184812_l_() || e.func_82150_aj() || e == this);
                players.removeIf(e -> e instanceof EntityMushroom);
                if (!players.isEmpty() && (nearest = (EntityLivingBase)Selena.findNearest(this.func_174791_d(), players)) != null) {
                    this.func_70604_c(nearest);
                    this.func_70652_k((Entity)nearest);
                }
                return;
            }
            if (!this.field_70170_p.field_72995_K && this.isAngry()) {
                BlockPos blockpos = new BlockPos((Entity)this).func_177982_a(1, 2, 1);
                List<EntityLivingBase> players = Selena.getAround(this.field_70170_p, this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), this.func_180425_c(), EntityLivingBase.class, e -> e instanceof EntityPlayer && ((EntityPlayer)e).func_184812_l_() || e.func_82150_aj() || e == this);
                players.removeIf(e -> e instanceof EntityMushroom && (e != this.func_70638_az() || e != this.func_70643_av()));
                if (players.size() > 0) {
                    EntityLivingBase nearest;
                    EntityLivingBase entityLivingBase = nearest = players.size() == 1 ? players.get(0) : (EntityLivingBase)Selena.findNearest(this.func_174791_d(), players);
                    if (nearest == null) {
                        return;
                    }
                    if (nearest.func_70032_d((Entity)this) <= 6.0f) {
                        EntityRedGas entitySpawn = new EntityRedGas(this.field_70170_p);
                        entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
                        entitySpawn.setModifiers(new SpellModifiers());
                        entitySpawn.setLifetime(Solver.duration(5.0));
                        this.field_70170_p.func_72838_d((Entity)entitySpawn);
                    } else {
                        List<EntityMushroom> mushrooms = Selena.getAround(this.field_70170_p, 20.0, this.func_180425_c(), EntityMushroom.class);
                        if (mushrooms.size() < 5) {
                            EntityMushroom mushroom = new EntityMushroom(this.field_70170_p);
                            mushroom.func_174828_a(blockpos, 0.0f, 0.0f);
                            mushroom.func_70624_b(nearest);
                            mushroom.func_70604_c(nearest);
                            this.field_70170_p.func_72838_d((Entity)mushroom);
                        }
                    }
                }
            }
        }
    }

    protected void func_70609_aI() {
    }

    @Override
    public int getTimeToDie() {
        return 40;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_110143_aJ() <= 0.0f) {
            if (this.getAnimationController(this.func_110124_au(), "controller_idle") != null) {
                AnimationController death = this.getAnimationController(this.func_110124_au(), "controller_idle");
                if (death.getAnimationState() == AnimationState.Stopped) {
                    this.onDeathTick();
                }
            } else {
                this.onDeathTick();
            }
        }
    }

    private void onDeathTick() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == this.getTimeToDie()) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    public boolean isAngry() {
        return this.func_70638_az() != null || this.func_70643_av() != null;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean isLowHealth;
        if (EntityUtils.isLiving((Entity)entityIn) && Solver.chance(50 + ((isLowHealth = ((EntityLivingBase)entityIn).func_110143_aJ() <= ((EntityLivingBase)entityIn).func_110138_aP() * 0.7f) ? 30 : 0))) {
            Alchemy.applyPotion((EntityLivingBase)entityIn, Solver.duration(3.0), 0, MobEffects.field_76436_u);
        }
        return super.func_70652_k(entityIn);
    }

    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
            Biome biome = this.field_70170_p.func_180494_b(blockpos);
            return Arrays.stream(Tales.toResourceLocations(Tales.entities.big_mushroomBiomeWhitelist)).anyMatch(e -> biome.getRegistryName() == e);
        }
        return false;
    }

    private <E extends IAnimatable> PlayState predicateIdles(AnimationEvent<E> event) {
        if (!this.isAngry() && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() > 0.0f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle_angry", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.func_110143_aJ() <= 0.0f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }
        if (this.isIdle(event.getController())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicateGasAttack(AnimationEvent<E> event) {
        if (this.isAngry() && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() > 0.0f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("gas_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_idle", 10.0f, this::predicateIdles));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_gas", 20.0f, this::predicateGasAttack));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.field_70173_aa;
    }

    public void tick() {
        super.func_70071_h_();
    }
}

