/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.entity.living;

import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.api.classes.ISmartAnimatable;
import astramusfate.wizardry_tales.data.Tales;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityEnvenomedBlade
extends AbstractSkeleton
implements ISmartAnimatable,
IAnimationTickable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public EntityEnvenomedBlade(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 2.4f);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186385_aj;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    @Nonnull
    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        if (!super.func_70652_k(entityIn)) {
            return false;
        }
        if (entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, Solver.asTicks(3.0)));
        }
        return true;
    }

    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
            Biome biome = this.field_70170_p.func_180494_b(blockpos);
            return Arrays.stream(Tales.toResourceLocations(Tales.entities.envenomed_bladeBiomeWhitelist)).anyMatch(e -> biome.getRegistryName() == e);
        }
        return false;
    }

    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_idle", 0.0f, this::predicateIdle));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_walk", 10.0f, this::predicateWalk));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_attack", 5.0f, this::predicateAttack));
    }

    private <E extends IAnimatable> PlayState predicateAttack(AnimationEvent<E> event) {
        if (this.func_184725_db()) {
            event.getController().setAnimationSpeed(2.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicateIdle(AnimationEvent<E> event) {
        if (this.func_110143_aJ() <= 0.0f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }
        if (this.isIdle(event.getController())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicateWalk(AnimationEvent<E> event) {
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().setAnimationSpeed(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 10.0);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.field_70173_aa;
    }

    public void tick() {
        super.func_70071_h_();
    }

    protected void func_70609_aI() {
    }

    @Override
    public int getTimeToDie() {
        return 20;
    }

    public void func_70030_z() {
        AnimationController attack;
        super.func_70030_z();
        if (this.func_110143_aJ() <= 0.0f) {
            if (this.getAnimationController(this.func_110124_au(), "controller_idle") != null) {
                AnimationController death = this.getAnimationController(this.func_110124_au(), "controller_idle");
                if (death.getAnimationState() == AnimationState.Stopped) {
                    this.onDeathTick();
                }
            } else {
                this.onDeathTick();
            }
        }
        if (this.getAnimationController(this.func_110124_au(), "controller_attack") != null && (attack = this.getAnimationController(this.func_110124_au(), "controller_attack")).getAnimationState() == AnimationState.Stopped) {
            this.func_184724_a(false);
        }
    }

    private void onDeathTick() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == this.getTimeToDie()) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }
}

