/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.entity.living;

import astramusfate.wizardry_tales.api.Alchemy;
import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.entity.construct.EntityRedGas;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityMushroom
extends EntityMob
implements IAnimatable,
IAnimationTickable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean spawnOnDeath;
    private int hurtTime;

    public EntityMushroom(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.6f);
        this.spawnOnDeath = false;
        this.hurtTime = 0;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public float func_70047_e() {
        return 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.75, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 14.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
    }

    private <E extends IAnimatable> PlayState predicateIdle(AnimationEvent<E> event) {
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateWalk(AnimationEvent<E> event) {
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            event.getController().setAnimationSpeed(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 10.0);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_idle", 0.0f, this::predicateIdle));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller_walk", 10.0f, this::predicateWalk));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.field_70173_aa;
    }

    public void tick() {
        super.func_70071_h_();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.func_110143_aJ() <= 0.0f && !this.spawnOnDeath) {
            if (!this.field_70170_p.field_72995_K) {
                BlockPos blockpos = new BlockPos((Entity)this).func_177982_a(1, 2, 1);
                EntityRedGas entitySpawn = new EntityRedGas(this.field_70170_p);
                entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
                entitySpawn.setModifiers(new SpellModifiers());
                entitySpawn.setLifetime(Solver.duration(5.0));
                this.field_70170_p.func_72838_d((Entity)entitySpawn);
            }
            this.spawnOnDeath = true;
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        this.hurtTime = Solver.asTicks(5.0);
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean isLowHealth;
        if (EntityUtils.isLiving((Entity)entityIn) && Solver.chance(50 + ((isLowHealth = ((EntityLivingBase)entityIn).func_110143_aJ() <= ((EntityLivingBase)entityIn).func_110138_aP() * 0.7f) ? 30 : 0))) {
            Alchemy.applyPotion((EntityLivingBase)entityIn, Solver.duration(3.0), 0, MobEffects.field_76436_u);
        }
        return super.func_70652_k(entityIn);
    }

    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
            Biome biome = this.field_70170_p.func_180494_b(blockpos);
            return Arrays.stream(Tales.toResourceLocations(Tales.entities.mushroomBiomeWhitelist)).anyMatch(e -> biome.getRegistryName() == e);
        }
        return false;
    }
}

