/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.entity.projectile;

import astramusfate.wizardry_tales.api.Sage;
import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.api.Tenebria;
import astramusfate.wizardry_tales.api.wizardry.ArcaneColor;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCustomSigil;
import astramusfate.wizardry_tales.events.SpellCreation;
import com.google.common.collect.Lists;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityCustomArrow
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    public static final double LAUNCH_Y_OFFSET = 0.1;
    public static final int SEEKING_TIME = 15;
    private int blockX = -1;
    private int blockY = -1;
    private int blockZ = -1;
    private IBlockState stuckInBlock;
    private int inData;
    private boolean inGround;
    public int arrowShake;
    private WeakReference<EntityLivingBase> caster;
    private UUID casterUUID;
    int ticksInGround;
    int ticksInAir;
    int lifetime;
    private int knockbackStrength;
    public float damageMultiplier = 1.0f;
    public Element element = Element.MAGIC;
    public List<String> words = Lists.newArrayList();
    public int amount = -1;

    public EntityCustomArrow(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public void aim(EntityLivingBase caster, float speed) {
        this.setCaster(caster);
        this.func_70012_b(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.1, caster.field_70161_v, caster.field_70177_z, caster.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed * 1.5f, 1.0f);
    }

    public void aim(EntityLivingBase caster, Entity target, float speed, float aimingError) {
        this.setCaster(caster);
        this.field_70163_u = caster.field_70163_u + (double)caster.func_70047_e() - 0.1;
        double dx = target.field_70165_t - caster.field_70165_t;
        double dy = this.doGravity() ? target.field_70163_u + (double)(target.field_70131_O / 3.0f) - this.field_70163_u : target.field_70163_u + (double)(target.field_70131_O / 2.0f) - this.field_70163_u;
        double dz = target.field_70161_v - caster.field_70161_v;
        double horizontalDistance = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        if (horizontalDistance >= 1.0E-7) {
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, horizontalDistance) * 180.0 / Math.PI));
            double dxNormalised = dx / horizontalDistance;
            double dzNormalised = dz / horizontalDistance;
            this.func_70012_b(caster.field_70165_t + dxNormalised, this.field_70163_u, caster.field_70161_v + dzNormalised, yaw, pitch);
            float bulletDropCompensation = this.doGravity() ? (float)horizontalDistance * 0.2f : 0.0f;
            this.func_70186_c(dx, dy + (double)bulletDropCompensation, dz, speed, aimingError);
        }
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public MagicDamage.DamageType getDamageType() {
        return Sage.getTypeByElement(this.element);
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public boolean doGravity() {
        return true;
    }

    public boolean doDeceleration() {
        return true;
    }

    public boolean doOverpenetration() {
        return false;
    }

    public float getSeekingStrength() {
        return this.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)this.getCaster()), (Item)WizardryItems.ring_seeking) ? 2.0f : 0.0f;
    }

    public void setKnockbackStrength(int knockback) {
        this.knockbackStrength = knockback;
    }

    public EntityLivingBase getCaster() {
        return this.caster == null ? null : (EntityLivingBase)this.caster.get();
    }

    public void setCaster(EntityLivingBase entity) {
        this.caster = new WeakReference<EntityLivingBase>(entity);
    }

    protected void tickInGround() {
        this.func_70106_y();
    }

    public void tickInAir() {
        if (this.field_70170_p.field_72995_K) {
            if (Wizardry.tisTheSeason) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)this.field_70146_Z, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.03, (boolean)true).clr(0.8f, 0.15f, 0.15f).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SNOW).pos(this.field_70165_t, this.field_70163_u, this.field_70161_v).spawn(this.field_70170_p);
                if (this.field_70173_aa > 1) {
                    double x = this.field_70165_t - this.field_70159_w / 2.0;
                    double y = this.field_70163_u - this.field_70181_x / 2.0;
                    double z = this.field_70161_v - this.field_70179_y / 2.0;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)this.field_70146_Z, (double)x, (double)y, (double)z, (double)0.03, (boolean)true).clr(0.15f, 0.7f, 0.15f).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
                }
            } else {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)this.field_70146_Z, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.03, (boolean)true).clr(ArcaneColor.byElement(this.element)).fade(0.7f, 0.0f, 1.0f).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
                if (this.field_70173_aa > 1) {
                    double x = this.field_70165_t - this.field_70159_w / 2.0;
                    double y = this.field_70163_u - this.field_70181_x / 2.0;
                    double z = this.field_70161_v - this.field_70179_y / 2.0;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)this.field_70146_Z, (double)x, (double)y, (double)z, (double)0.03, (boolean)true).clr(ArcaneColor.byElement(this.element)).fade(0.7f, 0.0f, 1.0f).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
                }
            }
        }
    }

    protected void onEntityHit(EntityLivingBase target) {
        if (this.words.isEmpty()) {
            target.func_70015_d(10);
        }
        SpellCreation.createSpell(this.words, this, (Entity)target, !this.field_70170_p.field_72995_K);
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(this.field_70165_t, this.field_70163_u, this.field_70161_v).clr(ArcaneColor.byElement(this.element)).spawn(this.field_70170_p);
        }
    }

    public void onBlockHit(RayTraceResult hit) {
        String shape = "me";
        boolean attackAlly = false;
        boolean canAlly = false;
        String previous = "";
        for (int i = 0; i < this.words.size(); ++i) {
            String next = i + 1 < this.words.size() ? this.words.get(i + 1) : "";
            String next2 = i + 2 < this.words.size() ? this.words.get(i + 2) : "";
            String next3 = i + 3 < this.words.size() ? this.words.get(i + 3) : "";
            String word = this.words.get(i);
            if (SpellCreation.findIn(word, "shape")) {
                shape = SpellCreation.findShape(next, next2, next3);
            }
            if (SpellCreation.findIn(next, "ally allies allied")) {
                if (SpellCreation.findIn(word, "allow")) {
                    canAlly = true;
                }
                if (SpellCreation.findIn(word, "deny")) {
                    canAlly = false;
                }
                if (SpellCreation.findIn(word, "attack")) {
                    attackAlly = !SpellCreation.findIn(previous, "not");
                }
            }
            previous = word;
        }
        if (SpellCreation.findIn(shape, "sigil") && hit.field_178784_b == EnumFacing.UP) {
            this.words.remove("shape");
            this.words.remove("sigil");
            EntityCustomSigil entity = new EntityCustomSigil(this.field_70170_p, this.words);
            entity.setLocation(this.element.func_176610_l());
            if (!attackAlly) {
                entity.setCaster(this.getCaster());
            }
            entity.setLifetime(Solver.asTicks(this.lifetime));
            if (canAlly) {
                entity.onlyAllies();
            }
            BlockPos spellBlock = new BlockPos(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c);
            entity.func_70107_b((double)spellBlock.func_177958_n() + 0.5, spellBlock.func_177956_o(), (double)spellBlock.func_177952_p() + 0.5);
            entity.setSizeMultiplier(2.0f);
            if (this.field_70170_p.func_72872_a(((Object)((Object)entity)).getClass(), entity.func_174813_aQ()).isEmpty()) {
                Tenebria.create(this.field_70170_p, entity);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            Vec3d vec = hit.field_72307_f.func_178787_e(new Vec3d(hit.field_178784_b.func_176730_m()).func_186678_a(0.15));
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(vec).clr(ArcaneColor.byElement(this.element)).fade(0.85f, 0.5f, 0.8f).spawn(this.field_70170_p);
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        BlockPos blockpos;
        IBlockState iblockstate;
        Entity entity;
        super.func_70071_h_();
        if (this.getLifetime() >= 0 && this.field_70173_aa > this.getLifetime()) {
            this.func_70106_y();
        }
        if (this.getCaster() == null && this.casterUUID != null && (entity = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.casterUUID)) instanceof EntityLivingBase) {
            this.caster = new WeakReference<EntityLivingBase>((EntityLivingBase)entity);
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.blockX, this.blockY, this.blockZ))).func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && Objects.requireNonNull(axisalignedbb).func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            ++this.ticksInGround;
            this.tickInGround();
        } else {
            this.tickInAir();
            this.ticksInGround = 0;
            ++this.ticksInAir;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            Entity entity2 = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1 == this.getCaster() && this.ticksInAir < 5) continue;
                float f1 = 0.3f;
                AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                RayTraceResult RayTraceResult1 = axisalignedbb1.func_72327_a(vec3d1, vec3d);
                if (RayTraceResult1 == null || !((d1 = vec3d1.func_72438_d(RayTraceResult1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity2 = entity1;
                d0 = d1;
            }
            if (entity2 != null) {
                raytraceresult = new RayTraceResult(entity2);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.getCaster() instanceof EntityPlayer && !((EntityPlayer)this.getCaster()).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null) {
                if (raytraceresult.field_72308_g != null) {
                    if (raytraceresult.field_72308_g instanceof EntityLivingBase) {
                        float f4;
                        EntityLivingBase entityHit = (EntityLivingBase)raytraceresult.field_72308_g;
                        this.onEntityHit(entityHit);
                        if (this.knockbackStrength > 0 && (f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                            raytraceresult.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f4, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f4);
                        }
                        if (this.getCaster() != null) {
                            EnchantmentHelper.func_151384_a((EntityLivingBase)entityHit, (Entity)this.getCaster());
                            EnchantmentHelper.func_151385_b((EntityLivingBase)this.getCaster(), (Entity)entityHit);
                        }
                        if (this.getCaster() != null && raytraceresult.field_72308_g != this.getCaster() && raytraceresult.field_72308_g instanceof EntityPlayer && this.getCaster() instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)this.getCaster()).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                        }
                    }
                    if (!(raytraceresult.field_72308_g instanceof EntityEnderman) && !this.doOverpenetration()) {
                        this.func_70106_y();
                    }
                } else {
                    this.blockX = raytraceresult.func_178782_a().func_177958_n();
                    this.blockY = raytraceresult.func_178782_a().func_177956_o();
                    this.blockZ = raytraceresult.func_178782_a().func_177952_p();
                    this.stuckInBlock = this.field_70170_p.func_180495_p(raytraceresult.func_178782_a());
                    this.field_70159_w = (float)(raytraceresult.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(raytraceresult.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(raytraceresult.field_72307_f.field_72449_c - this.field_70161_v);
                    this.inGround = true;
                    this.arrowShake = 7;
                    this.onBlockHit(raytraceresult);
                    if (this.stuckInBlock.func_185904_a() != Material.field_151579_a) {
                        this.stuckInBlock.func_177230_c().func_180634_a(this.field_70170_p, raytraceresult.func_178782_a(), this.stuckInBlock, (Entity)this);
                    }
                }
            }
            if (this.getSeekingStrength() > 0.0f) {
                Vec3d velocity = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                RayTraceResult hit = RayTracer.rayTrace((World)this.field_70170_p, (Vec3d)this.func_174791_d(), (Vec3d)this.func_174791_d().func_178787_e(velocity.func_186678_a(15.0)), (float)this.getSeekingStrength(), (boolean)false, (boolean)true, (boolean)false, EntityLivingBase.class, (Predicate)RayTracer.ignoreEntityFilter(null));
                if (hit != null && hit.field_72308_g != null && AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), (Entity)hit.field_72308_g)) {
                    Vec3d direction = new Vec3d(hit.field_72308_g.field_70165_t, hit.field_72308_g.field_70163_u + (double)(hit.field_72308_g.field_70131_O / 2.0f), hit.field_72308_g.field_70161_v).func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(velocity.func_72433_c());
                    this.field_70159_w += 2.0 * (direction.field_72450_a - this.field_70159_w) / 15.0;
                    this.field_70181_x += 2.0 * (direction.field_72448_b - this.field_70181_x) / 15.0;
                    this.field_70179_y += 2.0 * (direction.field_72449_c - this.field_70179_y) / 15.0;
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f3 = 0.99f;
            if (this.func_70090_H()) {
                for (int l = 0; l < 4; ++l) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f3 = 0.8f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            if (this.doDeceleration()) {
                this.field_70159_w *= (double)f3;
                this.field_70181_x *= (double)f3;
                this.field_70179_y *= (double)f3;
            }
            if (this.doGravity()) {
                this.field_70181_x -= 0.05;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70186_c(double x, double y, double z, float speed, float randomness) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randomness;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randomness;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randomness;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.field_70159_w = p_70016_1_;
        this.field_70181_x = p_70016_3_;
        this.field_70179_y = p_70016_5_;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(p_70016_1_ * p_70016_1_ + p_70016_5_ * p_70016_5_));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(p_70016_1_, p_70016_5_) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(p_70016_3_, f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74777_a("xTile", (short)this.blockX);
        tag.func_74777_a("yTile", (short)this.blockY);
        tag.func_74777_a("zTile", (short)this.blockZ);
        tag.func_74777_a("life", (short)this.ticksInGround);
        if (this.stuckInBlock != null) {
            ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.stuckInBlock.func_177230_c());
            tag.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        }
        tag.func_74774_a("inData", (byte)this.inData);
        tag.func_74774_a("shake", (byte)this.arrowShake);
        tag.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        tag.func_74776_a("damageMultiplier", this.damageMultiplier);
        tag.func_74768_a("element", this.element.ordinal());
        tag.func_74768_a("lifetime", this.lifetime);
        if (this.getCaster() != null) {
            tag.func_186854_a("casterUUID", this.getCaster().func_110124_au());
        }
        tag.func_74768_a("amount", this.amount);
        NBTExtras.storeTagSafely((NBTTagCompound)tag, (String)"words", (NBTBase)NBTExtras.listToNBT(this.words, NBTTagString::new));
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.blockX = tag.func_74765_d("xTile");
        this.blockY = tag.func_74765_d("yTile");
        this.blockZ = tag.func_74765_d("zTile");
        this.ticksInGround = tag.func_74765_d("life");
        this.inData = tag.func_74771_c("inData") & 0xFF;
        this.arrowShake = tag.func_74771_c("shake") & 0xFF;
        this.inGround = tag.func_74771_c("inGround") == 1;
        this.damageMultiplier = tag.func_74760_g("damageMultiplier");
        this.element = Element.values()[tag.func_74762_e("element")];
        this.lifetime = tag.func_74762_e("lifetime");
        this.casterUUID = tag.func_186857_a("casterUUID");
        this.amount = tag.func_74762_e("amount");
        this.words = (List)NBTExtras.NBTToList((NBTTagList)tag.func_150295_c("words", 8), NBTTagString::func_150285_a_);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.element.ordinal());
        buffer.writeInt(this.lifetime);
        if (this.getCaster() != null) {
            buffer.writeInt(this.getCaster().func_145782_y());
        }
        buffer.writeInt(this.amount);
        for (String word : this.words) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)word);
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        this.element = Element.values()[buffer.readInt()];
        this.lifetime = buffer.readInt();
        if (buffer.isReadable()) {
            this.caster = new WeakReference<EntityLivingBase>((EntityLivingBase)this.field_70170_p.func_73045_a(buffer.readInt()));
        }
        this.amount = buffer.readInt();
        if (this.amount > -1) {
            for (int i = 0; i < this.amount; ++i) {
                this.words.add(i, ByteBufUtils.readUTF8String((ByteBuf)buffer));
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        return WizardrySounds.SPELLS;
    }

    protected void func_70088_a() {
    }
}

