/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.entity.summon;

import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.entity.ai.EntityAICasterHurtByTarget;
import astramusfate.wizardry_tales.entity.ai.EntityAICasterHurtTarget;
import astramusfate.wizardry_tales.spells.TalesSpells;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityEmber
extends EntitySummonedCreature {
    private static final DataParameter<Boolean> SPAWN_PARTICLES = EntityDataManager.func_187226_a(EntityEmber.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityEmber.class, (DataSerializer)DataSerializers.field_187198_h);
    @Nullable
    private BlockPos boundOrigin;
    private int lifetime = -1;
    private UUID casterUUID;

    public EntityEmber(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70765_h = new AIMoveControl(this);
        this.field_70728_aV = 0;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public UUID func_184753_b() {
        return this.casterUUID;
    }

    @Nullable
    public Entity func_70902_q() {
        return this.getCaster();
    }

    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(SPAWN_PARTICLES, (Object)true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new AIMoveRandom());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAICasterHurtByTarget((ISummonedCreature)this, (EntityCreature)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAICasterHurtTarget((ISummonedCreature)this, (EntityCreature)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, this.getTargetSelector()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected int func_70693_a(@Nonnull EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    public boolean func_98052_bS() {
        return false;
    }

    @Nullable
    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setBoundOrigin(new BlockPos((Entity)this));
        return super.func_180482_a(difficulty, livingdata);
    }

    public Element getElement() {
        return Element.FIRE;
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    public float func_180484_a(@Nonnull BlockPos pos) {
        return 1.0f;
    }

    protected float func_70672_c(@Nonnull DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_82725_o()) {
            damage *= 0.25f;
        }
        if (source.func_76347_k() || source.field_76373_n.equals(MagicDamage.DamageType.FIRE.name())) {
            damage = 0.0f;
        }
        return damage;
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.updateDelegate();
        this.func_189654_d(true);
        if (this.field_70170_p.field_72995_K) {
            Vec3d centre = this.func_174791_d().func_178787_e(new Vec3d(0.0, (double)(this.field_70131_O / 2.0f), 0.0));
            int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(this.getElement());
            if (this.field_70146_Z.nextInt(10) == 0) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)this).pos(0.0, (double)(this.field_70131_O / 2.0f), 0.0).scale(this.field_70130_N).time(48).clr(colours[0]).spawn(this.field_70170_p);
            }
            double r = this.field_70130_N / 3.0f;
            double x = r * (this.field_70146_Z.nextDouble() * 2.0 - 1.0);
            double y = r * (this.field_70146_Z.nextDouble() * 2.0 - 1.0);
            double z = r * (this.field_70146_Z.nextDouble() * 2.0 - 1.0);
            if (this.field_70725_aQ > 0) {
                for (int i = 0; i < 8; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE, (Random)this.field_70146_Z, (double)(centre.field_72450_a + x), (double)(centre.field_72448_b + y), (double)(centre.field_72449_c + z), (double)0.1, (boolean)true).scale(2.0f).time(12).clr(colours[1]).fade(colours[2]).spawn(this.field_70170_p);
                }
            } else {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(centre.field_72450_a + x, centre.field_72448_b + y, centre.field_72449_c + z).vel(x * -0.03, 0.02, z * -0.03).time(24 + this.field_70146_Z.nextInt(8)).clr(colours[1]).fade(colours[2]).spawn(this.field_70170_p);
            }
        }
        if (Solver.doEvery(this.field_70173_aa, 2.0) && this.getCaster() != null && !this.field_70170_p.field_72995_K) {
            this.setBoundOrigin(this.getCaster().func_180425_c());
        }
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (this.shouldRevengeTarget(entity)) {
            super.func_70604_c(entity);
        }
    }

    public void onSpawn() {
        if (((Boolean)this.field_70180_af.func_187225_a(SPAWN_PARTICLES)).booleanValue()) {
            this.spawnParticleEffect();
        }
    }

    public void onDespawn() {
        this.spawnParticleEffect();
    }

    private void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 2.0f), this.field_70161_v + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean hasParticleEffect() {
        return true;
    }

    public boolean hasRangedAttack() {
        return false;
    }

    public boolean hasAnimation() {
        return (Boolean)this.field_70180_af.func_187225_a(SPAWN_PARTICLES) != false || this.field_70173_aa > 20;
    }

    public void hideParticles() {
        this.field_70180_af.func_187227_b(SPAWN_PARTICLES, (Object)false);
    }

    protected boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    protected SoundEvent func_184639_G() {
        return WizardrySounds.ENTITY_REMNANT_AMBIENT;
    }

    protected SoundEvent func_184615_bR() {
        return WizardrySounds.ENTITY_REMNANT_DEATH;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return WizardrySounds.ENTITY_REMNANT_HURT;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        if (EntityUtils.isLiving((Entity)entityIn) && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)entityIn)) {
            int i = 0;
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
            boolean flag = entityIn.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)this.getCaster(), (MagicDamage.DamageType)MagicDamage.DamageType.FIRE), TalesSpells.summon_ember.getProperty("direct_damage").floatValue());
            if (flag) {
                int j;
                entityIn.func_70015_d(TalesSpells.summon_ember.getProperty("burn_duration").intValue());
                this.setAttacking(false);
                if (i > 0) {
                    ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                }
                if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                    entityIn.func_70015_d(j * 4);
                }
                if (entityIn instanceof EntityPlayer) {
                    ItemStack itemstack1;
                    EntityPlayer entityplayer = (EntityPlayer)entityIn;
                    ItemStack itemstack = this.func_184614_ca();
                    ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                    if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                        float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                        if (this.field_70146_Z.nextFloat() < f1) {
                            entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                            this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                        }
                    }
                }
                this.func_174815_a((EntityLivingBase)this, entityIn);
            }
            return flag;
        }
        return false;
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.readNBTDelegate(nbt);
        if (nbt.func_74764_b("BoundOrigin")) {
            this.boundOrigin = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("BoundOrigin"));
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.writeNBTDelegate(nbt);
        if (this.boundOrigin != null) {
            nbt.func_74782_a("BoundOrigin", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.boundOrigin));
        }
    }

    protected boolean func_70692_ba() {
        return this.getCaster() == null && this.func_184753_b() == null;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        if (this.getCaster() != null) {
            return new TextComponentTranslation("entity.ebwizardry:summonedcreature.nameplate", new Object[]{this.getCaster().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.getCaster() != null;
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityEmber.this.func_70605_aq().func_75640_a() && EntityEmber.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityEmber.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityEmber.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityEmber.this.field_70146_Z.nextInt(15) - 7, EntityEmber.this.field_70146_Z.nextInt(11) - 5, EntityEmber.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityEmber.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityEmber.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityEmber.this.func_70638_az() != null) break;
                EntityEmber.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityEmber host) {
            super((EntityLiving)host);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityEmber.this.field_70165_t;
                double d1 = this.field_75647_c - EntityEmber.this.field_70163_u;
                double d2 = this.field_75644_d - EntityEmber.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityEmber.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityEmber.this.field_70159_w *= 0.5;
                    EntityEmber.this.field_70181_x *= 0.5;
                    EntityEmber.this.field_70179_y *= 0.5;
                } else {
                    EntityEmber.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityEmber.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityEmber.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityEmber.this.func_70638_az() == null) {
                        EntityEmber.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityEmber.this.field_70159_w, (double)EntityEmber.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityEmber.this.func_70638_az().field_70165_t - EntityEmber.this.field_70165_t;
                        double d5 = EntityEmber.this.func_70638_az().field_70161_v - EntityEmber.this.field_70161_v;
                        EntityEmber.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                    EntityEmber.this.field_70761_aq = EntityEmber.this.field_70177_z;
                }
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityEmber.this.func_70638_az() != null && !EntityEmber.this.func_70605_aq().func_75640_a() && EntityEmber.this.field_70146_Z.nextInt(7) == 0) {
                return EntityEmber.this.func_70068_e((Entity)EntityEmber.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityEmber.this.func_70605_aq().func_75640_a() && EntityEmber.this.isAttacking() && EntityEmber.this.func_70638_az() != null && EntityEmber.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityEmber.this.func_70638_az();
            if (entitylivingbase == null) {
                return;
            }
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityEmber.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityEmber.this.setAttacking(true);
        }

        public void func_75251_c() {
            EntityEmber.this.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase living = EntityEmber.this.func_70638_az();
            if (living == null) {
                return;
            }
            if (EntityEmber.this.func_174813_aQ().func_72326_a(living.func_174813_aQ())) {
                EntityEmber.this.func_70652_k((Entity)living);
            } else {
                double d0 = EntityEmber.this.func_70068_e((Entity)living);
                if (d0 < 9.0) {
                    Vec3d vec3d = living.func_174824_e(1.0f);
                    EntityEmber.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }
}

