/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.events;

import astramusfate.wizardry_tales.api.Aterna;
import astramusfate.wizardry_tales.api.Sage;
import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.api.Thief;
import astramusfate.wizardry_tales.api.Wizard;
import astramusfate.wizardry_tales.data.EventsBase;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.Mana;
import astramusfate.wizardry_tales.data.cap.SoulProvider;
import astramusfate.wizardry_tales.registry.TalesEffects;
import com.google.common.collect.Lists;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.misc.Forfeit;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="wizardry_tales")
public class EventsHandler
extends EventsBase {
    private static final List<SpellCastEvent.Source> sourceList = Lists.newArrayList((Object[])new SpellCastEvent.Source[]{SpellCastEvent.Source.WAND, SpellCastEvent.Source.SCROLL, SpellCastEvent.Source.OTHER});

    @SubscribeEvent
    public static void onPlayerTickCastingRingCooldown(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        ISoul soul;
        if (event.phase == TickEvent.Phase.START && event.player.field_70173_aa > 5 && (soul = (ISoul)(player = event.player).getCapability(SoulProvider.SOUL_CAP, null)) != null) {
            if (soul.getCooldown() > 0) {
                soul.decreaseCooldown(event.player, 1);
            }
            if (Tales.mp.lowOnMana && !event.player.func_184812_l_() && Solver.doEvery((Entity)player, 1.0)) {
                if (soul.getMP() <= soul.getMaxMP() * 0.25) {
                    player.func_71020_j(0.01f);
                    player.func_70690_d(new PotionEffect(TalesEffects.magic_exhaust, Solver.asTicks(2.0), 0, true, false));
                }
                if (soul.getMP() <= soul.getMaxMP() * (double)0.1f) {
                    player.func_71020_j(0.02f);
                    player.func_70690_d(new PotionEffect(TalesEffects.magic_exhaust, Solver.asTicks(2.0), 5, true, false));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void castCostReplacement(SpellCastEvent.Pre event) {
        event.getModifiers().set(Sage.CHANT_COST, event.getModifiers().get("cost"), true);
        if (Tales.mp.noMoreManaUse && Tales.mp.manaPool) {
            event.getModifiers().set("cost", 0.0f, true);
        }
    }

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("wizardry_tales")) {
            ConfigManager.sync((String)"wizardry_tales", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ISoul soul;
        if (event.phase == TickEvent.Phase.START && Solver.doEvery((Entity)event.player, Tales.mp.seconds_frequency) && (soul = (ISoul)event.player.getCapability(SoulProvider.SOUL_CAP, null)) != null) {
            double additional = Tales.mp.bonus_regen * (soul.getMaxMP() / Tales.mp.max);
            soul.addMana(event.player, Tales.mp.regeneration + additional);
        }
    }

    @SubscribeEvent
    public static void canCastSpell(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() instanceof ISpellCastingItem) {
            double mana;
            EntityPlayer player = event.getEntityPlayer();
            ISoul soul = Mana.getSoul(player);
            Spell spell = WandHelper.getCurrentSpell((ItemStack)event.getItemStack());
            if (WandHelper.getCurrentCooldown((ItemStack)event.getItemStack()) > 0) {
                EventsHandler.cancel((Event)event);
                return;
            }
            if (soul == null) {
                return;
            }
            if (EventsHandler.isValid(spell) && !player.func_184812_l_() && Tales.mp.manaPool && (mana = soul.getMP()) < EventsHandler.getCost(spell)) {
                EventsHandler.cancel((Event)event);
                Aterna.translate(player, true, "mana.not_enough");
            }
        }
    }

    @SubscribeEvent
    public static void canSpellContinuous(SpellCastEvent.Tick event) {
        if (event.getCaster() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            ISoul soul = Mana.getSoul(player);
            Spell spell = event.getSpell();
            if (soul != null && EventsHandler.isValid(spell) && !player.func_184812_l_() && Tales.mp.manaPool) {
                double mana = soul.getMP();
                if (mana < (double)EventsHandler.getDistributedCost(spell, event.getCount())) {
                    EventsHandler.cancel((Event)event);
                } else {
                    soul.addMana(player, (float)(-EventsHandler.getDistributedCost(spell, event.getCount())) * event.getModifiers().get(Sage.CHANT_COST));
                }
            }
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void learnSpell(SpellCastEvent.Pre event) {
        if (event.getCaster() instanceof EntityPlayer) {
            WizardData data;
            EntityPlayer player = (EntityPlayer)event.getCaster();
            ISoul soul = Mana.getSoul(player);
            Spell spell = event.getSpell();
            if (soul != null && spell != Spells.none && spell.getCost() > 0 && Tales.mp.manaPool && (data = WizardData.get((EntityPlayer)player)) != null && data.hasSpellBeenDiscovered(spell)) {
                int progress = soul.getLearned(spell);
                int chance = 0;
                if (progress >= 0) {
                    chance = 100;
                    if (progress >= 3) {
                        chance = 80;
                        if (progress >= 5) {
                            chance = 50;
                            if (progress >= 8) {
                                chance = 25;
                                if (progress >= 10) {
                                    chance = 0;
                                }
                            }
                        }
                    }
                }
                if (Tales.addon.learning) {
                    if (progress == 10) {
                        if (!player.field_70170_p.field_72995_K) {
                            Aterna.translate(player, false, "mana.learned");
                            Aterna.translate(player, true, "mana.keep_trying10");
                        }
                        EntityUtils.playSoundAtPlayer((EntityPlayer)player, (SoundEvent)WizardrySounds.MISC_DISCOVER_SPELL, (float)1.25f, (float)1.0f);
                        Wizard.castBuff(player.field_70170_p, (Entity)player, 14061575);
                    } else if (progress < 10 && !player.field_70170_p.field_72995_K) {
                        Aterna.translate(player, true, "mana.keep_trying" + progress);
                    }
                    if (data.synchronisedRandom.nextFloat() < (float)chance / 100.0f) {
                        soul.learnSpell(player, spell);
                        EventsHandler.fail(player, spell, event.getModifiers());
                        EntityUtils.playSoundAtPlayer((EntityPlayer)player, (SoundEvent)WizardrySounds.MISC_SPELL_FAIL, (SoundCategory)WizardrySounds.SPELLS, (float)1.0f, (float)1.0f);
                        EventsHandler.cancel((Event)event);
                        if (event.getWorld().field_72995_K) {
                            Vec3d centre = event.getCaster().func_174824_e(1.0f).func_178787_e(event.getCaster().func_70040_Z());
                            for (int i = 0; i < 5; ++i) {
                                double x = centre.field_72450_a + (double)(0.5f * (event.getWorld().field_73012_v.nextFloat() - 0.5f));
                                double y = centre.field_72448_b + (double)(0.5f * (event.getWorld().field_73012_v.nextFloat() - 0.5f));
                                double z = centre.field_72449_c + (double)(0.5f * (event.getWorld().field_73012_v.nextFloat() - 0.5f));
                                event.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                            }
                        }
                        return;
                    }
                }
                if (Tales.addon.learning) {
                    soul.learnSpell(player, spell);
                }
            }
        }
    }

    public static void fail(EntityPlayer player, Spell spell, SpellModifiers modifiers) {
        ItemStack stack = Thief.getSpellCasting((EntityLivingBase)player);
        if (player.func_184812_l_()) {
            return;
        }
        Forfeit forfeit = Forfeit.getRandomForfeit((Random)WizardData.get((EntityPlayer)player).synchronisedRandom, (Tier)spell.getTier(), (Element)spell.getElement());
        if (forfeit == null) {
            return;
        }
        forfeit.apply(player.field_70170_p, player);
        WizardryAdvancementTriggers.spell_failure.triggerFor(player);
        EntityUtils.playSoundAtPlayer((EntityPlayer)player, (SoundEvent)forfeit.getSound(), (SoundCategory)WizardrySounds.SPELLS, (float)1.0f, (float)1.0f);
        if (stack != null && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemScroll) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            } else if (stack.func_77973_b() instanceof IManaStoringItem) {
                int cost = (int)((float)spell.getCost() * modifiers.get(Sage.CHANT_COST) + 0.1f);
                ((IManaStoringItem)stack.func_77973_b()).consumeMana(stack, cost, (EntityLivingBase)player);
            }
            if (stack.func_77973_b() instanceof ISpellCastingItem) {
                WandHelper.setCurrentCooldown((ItemStack)stack, (int)40);
            }
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 40);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void castSpell(SpellCastEvent.Pre event) {
        if (event.getCaster() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            ISoul soul = Mana.getSoul(player);
            Spell spell = event.getSpell();
            if (soul != null && EventsHandler.isValid(spell) && !player.func_184812_l_() && Tales.mp.manaPool) {
                double mana = soul.getMP();
                if (mana < EventsHandler.getCost(spell)) {
                    EventsHandler.cancel((Event)event);
                    Aterna.translate(player, true, "mana.not_enough");
                } else {
                    soul.addMana(player, -EventsHandler.getCost(spell) * (double)event.getModifiers().get(Sage.CHANT_COST));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void gainManaPool(SpellCastEvent.Post event) {
        if (event.getCaster() instanceof EntityPlayer && !event.isCanceled() && sourceList.contains(event.getSource()) && Tales.mp.manaPool) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            ISoul soul = Mana.getSoul(player);
            Spell spell = event.getSpell();
            if (soul != null && EventsHandler.isValid(spell)) {
                double maxMana = soul.getMaxMP();
                double value = maxMana + Math.max(Tales.mp.progression * (Tales.mp.progression_multiplier * (EventsHandler.getCost(spell) / maxMana)), Tales.mp.progression);
                soul.setMaxMP(player, Math.min(value, Tales.mp.max));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void gainManaPoolContinuous(SpellCastEvent.Finish event) {
        if (event.getCaster() instanceof EntityPlayer && !event.isCanceled() && sourceList.contains(event.getSource()) && event.getSpell().isContinuous && Tales.mp.manaPool) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            ISoul soul = Mana.getSoul(player);
            Spell spell = event.getSpell();
            int castingTick = event.getCount();
            if (soul != null && EventsHandler.isValid(spell)) {
                double maxMana = soul.getMaxMP();
                double value = maxMana + Math.max(Tales.mp.progression * (Tales.mp.progression_multiplier * (EventsHandler.getContinuousProgression(spell, castingTick) / maxMana)), Tales.mp.progression);
                soul.setMaxMP(player, Math.min(value, Tales.mp.max));
            }
        }
    }

    public static double getCost(Spell spell) {
        return Tales.mp.spell_multiplier * (double)(Tales.mp.isCastingCostBased ? spell.getCost() : (spell.getTier().ordinal() + 1) * spell.getTier().ordinal() + 1);
    }

    protected static int getDistributedCost(Spell spell, int castingTick) {
        double cost = EventsHandler.getCost(spell);
        int partialCost = castingTick % 20 == 0 ? (int)(cost / 2.0 + cost % 2.0) : (castingTick % 10 == 0 ? (int)(cost / 2.0) : 0);
        return partialCost;
    }

    protected static double getContinuousProgression(Spell spell, int castingTick) {
        return EventsHandler.getCost(spell) * ((double)castingTick / 20.0);
    }

    public static boolean isValid(Spell spell) {
        return spell != Spells.none && spell.getCost() > 0;
    }

    @SubscribeEvent
    public static void entityTickDisappear(LivingEvent.LivingUpdateEvent event) {
        int lifetime;
        EntityLivingBase living;
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        if (event.getEntityLiving().getEntityData().func_74764_b("lifetime") && living.field_70173_aa >= (lifetime = (living = event.getEntityLiving()).getEntityData().func_74762_e("lifetime"))) {
            living.func_70106_y();
            if (living.field_70170_p.field_72995_K) {
                Random rand = new Random();
                for (int i = 0; i < 15; ++i) {
                    living.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, living.field_70165_t + (double)rand.nextFloat() - 0.5, living.field_70163_u + (double)(rand.nextFloat() * 2.0f), living.field_70161_v + (double)rand.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void mobDrop(LivingDropsEvent event) {
        if (!Tales.addon.monsters_drop_crystals) {
            return;
        }
        if (event.getEntityLiving() instanceof IMob && (event.getSource().func_76346_g() instanceof EntityPlayer || event.getSource().func_76346_g() instanceof IProjectile || event.getSource().func_76346_g() instanceof IThrowableEntity)) {
            EntityLivingBase living = event.getEntityLiving();
            if (!event.getDrops().isEmpty()) {
                EntityItem item = new EntityItem(living.func_130014_f_(), living.field_70165_t, living.field_70163_u, living.field_70161_v);
                ItemStack stack = EventsHandler.getCrystalDrop(living.func_110138_aP(), !living.func_184222_aU());
                if (stack != null) {
                    item.func_92058_a(stack);
                    item.func_174867_a(10);
                    event.getDrops().add(item);
                }
            }
        }
    }

    public static ItemStack getCrystalDrop(float maxHP, boolean boss) {
        ItemStack stack = null;
        if (maxHP > 0.0f) {
            stack = new ItemStack(WizardryItems.crystal_shard);
            if (maxHP >= 15.0f) {
                stack = new ItemStack(Solver.chance(60) ? WizardryItems.crystal_shard : WizardryItems.magic_crystal);
                if (maxHP >= 30.0f) {
                    stack = new ItemStack(WizardryItems.magic_crystal);
                    if (maxHP >= 60.0f) {
                        stack = new ItemStack(Solver.chance(65) ? WizardryItems.magic_crystal : WizardryItems.grand_crystal);
                        if (maxHP >= 150.0f || maxHP >= 100.0f && boss) {
                            stack = new ItemStack(WizardryItems.grand_crystal);
                        }
                    }
                }
            }
        }
        return stack;
    }
}

