/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.events;

import astramusfate.wizardry_tales.WizardryTales;
import astramusfate.wizardry_tales.api.Aterna;
import astramusfate.wizardry_tales.api.Sage;
import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.api.Tenebria;
import astramusfate.wizardry_tales.api.Thief;
import astramusfate.wizardry_tales.api.Wizard;
import astramusfate.wizardry_tales.api.classes.IInscribed;
import astramusfate.wizardry_tales.chanting.Chanting;
import astramusfate.wizardry_tales.chanting.SpellPart;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.Mana;
import astramusfate.wizardry_tales.data.chanting.SpellParams;
import astramusfate.wizardry_tales.entity.construct.EntityMagic;
import astramusfate.wizardry_tales.entity.construct.EntityMagicCircle;
import astramusfate.wizardry_tales.entity.construct.EntityMagicScaled;
import astramusfate.wizardry_tales.entity.construct.sigils.EntityMagicCircleVertical;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCircleAreaOnceCast;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCircleArray;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCustomSigil;
import astramusfate.wizardry_tales.events.SpellCreationHelper;
import astramusfate.wizardry_tales.events.SpellcastingHandler;
import astramusfate.wizardry_tales.registry.TalesEffects;
import astramusfate.wizardry_tales.registry.TalesItems;
import com.google.common.collect.Lists;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class SpellCreation
extends SpellCreationHelper {
    public static final String keyword = "mana";

    @SubscribeEvent
    public static void spellCreationServerEvent(ServerChatEvent event) {
        String msg = SpellCreation.getMsg(event.getMessage());
        EntityPlayerMP player = event.getPlayer();
        List<String> spell = SpellCreation.getSpell(msg);
        if (!SpellCreation.containsAny(spell, Arrays.asList(keyword.toLowerCase(Locale.ROOT).split(" ")))) {
            return;
        }
        SpellCreation.createSpell(spell, (Entity)player, (Entity)player, true, event.getMessage());
        Style style = event.getComponent().func_150256_b().func_150238_a(TextFormatting.GOLD);
        event.setComponent(event.getComponent().func_150255_a(style));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void spellCreationClientEvent(ClientChatEvent event) {
        String msg = SpellCreation.getMsg(event.getOriginalMessage());
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        List<String> spell = SpellCreation.getSpell(msg);
        if (!SpellCreation.containsAny(spell, Arrays.asList(keyword.toLowerCase(Locale.ROOT).split(" ")))) {
            return;
        }
        SpellCreation.createSpell(spell, (Entity)player, (Entity)player, false, event.getOriginalMessage());
    }

    public static void createSpell(List<String> words, Entity focal, Entity target, boolean isServer) {
        SpellCreation.createSpell(words, focal, target, isServer, null);
    }

    public static void createSpell(List<String> words, Entity focal, @Nullable Entity target, boolean isServer, @Nullable String original) {
        EntityLivingBase caster;
        SpellParams mods;
        World world;
        block11: {
            world = focal.field_70170_p;
            if (world == null) {
                return;
            }
            String[] spell = words.toArray(new String[0]);
            mods = new SpellParams();
            mods.world = world;
            mods.target = target;
            mods.focal = focal;
            mods.isServer = isServer;
            mods.original = original;
            caster = SpellCreation.getCaster(focal);
            mods.set = Lists.newArrayList();
            mods.set.addAll(Arrays.asList(spell));
            mods.stopCast = false;
            String previous = "";
            try {
                for (int i = 0; i < spell.length; ++i) {
                    String next = SpellCreation.getWord(spell, i, 1);
                    String next2 = SpellCreation.getWord(spell, i, 2);
                    String next3 = SpellCreation.getWord(spell, i, 3);
                    String next4 = SpellCreation.getWord(spell, i, 4);
                    String word = spell[i];
                    HashMap<String, String> keys = new HashMap<String, String>();
                    keys.put("word", word);
                    keys.put("next", next);
                    keys.put("next2", next2);
                    keys.put("next3", next3);
                    keys.put("next4", next4);
                    keys.put("previous", previous);
                    mods.keys = keys;
                    SpellCreation.raycast(world, caster, mods.shape.val(), mods);
                    if (mods.stopCast) break;
                    SpellCreation.calcMods(caster, mods);
                    if (mods.pos == null) {
                        if (!mods.isRay) {
                            mods.pos = focal.func_174791_d();
                        } else {
                            return;
                        }
                    }
                    mods.pos.func_178787_e(mods.change);
                    SpellCreation.shaping(caster, mods);
                    if (mods.stopCast) break;
                    SpellCreation.applyActions(caster, mods);
                    try {
                        if (next.equals("")) {
                            mods.set.remove(word);
                        }
                        mods.set.remove(previous);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    previous = word;
                }
            }
            catch (Exception exception) {
                WizardryTales.log.error("---- [Wizardry Tales] - problem occurred when Chanting! ----");
                exception.printStackTrace();
                WizardryTales.log.error("---- [Wizardry Tales] - problem occurred when Chanting! ----");
                if (caster instanceof EntityPlayer) {
                    Aterna.messageBar((EntityPlayer)caster, "Spell is broken!");
                }
                if (!Tales.chanting.debug) break block11;
                throw new RuntimeException(exception);
            }
        }
        SpellCreation.attachCastingVisual(world, caster, mods);
    }

    public static void shaping(@Nullable EntityLivingBase caster, SpellParams m) {
        int dynamicLifetime;
        String shape = m.shape.val();
        World world = m.world;
        String word = m.keys.get("word");
        String next = m.keys.get("next");
        String next2 = m.keys.get("next2");
        String next3 = m.keys.get("next3");
        String next4 = m.keys.get("next4");
        List<String> set = m.set;
        if (set == null) {
            return;
        }
        if (m.pos == null) {
            if (!m.isRay) {
                m.pos = m.focal.func_174791_d();
            } else {
                return;
            }
        }
        double dist = m.pos.func_72438_d(m.focal.func_174791_d());
        BlockPos pos = new BlockPos(m.pos);
        int n = dynamicLifetime = m.lifetime.num() < 0.0f ? -1 : Solver.asTicks(m.lifetime.num());
        if (SpellCreation.findIn(shape, "area") && SpellCreation.useMana(m.focal, dist)) {
            EntityCircleAreaOnceCast entity = new EntityCircleAreaOnceCast(world, set);
            entity.setLocation(m.element.func_176610_l());
            entity.setCaster(caster);
            if (m.canAlly) {
                entity.onlyAllies();
            }
            entity.filter = m.filter;
            entity.setLifetime(Solver.asTicks(1.0));
            entity.func_70080_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, m.focal.field_70177_z, m.focal.field_70125_A);
            entity.setSizeMultiplier(m.size.num());
            Tenebria.create(world, entity);
            m.stopCast = true;
            return;
        }
        if (SpellCreation.findIn(shape, "array") && SpellCreation.useMana(m.focal, dist)) {
            EntityCircleArray entity = new EntityCircleArray(world, set);
            entity.setLocation(m.element.func_176610_l());
            entity.setCaster(caster);
            if (m.canAlly) {
                entity.onlyAllies();
            }
            entity.filter = m.filter;
            entity.setLifetime(dynamicLifetime);
            entity.func_70080_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, m.focal.field_70177_z, m.focal.field_70125_A);
            entity.setSizeMultiplier(m.size.num());
            Tenebria.create(world, entity);
            m.stopCast = true;
            return;
        }
        if (SpellCreation.findIn(shape, "sigil") && SpellCreation.useMana(m.focal, dist)) {
            EntityCustomSigil entity = new EntityCustomSigil(world, set);
            entity.setLocation(m.element.func_176610_l());
            entity.hasOwner = m.hasOwner;
            entity.setCaster(caster);
            entity.setLifetime(dynamicLifetime);
            if (m.canAlly) {
                entity.onlyAllies();
            }
            entity.filter = m.filter;
            entity.func_70080_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, m.focal.field_70177_z, m.focal.field_70125_A);
            entity.setSizeMultiplier(m.size.num());
            if (world.func_72872_a(((Object)((Object)entity)).getClass(), entity.func_174813_aQ()).isEmpty()) {
                Tenebria.create(world, entity);
            }
            m.stopCast = true;
            return;
        }
        Integer number = SpellCreation.getInteger(next, Integer.MAX_VALUE);
        if (((Number)number).floatValue() == 2.1474836E9f) {
            number = 0;
        }
        if (SpellCreation.findInSmart(shape, "inscribe scribe") && caster instanceof EntityPlayer && m.original != null) {
            ItemStack stack = Thief.getInHands((EntityPlayer)caster);
            if (stack == null) {
                return;
            }
            ItemStack reagent = Thief.getItem((EntityPlayer)caster, p -> p.func_77973_b() == TalesItems.chanting_stone, new ItemStack(TalesItems.chanting_stone));
            if (reagent == null) {
                Aterna.messageBar((EntityPlayer)caster, "You need one Chanting Stone in inventory!");
                return;
            }
            reagent.func_190918_g(1);
            NBTTagCompound tag = SpellCreation.getOrCreateTagCompound(stack);
            if (stack.func_77973_b() instanceof ISpellCastingItem) {
                int id = SpellCreation.getChosenSpellIndex(stack);
                tag.func_74778_a("spell" + id, m.original);
            } else {
                tag.func_74778_a("spell", m.original);
            }
            if (SpellCreation.containsAny(set, Collections.singletonList("hide"))) {
                tag.func_74757_a("hidden", true);
            }
            Wizard.castParticles(world, Element.MAGIC, caster.func_174791_d(), 18);
            m.stopCast = true;
            return;
        }
        if (SpellCreation.findInSmart(shape, "adjust change") && caster instanceof EntityPlayer && m.original != null && SpellCreation.findIn(m.keys.get("previous"), "add set") && (SpellCreation.findIn(word, "parameter") || SpellCreation.findIn(word, "condition"))) {
            if (SpellCreation.findIn(word, "parameter")) {
                ItemStack stack = Thief.getInHands((EntityPlayer)caster, s -> !(s.func_77973_b() instanceof IInscribed) || s.func_77973_b() instanceof IInscribed && ((IInscribed)s.func_77973_b()).applyParameters());
                if (stack == null) {
                    return;
                }
                NBTTagCompound tag = SpellCreation.getOrCreateTagCompound(stack);
                if (number == 0 && tag.func_74764_b("parameter")) {
                    tag.func_82580_o("parameter");
                } else {
                    tag.func_74776_a("parameter", ((Number)number).floatValue());
                }
                Wizard.castParticles(world, Element.MAGIC, caster.func_174791_d(), 18);
                return;
            }
            if (SpellCreation.findIn(word, "condition")) {
                try {
                    set.remove("add");
                    set.remove("condition");
                }
                catch (Exception stack) {
                    // empty catch block
                }
                ItemStack stack = Thief.getInHands((EntityPlayer)caster, s -> !(s.func_77973_b() instanceof IInscribed) || s.func_77973_b() instanceof IInscribed && ((IInscribed)s.func_77973_b()).applyConditions());
                if (stack == null) {
                    return;
                }
                ItemStack reagent = Thief.getItem((EntityPlayer)caster, p -> p.func_77973_b() == TalesItems.chanting_stone, new ItemStack(TalesItems.chanting_stone));
                if (reagent == null) {
                    Aterna.messageBar((EntityPlayer)caster, "You need one Chanting Stone in inventory!");
                    return;
                }
                reagent.func_190918_g(1);
                String condition = SpellCreation.findWithin(conditions, "", next, next2, next3, next4);
                if (!condition.equals("") && SpellcastingHandler.checkCondition(stack, condition)) {
                    NBTTagCompound tag = SpellCreation.getOrCreateTagCompound(stack);
                    tag.func_74778_a("condition", condition);
                }
                Wizard.castParticles(world, Element.MAGIC, caster.func_174791_d(), 18);
            }
        }
    }

    public static void raycast(World world, @Nullable EntityLivingBase caster, String shape, SpellParams m) {
        if (SpellCreation.findIn(shape, "entity entities")) {
            boolean finalCanAlly = m.canAlly;
            RayTraceResult ray = Solver.standardEntityRayTrace(world, m.focal, m.range.num(), false, e -> {
                if (e == caster || e == m.focal) {
                    return true;
                }
                if (e instanceof EntityLivingBase) {
                    return AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)((EntityLivingBase)e)) && !finalCanAlly || ((EntityLivingBase)e).field_70725_aQ > 0;
                }
                return false;
            });
            if (ray != null && ray.field_72313_a == RayTraceResult.Type.ENTITY && ray.field_72308_g != null) {
                m.target = ray.field_72308_g;
                m.pos = ray.field_72308_g.func_174791_d();
            } else {
                m.stopCast = true;
            }
            m.isRay = true;
            m.castingTargeting = 2;
            return;
        }
        if (SpellCreation.findIn(shape, "block blocks")) {
            RayTraceResult blockRay = Solver.standardBlockRayTrace(world, m.focal, m.range.num(), false, true, false);
            if (blockRay != null) {
                if (blockRay.field_72313_a == RayTraceResult.Type.BLOCK) {
                    m.pos = new Vec3d((Vec3i)blockRay.func_178782_a().func_177972_a(blockRay.field_178784_b));
                }
                if (blockRay.field_72313_a == RayTraceResult.Type.ENTITY && blockRay.field_72308_g != null) {
                    m.pos = blockRay.field_72308_g.func_174791_d();
                }
            }
            if (blockRay == null || blockRay.field_72313_a == RayTraceResult.Type.MISS) {
                m.stopCast = true;
            }
            m.isRay = true;
            m.castingTargeting = 1;
        }
    }

    public static void calcMods(@Nullable EntityLivingBase caster, SpellParams mods) {
        String word = mods.keys.get("word");
        String next = mods.keys.get("next");
        String next2 = mods.keys.get("next2");
        String next3 = mods.keys.get("next3");
        String next4 = mods.keys.get("next4");
        String previous = mods.keys.get("previous");
        Number number = SpellCreation.getFloat(next, next2, next3, 2.1474836E9f);
        if (number.intValue() != Integer.MAX_VALUE) {
            mods.calcParam(word, number);
        }
        mods.calcParam(word, next);
        if (SpellCreation.findIn(word, "focus")) {
            if (SpellCreation.findIn(next, "caster") && caster != null) {
                mods.target = caster;
            }
            if (SpellCreation.findIn(next, "focal") && mods.focal != null) {
                mods.target = mods.focal;
            }
            if (SpellCreation.findIn(next, "block blocks")) {
                mods.castingTargeting = 1;
            }
            if (SpellCreation.findIn(next, "entity entities")) {
                mods.castingTargeting = 1;
            }
        }
        if (SpellCreation.findIn(word, "owner")) {
            if (SpellCreation.findIn(previous, "add")) {
                mods.hasOwner = true;
            }
            if (SpellCreation.findIn(previous, "remove")) {
                mods.hasOwner = false;
            }
        }
        if (SpellCreation.findIn(word, "allies ally")) {
            if (SpellCreation.findIn(previous, "add allow")) {
                mods.canAlly = true;
            }
            if (SpellCreation.findIn(previous, "remove disallow")) {
                mods.canAlly = false;
            }
        }
        if (SpellCreation.findIn(word, "filter")) {
            if (SpellCreation.findIn(next, "mobs")) {
                mods.filter = e -> e instanceof IMob;
            } else if (SpellCreation.findIn(next, "construct constructs magic")) {
                mods.filter = e -> e instanceof EntityMagicConstruct || e instanceof EntityMagic;
            } else if (SpellCreation.findIn(next, "player players human humans")) {
                mods.filter = e -> e instanceof EntityPlayer || e instanceof EntityWizard || e instanceof EntityEvilWizard;
            } else if (SpellCreation.findIn(next, "undead undeads")) {
                mods.filter = e -> e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70662_br();
            } else if (SpellCreation.findIn(next, "creature creatures")) {
                mods.filter = e -> e instanceof EntityCreature;
            } else if (SpellCreation.findIn(next, "living")) {
                mods.filter = e -> e instanceof EntityLivingBase;
            } else if (SpellCreation.findIn(next, "entity entities")) {
                mods.filter = e -> !(e instanceof EntityLivingBase);
            } else if (SpellCreation.findIn(next, "ally allies")) {
                mods.filter = e -> e == caster || e instanceof EntityLivingBase && AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)((EntityLivingBase)e));
                mods.canAlly = true;
            }
        }
        if (SpellCreation.findIn(word, "element")) {
            if (SpellCreation.findIn(next, "magic arcane")) {
                mods.element = Element.MAGIC;
            } else if (SpellCreation.findIn(next, "fire blaze")) {
                mods.element = Element.FIRE;
            } else if (SpellCreation.findIn(next, "ice frost")) {
                mods.element = Element.ICE;
            } else if (SpellCreation.findIn(next, "earth nature wind water")) {
                mods.element = Element.EARTH;
            } else if (SpellCreation.findIn(next, "lightning storm thunder")) {
                mods.element = Element.LIGHTNING;
            } else if (SpellCreation.findIn(next, "necromancy darkness")) {
                mods.element = Element.NECROMANCY;
            } else if (SpellCreation.findIn(next, "healing heal light")) {
                mods.element = Element.HEALING;
            } else if (SpellCreation.findIn(next, "sorcery time")) {
                mods.element = Element.SORCERY;
            }
        }
        if (SpellCreation.findIn(word, "effects fx")) {
            if (SpellCreation.findInSmart(previous + " " + next, "off disable remove")) {
                mods.hasEffects = false;
            }
            if (SpellCreation.findInSmart(previous + " " + next, "on enable add")) {
                mods.hasEffects = true;
            }
        }
        for (SpellPart param : Chanting.params) {
            param.useParam(caster, mods);
        }
    }

    public static void attachCastingVisual(World world, @Nullable EntityLivingBase caster, SpellParams mods) {
        if (caster != null && mods.focal == caster && mods.hasEffects) {
            caster.func_184185_a(WizardrySounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND, 0.4f, 1.2f + Solver.randFloat(-0.2f, 0.4f));
            if (!world.field_72995_K) {
                if (mods.isRay) {
                    EntityMagicCircleVertical circle = Wizard.getVerticalCircle(world, "construct", caster.func_174791_d(), (Entity)caster);
                    circle.setSizeMultiplier(2.0f);
                    Tenebria.create(world, circle);
                } else {
                    EntityMagicCircle circle = Wizard.getCircle(world, "construct", caster.func_174791_d());
                    circle.setSizeMultiplier(3.0f);
                    Tenebria.create(world, circle);
                }
            } else {
                if (mods.isBuff) {
                    Wizard.castBuff(world, mods.target, 14055691);
                }
                Wizard.castParticles(world, mods.element, mods.target.func_174791_d());
            }
        }
    }

    public static void applyActions(@Nullable EntityLivingBase caster, SpellParams m) {
        BlockPos otherHalf;
        IBlockState state;
        EntityLiving entity;
        World world = m.focal.field_70170_p;
        if (world == null) {
            world = m.target.field_70170_p;
        }
        if (world == null) {
            return;
        }
        String word = m.keys.get("word");
        String next = m.keys.get("next");
        String next2 = m.keys.get("next2");
        String next3 = m.keys.get("next3");
        String next4 = m.keys.get("next4");
        String previous = m.keys.get("previous");
        Entity focal = m.focal;
        Entity target = m.target;
        if (target == null) {
            return;
        }
        Vec3d pos = m.pos;
        BlockPos spellBlock = new BlockPos(pos);
        float potency = m.potency.num();
        float duration = m.duration.num();
        float lifetime = m.lifetime.num();
        if (SpellCreation.findIn(word, "replicate replica") && target instanceof EntityPlayer) {
            if (next.split(":").length <= 1) {
                next = "ebwizardry:" + next;
            }
            Spell spell = null;
            try {
                spell = Spell.get((String)next);
                if (Arrays.asList(Tales.chanting.replicationBlacklist).contains(next)) {
                    spell = Spells.none;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (spell != null && spell != Spells.none) {
                EntityPlayer player = (EntityPlayer)target;
                ISoul soul = Mana.getSoul(player);
                SpellModifiers modifiers = new SpellModifiers();
                int seconds = Math.round(duration);
                int ticks = seconds * 20;
                modifiers.set("potency", 1.0f + potency / 10.0f, false);
                modifiers.set(Sage.BLAST, 1.0f + potency / 10.0f, false);
                modifiers.set(Sage.RANGE, 1.0f + m.range.num() / 10.0f, false);
                if (WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
                    Aterna.messageBar(player, TextFormatting.DARK_RED + "Spell isn't discovered!");
                    return;
                }
                if (soul != null && soul.getLearned(spell) < 10 && Tales.addon.learning) {
                    Aterna.messageBar(player, TextFormatting.DARK_RED + "Spell isn't learned!");
                    return;
                }
                int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
                if (spell.isContinuous) {
                    cost *= seconds;
                }
                if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)target, modifiers))) {
                    return;
                }
                cost = (int)((float)cost * modifiers.get(Sage.CHANT_COST) + 0.1f);
                if (spell.isContinuous) {
                    WizardData data = WizardData.get((EntityPlayer)player);
                    if (data != null) {
                        if (data.isCasting()) {
                            data.stopCastingContinuousSpell();
                        }
                        if (!SpellCreation.useMana(target, cost)) {
                            return;
                        }
                        data.startCastingContinuousSpell(spell, modifiers, ticks);
                    }
                } else {
                    if (!SpellCreation.useMana(target, cost)) {
                        return;
                    }
                    if (spell.cast(world, (EntityPlayer)target, EnumHand.MAIN_HAND, 0, modifiers)) {
                        MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)target, modifiers));
                        if (spell.requiresPacket()) {
                            PacketCastSpell.Message msg = new PacketCastSpell.Message(target.func_145782_y(), null, spell, modifiers);
                            WizardryPacketHandler.net.sendToDimension((IMessage)msg, target.field_70170_p.field_73011_w.getDimension());
                        }
                    }
                }
            }
        }
        if (SpellCreation.findIn(previous, "replicate replica")) {
            return;
        }
        if (SpellCreation.findIn(word, "summon") && !world.field_72995_K) {
            BlockPos position;
            if (next.split(":").length <= 1) {
                next = "ebwizardry:" + next;
            }
            entity = null;
            try {
                entity = (EntityLiving)((EntityEntry)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(Tales.toResourceLocation(next)))).newInstance(world);
                if (Arrays.asList(Tales.chanting.minionBlacklist).contains(next)) {
                    entity = null;
                }
            }
            catch (Exception player) {
                // empty catch block
            }
            if (entity instanceof EntityTameable || entity instanceof AbstractHorse) {
                m.element = Element.NECROMANCY;
                if (caster instanceof EntityPlayer && m.hasOwner) {
                    if (entity instanceof EntityTameable) {
                        ((EntityTameable)entity).func_193101_c((EntityPlayer)caster);
                    } else {
                        ((AbstractHorse)entity).func_110263_g((EntityPlayer)caster);
                        ((AbstractHorse)entity).func_110251_o(true);
                    }
                }
                entity.getEntityData().func_74768_a("lifetime", m.lifetime.num() < 0.0f ? 1 : Solver.asTicks(m.lifetime.num()));
                position = BlockUtils.findNearbyFloorSpace((Entity)target, (int)((int)(2.0f + m.range.num() / 10.0f)), (int)4);
                if (position != null && SpellCreation.useMana(focal, (double)(m.lifetime.num() / 10.0f * (m.health.num() / 2.0f) * m.potency.num()), true)) {
                    entity.func_70107_b((double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5);
                    entity.func_180482_a(world.func_175649_E(new BlockPos((Vec3i)position)), null);
                    try {
                        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)m.health.num());
                        entity.func_70606_j(entity.func_110138_aP());
                        entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)m.potency.num());
                    }
                    catch (Exception soul) {
                        // empty catch block
                    }
                    Tenebria.create(world, (Entity)entity);
                    world.func_184134_a(focal.field_70165_t, focal.field_70163_u, focal.field_70161_v, WizardrySounds.ENTITY_ZOMBIE_SPAWNER_SPAWN, SoundCategory.PLAYERS, 0.7f, 1.0f, true);
                    return;
                }
            }
            if (entity instanceof ISummonedCreature) {
                m.element = Element.NECROMANCY;
                if (m.hasOwner) {
                    ((ISummonedCreature)entity).setCaster(caster);
                }
                ((ISummonedCreature)entity).setLifetime(m.lifetime.num() < 0.0f ? 1 : Solver.asTicks(m.lifetime.num()));
                position = BlockUtils.findNearbyFloorSpace((Entity)target, (int)((int)(2.0f + m.range.num() / 10.0f)), (int)4);
                if (position != null && SpellCreation.useMana(focal, (double)(m.lifetime.num() / 10.0f * (m.health.num() / 2.0f) * m.potency.num()), true)) {
                    entity.func_70107_b((double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5);
                    entity.func_180482_a(world.func_175649_E(new BlockPos((Vec3i)position)), null);
                    ((ISummonedCreature)entity).onSpawn();
                    try {
                        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)m.health.num());
                        entity.func_70606_j(entity.func_110138_aP());
                        entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)m.potency.num());
                    }
                    catch (Exception soul) {
                        // empty catch block
                    }
                    Tenebria.create(world, (Entity)entity);
                    world.func_184134_a(focal.field_70165_t, focal.field_70163_u, focal.field_70161_v, WizardrySounds.ENTITY_ZOMBIE_SPAWNER_SPAWN, SoundCategory.PLAYERS, 0.7f, 1.0f, true);
                    return;
                }
            }
        }
        if (SpellCreation.findIn(word, "summon") && !world.field_72995_K) {
            if (next.split(":").length <= 1) {
                next = "ebwizardry:" + next;
            }
            entity = null;
            try {
                entity = ((EntityEntry)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(Tales.toResourceLocation(next)))).newInstance(world);
                if (Arrays.asList(Tales.chanting.constructBlacklist).contains(next)) {
                    entity = null;
                }
            }
            catch (Exception position) {
                // empty catch block
            }
            if (entity != null) {
                boolean summon = false;
                if (entity instanceof EntityMagicConstruct) {
                    if (m.hasOwner) {
                        ((EntityMagicConstruct)entity).setCaster(caster);
                    }
                    ((EntityMagicConstruct)entity).lifetime = lifetime < 0.0f ? 20 : Solver.asTicks(lifetime);
                    ((EntityMagicConstruct)entity).damageMultiplier = potency / 100.0f;
                    summon = true;
                } else if (entity instanceof EntityMagic) {
                    if (m.hasOwner) {
                        ((EntityMagic)entity).setCaster(caster);
                    }
                    ((EntityMagic)entity).setLifetime(lifetime < 0.0f ? 1 : Solver.asTicks(lifetime));
                    ((EntityMagic)entity).damageMultiplier = potency / 100.0f;
                    summon = true;
                }
                int type = 0;
                if (entity instanceof EntityScaledConstruct) {
                    type = 1;
                    ((EntityScaledConstruct)entity).setSizeMultiplier(2.0f + m.size.num());
                } else if (entity instanceof EntityMagicScaled) {
                    type = 2;
                    ((EntityMagicScaled)entity).setSizeMultiplier(2.0f + m.size.num());
                }
                if (!summon) {
                    return;
                }
                m.element = Element.MAGIC;
                entity.func_70080_a((double)spellBlock.func_177958_n() + 0.5, (double)spellBlock.func_177956_o(), (double)spellBlock.func_177952_p() + 0.5, m.focal.field_70177_z, m.focal.field_70125_A);
                if (SpellCreation.useMana(focal, type > 0 ? (double)(lifetime * m.size.num() * potency) : (double)(lifetime * potency), true)) {
                    Tenebria.create(world, (Entity)entity);
                    world.func_184134_a(focal.field_70165_t, focal.field_70163_u, focal.field_70161_v, WizardrySounds.ENTITY_ZOMBIE_SPAWNER_SPAWN, SoundCategory.PLAYERS, 0.7f, 1.0f, true);
                }
            }
        }
        if (SpellCreation.findIn(word, "ignite") && SpellCreation.useMana(focal, (double)(2.0f * duration), true)) {
            if (m.castingTargeting != 1) {
                target.func_70015_d((int)duration);
            }
            m.element = Element.FIRE;
            if (m.castingTargeting == 1 && world.func_175623_d(spellBlock) && !world.field_72995_K && BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)spellBlock)) {
                world.func_175656_a(spellBlock, Blocks.field_150480_ab.func_176223_P());
            }
        }
        if (SpellCreation.findIn(word, "accelerate")) {
            state = world.func_180495_p(spellBlock);
            if (m.castingTargeting != 2 && state.func_177230_c() == Blocks.field_150350_a) {
                TileEntity tile = world.func_175625_s(spellBlock);
                if (tile instanceof ITickable) {
                    for (int i = 0; i < 20; ++i) {
                        ITickable tickable = (ITickable)tile;
                        tickable.func_73660_a();
                    }
                    m.element = Element.SORCERY;
                }
                if (state.func_177230_c().func_149653_t()) {
                    for (int i = 0; i < 20; ++i) {
                        state.func_177230_c().func_180645_a(world, spellBlock, state, world.field_73012_v);
                    }
                    m.element = Element.SORCERY;
                }
            }
        }
        if (SpellCreation.findIn(word, "place")) {
            state = world.func_180495_p(spellBlock);
            m.element = Element.SORCERY;
            if (caster != null && caster.func_70093_af() && state.func_177230_c() == WizardryBlocks.spectral_block && SpellCreation.useMana(focal, 5.0)) {
                if (!world.field_72995_K) {
                    world.func_175698_g(spellBlock);
                } else {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)spellBlock.func_177958_n() + 0.5, (double)spellBlock.func_177956_o() + 0.5, (double)spellBlock.func_177952_p() + 0.5).scale(3.0f).clr(0.75f, 1.0f, 0.85f).spawn(world);
                }
                return;
            }
            if (world.field_72995_K) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)spellBlock.func_177958_n() + 0.5, (double)spellBlock.func_177956_o() + 0.5, (double)spellBlock.func_177952_p() + 0.5).scale(3.0f).clr(0.75f, 1.0f, 0.85f).spawn(world);
            }
            if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)spellBlock) && SpellCreation.useMana(focal, 10.0)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(spellBlock, WizardryBlocks.spectral_block.func_176223_P());
                    if (world.func_175625_s(spellBlock) instanceof TileEntityTimer) {
                        ((TileEntityTimer)Objects.requireNonNull(world.func_175625_s(spellBlock))).setLifetime(Solver.asTicks(duration));
                    }
                }
                return;
            }
        }
        if (SpellCreation.findIn(word, "remove") && (state = world.func_180495_p(spellBlock)).func_177230_c() == WizardryBlocks.spectral_block && SpellCreation.useMana(focal, 10.0)) {
            if (!world.field_72995_K) {
                world.func_175698_g(spellBlock);
            } else {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)spellBlock.func_177958_n() + 0.5, (double)spellBlock.func_177956_o() + 0.5, (double)spellBlock.func_177952_p() + 0.5).scale(3.0f).clr(0.75f, 1.0f, 0.85f).spawn(world);
            }
            m.element = Element.SORCERY;
            return;
        }
        if (SpellCreation.findIn(word, "grow")) {
            IGrowable plant;
            state = world.func_180495_p(spellBlock);
            if (m.castingTargeting != 2 && state.func_177230_c() instanceof IGrowable && (plant = (IGrowable)state.func_177230_c()).func_176473_a(world, spellBlock, state, world.field_72995_K) && SpellCreation.useMana(focal, 10.0, true)) {
                if (!world.field_72995_K) {
                    if (plant.func_180670_a(world, world.field_73012_v, spellBlock, state)) {
                        plant.func_176474_b(world, world.field_73012_v, spellBlock, state);
                    }
                } else {
                    ItemDye.func_180617_a((World)world, (BlockPos)spellBlock, (int)0);
                }
                m.element = Element.EARTH;
            }
            if (m.castingTargeting != 1 && target.func_70011_f((double)spellBlock.func_177958_n() + 0.5, (double)spellBlock.func_177956_o(), (double)spellBlock.func_177952_p() + 0.5) < 2.0 && target instanceof EntityLivingBase && SpellCreation.useMana(focal, duration * 2.0f)) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(TalesEffects.entangled, Solver.asTicks(duration), 2));
            }
        }
        if (SpellCreation.findIn(word, "lock") && caster != null && !world.field_72995_K && SpellCreation.toggleLock(world, spellBlock, (EntityPlayer)caster) && (otherHalf = BlockUtils.getConnectedChest((World)world, (BlockPos)spellBlock)) != null) {
            SpellCreation.toggleLock(world, otherHalf, (EntityPlayer)caster);
        }
        if (SpellCreation.findIn(word, "pull")) {
            float distance = target.func_70032_d(focal);
            if (SpellCreation.findIn(next, "in") && SpellCreation.useMana(focal, (double)distance, true)) {
                Tenebria.moveTowards(target, focal.func_174791_d(), 2);
                m.element = Element.SORCERY;
            }
            if (SpellCreation.findIn(next, "out") && SpellCreation.useMana(focal, (double)distance, true)) {
                Tenebria.moveTowards(target, focal.func_174791_d(), -2);
                m.element = Element.SORCERY;
            }
        }
        if (SpellCreation.findIn(word, "undo") && SpellCreation.findIn(next, "gravity") && SpellCreation.useMana(focal, 5.0)) {
            EntityUtils.undoGravity((Entity)target);
            target.field_70143_R = 0.0f;
            if (world.field_72995_K) {
                Wizard.castParticles(world, Element.SORCERY, target.func_174791_d());
            }
        }
        if (SpellCreation.findIn(word, "undo") && SpellCreation.findIn(next, "magic") && SpellCreation.useMana(focal, 10.0)) {
            if (target instanceof EntityMagic) {
                ((EntityMagic)target).despawn();
            } else if (target instanceof EntityMagicConstruct) {
                ((EntityMagicConstruct)target).despawn();
            }
            if (target instanceof ISummonedCreature) {
                ((ISummonedCreature)target).onDespawn();
                ((ISummonedCreature)target).setLifetime(0);
            }
        }
        if (SpellCreation.findIn(word, "move")) {
            float z;
            float y;
            float x;
            if (!SpellCreation.findIn(next, "set to is")) {
                x = SpellCreation.getInteger(next, 0);
                y = SpellCreation.getInteger(next2, 0);
                z = SpellCreation.getInteger(next3, 0);
            } else {
                x = SpellCreation.getInteger(next2, 0);
                y = SpellCreation.getInteger(next3, 0);
                z = SpellCreation.getInteger(next4, 0);
            }
            float distance = Math.abs(x) + Math.abs(y) + Math.abs(z);
            if (distance == 0.0f) {
                if (SpellCreation.findIn(next, "look")) {
                    x = (float)target.func_70040_Z().field_72450_a * potency;
                    y = (float)target.func_70040_Z().field_72448_b * potency;
                    z = (float)target.func_70040_Z().field_72449_c * potency;
                }
                if (SpellCreation.findIn(next, "inverted invert inv") && SpellCreation.findIn(next2, "look")) {
                    x = (float)(-target.func_70040_Z().field_72450_a) * potency;
                    y = (float)(-target.func_70040_Z().field_72448_b) * potency;
                    z = (float)(-target.func_70040_Z().field_72449_c) * potency;
                }
                distance = Math.abs(x) + Math.abs(y) + Math.abs(z);
            }
            if (SpellCreation.useMana(focal, (double)(distance * distance), true)) {
                target.func_70016_h((double)(x * 0.1f), (double)(y * 0.1f), (double)(z * 0.1f));
                target.field_70133_I = true;
                target.field_70143_R = 0.0f;
            }
            if (world.field_72995_K) {
                Wizard.castParticles(world, Element.SORCERY, target.func_174791_d());
            }
        }
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)target;
        if (SpellCreation.findIn(word, "apply")) {
            PotionEffect effect;
            if (next.split(":").length <= 1) {
                next = "minecraft:" + next;
            }
            Potion potion = null;
            try {
                Potion finalPotion = potion = Potion.func_180142_b((String)next);
                if (Arrays.stream(Tales.chanting.applyBlacklist).anyMatch(p -> p.equals(finalPotion != null ? Objects.requireNonNull(finalPotion.getRegistryName()).toString() : null))) {
                    potion = null;
                }
            }
            catch (Exception ignore) {
                Aterna.chant((EntityPlayer)caster, "Effect is not found!");
            }
            if (potion != null && living.func_70687_e(effect = new PotionEffect(potion, Solver.asTicks(duration), Math.max((int)(potency - 1.0f), 0))) && SpellCreation.useMana(focal, (double)(potency * (duration / 10.0f)), true)) {
                if (!world.field_72995_K) {
                    living.func_70690_d(effect);
                }
                m.isBuff = true;
            }
        }
        if (SpellCreation.findIn(word, "attack") && SpellCreation.findIn(next, "with") && SpellCreation.useMana(focal, (double)(potency * potency), true)) {
            MagicDamage.DamageType type = Sage.getTypeByText(word);
            Element element = type == null ? Element.fromName((String)word, (Element)Element.MAGIC) : Sage.getElementByType(type);
            Sage.smartDamage(word, caster, (Entity)living, 10.0f);
            m.element = element;
        }
        if (SpellCreation.findIn(word, "heal") && SpellCreation.useMana(focal, (double)(potency * potency), true)) {
            if (!living.func_70662_br()) {
                living.func_70691_i(potency);
            } else {
                Sage.causeDamage(MagicDamage.DamageType.RADIANT, caster, (Entity)living, potency * 2.0f);
                living.func_70015_d(2);
            }
            m.element = Element.HEALING;
            m.isBuff = true;
        }
        if (SpellCreation.findIn(word, "satiate satiety saturate") && target instanceof EntityPlayer && SpellCreation.useMana(focal, (double)(potency * potency), true)) {
            EntityPlayer player = (EntityPlayer)target;
            player.func_71024_bL().func_75122_a(m.potency.getNumber().intValue(), 0.1f);
            m.element = Element.HEALING;
            m.isBuff = true;
        }
    }

    public static String getWord(String[] spell, int i, int x) {
        return i + x < spell.length ? spell[i + x] : "";
    }

    @Nullable
    public static EntityLivingBase getCaster(Entity focal) {
        if (focal instanceof EntityLivingBase) {
            return (EntityLivingBase)focal;
        }
        if (focal instanceof EntityMagic) {
            return ((EntityMagic)focal).getCaster();
        }
        return null;
    }
}

