/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.events;

import astramusfate.wizardry_tales.data.ChantWorker;
import astramusfate.wizardry_tales.data.Lexicon;
import astramusfate.wizardry_tales.data.chanting.SpellParams;
import astramusfate.wizardry_tales.events.SpellCreation;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.WandHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SpellCreationHelper
extends ChantWorker
implements Lexicon {
    public static final String[] conditions = new String[]{"damage damaged", "hit hitting", "night", "day", "sneak", "use", "manual", "constant tick update", "light", "spell spellcast cast"};

    public static String getMsg(String original) {
        return original.toLowerCase(Locale.ROOT).replace(",", "").replace(".", "").replace("!", "").replace("?", "").replace("/", "");
    }

    public static List<String> getSpell(String msg) {
        return Arrays.asList(msg.split(" "));
    }

    public static float getFloat(String word, float fail) {
        float number;
        try {
            number = Float.parseFloat(word);
        }
        catch (Exception exception) {
            number = fail;
        }
        return number;
    }

    public static int getInteger(String word, int fail) {
        int number;
        try {
            number = Integer.parseInt(word);
        }
        catch (Exception exception) {
            number = fail;
        }
        return number;
    }

    public static Number getFloat(String next, String next2, String next3, float fail) {
        Float number;
        try {
            number = Float.valueOf(Float.parseFloat(next));
        }
        catch (Exception exception1) {
            try {
                number = Float.valueOf(Float.parseFloat(next2));
            }
            catch (Exception exception2) {
                try {
                    number = Float.valueOf(Float.parseFloat(next3));
                }
                catch (Exception exception3) {
                    number = Float.valueOf(fail);
                }
            }
        }
        return number;
    }

    public static float getFloat(String[] spell, String match, float fail) {
        float value = fail;
        for (int i = 0; i < spell.length; ++i) {
            float number;
            String next = i + 1 < spell.length ? spell[i + 1] : "";
            String next2 = i + 2 < spell.length ? spell[i + 2] : "";
            String next3 = i + 3 < spell.length ? spell[i + 3] : "";
            String word = spell[i];
            try {
                number = Float.parseFloat(next);
            }
            catch (Exception exception1) {
                try {
                    number = Float.parseFloat(next2);
                }
                catch (Exception exception2) {
                    try {
                        number = Float.parseFloat(next3);
                    }
                    catch (Exception exception3) {
                        number = 0.0f;
                    }
                }
            }
            if (!(number > 0.0f) || !SpellCreation.findIn(word, match)) continue;
            value = number;
        }
        return value;
    }

    public static NBTTagCompound getOrCreateTagCompound(ItemStack stack) {
        if (stack == null) {
            return new NBTTagCompound();
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77942_o()) {
            return stack.func_77978_p();
        }
        return new NBTTagCompound();
    }

    public static String findShape(String ... words) {
        for (String word : words) {
            for (String shape : SpellParams.shapes) {
                if (!SpellCreationHelper.findIn(word, shape)) continue;
                return shape;
            }
        }
        return "me";
    }

    public static String findWithin(String[] array, String fail, String ... words) {
        for (String word : words) {
            for (String entry : array) {
                if (!SpellCreationHelper.findIn(word, entry)) continue;
                return word;
            }
        }
        return fail;
    }

    public static int getChosenSpellIndex(ItemStack wand) {
        int selectedSpell;
        Spell[] spells = WandHelper.getSpells((ItemStack)wand);
        if (wand.func_77978_p() != null && (selectedSpell = wand.func_77978_p().func_74762_e("selectedSpell")) >= 0 && selectedSpell < spells.length) {
            return selectedSpell;
        }
        return -1;
    }
}

