/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.events;

import astramusfate.wizardry_tales.api.Aterna;
import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.api.Thief;
import astramusfate.wizardry_tales.api.classes.IInscribed;
import astramusfate.wizardry_tales.data.EventsBase;
import astramusfate.wizardry_tales.data.Lexicon;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.Mana;
import astramusfate.wizardry_tales.events.SpellCreation;
import astramusfate.wizardry_tales.events.SpellCreationHelper;
import astramusfate.wizardry_tales.items.TalesBauble;
import astramusfate.wizardry_tales.spells.TalesSpells;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import com.google.common.collect.Lists;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="wizardry_tales")
public class SpellcastingHandler
extends EventsBase
implements Lexicon {
    private static final ResourceLocation bar_mana = new ResourceLocation("wizardry_tales:textures/gui/bar_mana.png");

    @SubscribeEvent
    public static void onInscribedItemHit(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            List<ItemStack> stacks = SpellcastingHandler.getChantedItems(player);
            for (ItemStack stack : stacks) {
                NBTTagCompound tag;
                if (stack == null || !SpellcastingHandler.checkCondition(stack, "hit hitting") || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || (tag = stack.func_77978_p()) == null || !tag.func_74764_b("spell") || !tag.func_74764_b("condition") || !SpellCreation.findIn(tag.func_74779_i("condition"), "hit hitting")) continue;
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
                String msg = SpellCreation.getMsg(tag.func_74779_i("spell"));
                List<String> words = SpellCreation.getSpell(msg);
                String[] spell = words.toArray(new String[0]);
                ArrayList set = Lists.newArrayList();
                try {
                    set.addAll(Arrays.asList(spell));
                    set.remove("shape");
                    set.remove("inscribe scribe");
                }
                catch (Exception e) {
                    Aterna.messageBar(player, "Problem when casting!");
                }
                SpellCreation.createSpell(set, (Entity)player, (Entity)event.getEntityLiving(), !player.field_70170_p.field_72995_K);
            }
        }
    }

    @SubscribeEvent
    public static void onInscribedItemDamage(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            List<ItemStack> stacks = SpellcastingHandler.getChantedItems(player);
            for (ItemStack stack : stacks) {
                NBTTagCompound tag;
                if (stack == null || !SpellcastingHandler.checkCondition(stack, "damage damaged") || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || (tag = stack.func_77978_p()) == null || !tag.func_74764_b("spell") || !tag.func_74764_b("condition") || !SpellCreation.findIn(tag.func_74779_i("condition"), "damage damaged")) continue;
                if (SpellcastingHandler.stopUsageIf(tag, e -> player.func_110143_aJ() / player.func_110138_aP() > (float)e.intValue())) {
                    return;
                }
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
                String msg = SpellCreation.getMsg(tag.func_74779_i("spell"));
                List<String> words = SpellCreation.getSpell(msg);
                String[] spell = words.toArray(new String[0]);
                ArrayList set = Lists.newArrayList();
                try {
                    set.addAll(Arrays.asList(spell));
                    set.remove("shape");
                    set.remove("inscribe scribe");
                }
                catch (Exception e2) {
                    Aterna.messageBar(player, "Problem when casting!");
                }
                SpellCreation.createSpell(set, (Entity)player, (Entity)player, !player.field_70170_p.field_72995_K);
            }
        }
    }

    @SubscribeEvent
    public static void onInscribedItemTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            List<ItemStack> stacks = SpellcastingHandler.getChantedItems(player);
            if (Solver.doEvery((Entity)player, 1.0)) {
                SpellcastingHandler.onTick(player, stacks);
                SpellcastingHandler.onLightLevel(player, stacks);
            }
            if (Solver.doEvery((Entity)player, 0.5)) {
                SpellcastingHandler.onSneak(player, stacks);
            }
        }
    }

    @SubscribeEvent
    public static void onInscribedItemUse(PlayerInteractEvent.RightClickItem event) {
        SpellcastingHandler.onItemUse((PlayerInteractEvent)event);
        SpellcastingHandler.onSpell((PlayerInteractEvent)event);
    }

    public static void onItemUse(PlayerInteractEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        List<ItemStack> stacks = SpellcastingHandler.getChantedItems(player);
        for (ItemStack stack : stacks) {
            NBTTagCompound tag;
            if (stack == null || !SpellcastingHandler.checkCondition(stack, "use") || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || (tag = stack.func_77978_p()) == null || !tag.func_74764_b("spell") || !tag.func_74764_b("condition") || !SpellCreation.findIn(tag.func_74779_i("condition"), "use")) continue;
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            String msg = SpellCreation.getMsg(tag.func_74779_i("spell"));
            List<String> words = SpellCreation.getSpell(msg);
            String[] spell = words.toArray(new String[0]);
            ArrayList set = Lists.newArrayList();
            try {
                set.addAll(Arrays.asList(spell));
                set.remove("shape");
                set.remove("inscribe scribe");
            }
            catch (Exception e) {
                Aterna.messageBar(player, "Problem when casting!");
            }
            SpellCreation.createSpell(set, (Entity)player, (Entity)player, !player.field_70170_p.field_72995_K);
        }
    }

    private static void onSpell(PlayerInteractEvent event) {
        if (event.getItemStack().func_77973_b() instanceof ISpellCastingItem) {
            EntityPlayer player = event.getEntityPlayer();
            ISoul soul = Mana.getSoul(player);
            Spell spell = WandHelper.getCurrentSpell((ItemStack)event.getItemStack());
            if (soul == null) {
                return;
            }
            if (spell == TalesSpells.chanting) {
                WizardData.get((EntityPlayer)player).discoverSpell(spell);
                SpellcastingHandler.onSpellcast(player, event.getItemStack());
                SpellcastingHandler.cancel((Event)event);
            }
        }
    }

    public static void onSpellcast(EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && SpellcastingHandler.checkCondition(stack, "spell spellcast cast") && !player.func_184811_cZ().func_185141_a(stack.func_77973_b()) && (tag = stack.func_77978_p()) != null && tag.func_74764_b("spell") && tag.func_74764_b("condition") && SpellCreation.findIn(tag.func_74779_i("condition"), "spell spellcast cast")) {
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            int id = SpellCreationHelper.getChosenSpellIndex(stack);
            String msg = tag.func_74764_b("spell" + id) ? SpellCreation.getMsg(tag.func_74779_i("spell" + id)) : SpellCreation.getMsg(tag.func_74779_i("spell"));
            List<String> words = SpellCreation.getSpell(msg);
            String[] spell = words.toArray(new String[0]);
            ArrayList set = Lists.newArrayList();
            try {
                set.addAll(Arrays.asList(spell));
                set.remove("shape");
                set.remove("inscribe scribe");
            }
            catch (Exception e) {
                Aterna.messageBar(player, "Problem when casting!");
            }
            SpellCreation.createSpell(set, (Entity)player, (Entity)player, !player.field_70170_p.field_72995_K);
        }
    }

    private static void onSneak(EntityPlayer player, List<ItemStack> stacks) {
        if (!player.func_70093_af()) {
            return;
        }
        for (ItemStack stack : stacks) {
            NBTTagCompound tag;
            if (stack == null || !SpellcastingHandler.checkCondition(stack, "sneak") || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || (tag = stack.func_77978_p()) == null || !tag.func_74764_b("spell") || !tag.func_74764_b("condition") || !SpellCreation.findIn(tag.func_74779_i("condition"), "sneak")) continue;
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            String msg = SpellCreation.getMsg(tag.func_74779_i("spell"));
            List<String> words = SpellCreation.getSpell(msg);
            String[] spell = words.toArray(new String[0]);
            ArrayList set = Lists.newArrayList();
            try {
                set.addAll(Arrays.asList(spell));
                set.remove("shape");
                set.remove("inscribe scribe");
            }
            catch (Exception e) {
                Aterna.messageBar(player, "Problem when casting!");
            }
            SpellCreation.createSpell(set, (Entity)player, (Entity)player, !player.field_70170_p.field_72995_K);
        }
    }

    private static void onTick(EntityPlayer player, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            NBTTagCompound tag;
            if (stack == null || !SpellcastingHandler.checkCondition(stack, "constant tick update") || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || (tag = stack.func_77978_p()) == null || !tag.func_74764_b("spell") || !tag.func_74764_b("condition") || !SpellCreation.findIn(tag.func_74779_i("condition"), "constant tick update")) continue;
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            String msg = SpellCreation.getMsg(tag.func_74779_i("spell"));
            List<String> words = SpellCreation.getSpell(msg);
            String[] spell = words.toArray(new String[0]);
            ArrayList set = Lists.newArrayList();
            try {
                set.addAll(Arrays.asList(spell));
                set.remove("shape");
                set.remove("inscribe scribe");
            }
            catch (Exception e) {
                Aterna.messageBar(player, "Problem when casting!");
            }
            SpellCreation.createSpell(set, (Entity)player, (Entity)player, !player.field_70170_p.field_72995_K);
        }
    }

    private static void onLightLevel(EntityPlayer player, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            int value;
            if (stack == null || !SpellcastingHandler.checkCondition(stack, "light") || player.func_184811_cZ().func_185141_a(stack.func_77973_b())) continue;
            float f = player.func_70013_c();
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null || !(f <= Math.max((float)(value = Math.min(SpellcastingHandler.getParameter(tag), 100)), 0.0f) / 100.0f) || !tag.func_74764_b("spell") || !tag.func_74764_b("condition") || !SpellCreation.findIn(tag.func_74779_i("condition"), "light")) continue;
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            String msg = SpellCreation.getMsg(tag.func_74779_i("spell"));
            List<String> words = SpellCreation.getSpell(msg);
            String[] spell = words.toArray(new String[0]);
            ArrayList set = Lists.newArrayList();
            try {
                set.addAll(Arrays.asList(spell));
                set.remove("shape");
                set.remove("inscribe scribe");
            }
            catch (Exception e) {
                Aterna.messageBar(player, "Problem when casting!");
            }
            SpellCreation.createSpell(set, (Entity)player, (Entity)player, !player.field_70170_p.field_72995_K);
        }
    }

    @SubscribeEvent
    public static void onInscribedItemDayNight(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Solver.doEvery((Entity)event.player, 5.0)) {
            EntityPlayer player = event.player;
            List<ItemStack> stacks = SpellcastingHandler.getChantedItems(player);
            for (ItemStack stack : stacks) {
                NBTTagCompound tag;
                if (stack == null || !SpellcastingHandler.checkCondition(stack, "night") && !SpellcastingHandler.checkCondition(stack, "day") || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || (tag = stack.func_77978_p()) == null || !tag.func_74764_b("spell") || !tag.func_74764_b("condition") || (!player.field_70170_p.field_73011_w.isDaytime() || !SpellCreation.findIn(tag.func_74779_i("condition"), "day")) && (player.field_70170_p.field_73011_w.isDaytime() || !SpellCreation.findIn(tag.func_74779_i("condition"), "night"))) continue;
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
                String msg = SpellCreation.getMsg(tag.func_74779_i("spell"));
                List<String> words = SpellCreation.getSpell(msg);
                String[] spell = words.toArray(new String[0]);
                ArrayList set = Lists.newArrayList();
                try {
                    set.addAll(Arrays.asList(spell));
                    set.remove("shape");
                    set.remove("inscribe scribe");
                }
                catch (Exception e) {
                    Aterna.messageBar(player, "Problem when casting!");
                }
                SpellCreation.createSpell(set, (Entity)player, (Entity)player, !player.field_70170_p.field_72995_K);
            }
        }
    }

    public static boolean checkCondition(ItemStack stack, String condition) {
        return !(stack.func_77973_b() instanceof IInscribed) || ((IInscribed)stack.func_77973_b()).canApplyCondition(condition);
    }

    public static boolean stopUsageIf(NBTTagCompound tag, Predicate<Integer> condition_to_meet) {
        int parameter = SpellcastingHandler.getParameter(tag);
        if (parameter != Integer.MAX_VALUE) {
            return condition_to_meet.test(parameter);
        }
        return false;
    }

    public static int getParameter(NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b("parameter")) {
            return tag.func_74762_e("parameter");
        }
        return Integer.MAX_VALUE;
    }

    public static int getParameter(NBTTagCompound tag, String text) {
        if (tag != null && tag.func_74764_b(text)) {
            return tag.func_74762_e(text);
        }
        return Integer.MAX_VALUE;
    }

    public static List<ItemStack> getChantedItems(EntityPlayer player) {
        ArrayList stacks = Lists.newArrayList();
        ItemStack hands = Thief.getInHands(player, s -> !(s.func_77973_b() instanceof IInscribed) || s.func_77973_b() instanceof IInscribed && ((IInscribed)s.func_77973_b()).applyConditions());
        if (hands != null) {
            stacks.add(hands);
        }
        List<ItemStack> artefacts = SpellcastingHandler.getEquippedArtefacts(player, BaubleType.RING, BaubleType.AMULET, BaubleType.CHARM, BaubleType.BELT, BaubleType.BODY, BaubleType.HEAD, BaubleType.TRINKET);
        for (ItemStack artefact : artefacts) {
            if (!(artefact.func_77973_b() instanceof IInscribed) || !((IInscribed)artefact.func_77973_b()).applyConditions()) continue;
            stacks.add(artefact);
        }
        return stacks;
    }

    public static List<ItemStack> getEquippedArtefacts(EntityPlayer player, BaubleType ... types) {
        ArrayList<ItemStack> artefacts = new ArrayList<ItemStack>();
        for (BaubleType type : types) {
            for (int slot : type.getValidSlots()) {
                ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null || !tag.func_74764_b("spell") && !(stack.func_77973_b() instanceof TalesBauble) && !(stack.func_77973_b() instanceof ItemArtefact)) continue;
                artefacts.add(stack);
            }
        }
        return artefacts;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onCustomSpellRender(ItemTooltipEvent event) {
        if (event.getEntityPlayer() != null && event.getEntityPlayer().field_70170_p != null) {
            ItemStack stack = event.getItemStack();
            if (stack.func_77978_p() == null) {
                return;
            }
            NBTTagCompound tag = stack.func_77978_p();
            if (!tag.func_74764_b("hidden") || !tag.func_74767_n("hidden")) {
                if (stack.func_77973_b() instanceof ISpellCastingItem) {
                    int slot = 0;
                    for (Spell ignored : WandHelper.getSpells((ItemStack)stack)) {
                        if (tag.func_74764_b("spell" + slot)) {
                            event.getToolTip().add("Spell " + (slot + 1) + ": " + TextFormatting.DARK_GRAY + TextFormatting.ITALIC + tag.func_74779_i("spell" + slot));
                        }
                        ++slot;
                    }
                } else if (tag.func_74764_b("spell")) {
                    event.getToolTip().add("Spell: " + TextFormatting.DARK_GRAY + TextFormatting.ITALIC + tag.func_74779_i("spell"));
                }
            }
            if (tag.func_74764_b("condition")) {
                event.getToolTip().add("Condition: " + TextFormatting.DARK_GRAY + TextFormatting.ITALIC + Aterna.capitalize(tag.func_74779_i("condition")));
            }
            if (tag.func_74764_b("parameter")) {
                event.getToolTip().add("Parameter: " + TextFormatting.DARK_GRAY + TextFormatting.ITALIC + (int)tag.func_74760_g("parameter"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onEntityShowcase(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (!Tales.mp.manaPool || !Tales.mp.manaPoolBar) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (Minecraft.func_71410_x().field_71442_b.func_78755_b()) {
            ISoul soul = Mana.getSoul((EntityPlayer)player);
            if (soul == null) {
                return;
            }
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(bar_mana);
            int left = event.getResolution().func_78326_a() / 2 + 91;
            int y = event.getResolution().func_78328_b() - GuiIngameForge.right_height;
            GuiIngameForge.right_height += 10;
            double mana = soul.getMP();
            double maxMana = soul.getMaxMP();
            double manaValue = Math.floor(mana / maxMana * 20.0);
            for (int i = 0; i < 10; ++i) {
                int idx = i * 2 + 1;
                int x = left - i * 8 - 9;
                DrawingUtils.drawTexturedRect((int)x, (int)y, (int)0, (int)0, (int)9, (int)9, (int)27, (int)9);
                if ((double)idx < manaValue) {
                    DrawingUtils.drawTexturedRect((int)x, (int)y, (int)9, (int)0, (int)9, (int)9, (int)27, (int)9);
                    continue;
                }
                if ((double)idx != manaValue) continue;
                DrawingUtils.drawTexturedRect((int)x, (int)y, (int)18, (int)0, (int)9, (int)9, (int)27, (int)9);
            }
            int x = left - 8 - 9;
            Minecraft.func_71410_x().field_71466_p.func_175063_a((int)Math.floor(mana) + "", (float)(x + 20), (float)y, 9469880);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
            GlStateManager.func_179084_k();
        }
    }
}

