/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.events;

import astramusfate.wizardry_tales.WizardryTales;
import astramusfate.wizardry_tales.api.Aterna;
import astramusfate.wizardry_tales.api.Thief;
import astramusfate.wizardry_tales.data.PacketMagic;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.Mana;
import astramusfate.wizardry_tales.data.packets.PacketAbilityMode;
import astramusfate.wizardry_tales.data.packets.PacketCastingRing;
import astramusfate.wizardry_tales.data.packets.PacketIncantate;
import astramusfate.wizardry_tales.events.SpellCreation;
import astramusfate.wizardry_tales.events.SpellcastingHandler;
import astramusfate.wizardry_tales.proxy.ClientProxy;
import astramusfate.wizardry_tales.registry.TalesItems;
import com.google.common.collect.Lists;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.gui.GuiSpellDisplay;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.packet.PacketControlInput;
import electroblob.wizardry.packet.PacketSpellQuickAccess;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class TalesControlHandler {
    static boolean NkeyPressed = false;
    static boolean BkeyPressed = false;
    static boolean[] quickAccessKeyPressed = new boolean[electroblob.wizardry.client.ClientProxy.SPELL_QUICK_ACCESS.length];
    static boolean spellCastRing = false;
    static boolean abilityMode = false;
    static boolean manualInscription = false;

    @SubscribeEvent
    public static void onTickEvent(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (Wizardry.proxy instanceof electroblob.wizardry.client.ClientProxy && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            ItemStack wand = TalesControlHandler.getWandInUse((EntityPlayer)player);
            if (wand == null) {
                return;
            }
            if (electroblob.wizardry.client.ClientProxy.NEXT_SPELL.func_151470_d() && Minecraft.func_71410_x().field_71415_G) {
                if (!NkeyPressed) {
                    NkeyPressed = true;
                    TalesControlHandler.selectNextSpell(wand);
                }
            } else {
                NkeyPressed = false;
            }
            if (electroblob.wizardry.client.ClientProxy.PREVIOUS_SPELL.func_151470_d() && Minecraft.func_71410_x().field_71415_G) {
                if (!BkeyPressed) {
                    BkeyPressed = true;
                    TalesControlHandler.selectPreviousSpell(wand);
                }
            } else {
                BkeyPressed = false;
            }
            for (int i = 0; i < electroblob.wizardry.client.ClientProxy.SPELL_QUICK_ACCESS.length; ++i) {
                if (electroblob.wizardry.client.ClientProxy.SPELL_QUICK_ACCESS[i].func_151470_d() && Minecraft.func_71410_x().field_71415_G) {
                    if (quickAccessKeyPressed[i]) continue;
                    TalesControlHandler.quickAccessKeyPressed[i] = true;
                    TalesControlHandler.selectSpell(wand, i);
                    continue;
                }
                TalesControlHandler.quickAccessKeyPressed[i] = false;
            }
        }
    }

    @SubscribeEvent
    public static void onTickEventTales(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (WizardryTales.proxy instanceof ClientProxy && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            ISoul soul;
            if (ClientProxy.CAST_SPELL.func_151470_d() && Minecraft.func_71410_x().field_71415_G) {
                soul = Mana.getSoul((EntityPlayer)player);
                if (soul == null || soul.getCooldown() > 0) {
                    return;
                }
                ItemStack wand = TalesControlHandler.getWandInUseSmarter((EntityPlayer)player);
                if (wand == null) {
                    return;
                }
                Spell spell = WandHelper.getCurrentSpell((ItemStack)wand);
                SpellModifiers modifiers = SpellModifiers.fromNBT((NBTTagCompound)(wand.func_77978_p() == null ? new NBTTagCompound() : wand.func_77978_p()));
                if (WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
                    return;
                }
                if (!spellCastRing) {
                    spellCastRing = true;
                    TalesControlHandler.spellCastRing(player.func_145782_y(), spell, modifiers);
                    soul.setCooldown((EntityPlayer)player, Tales.mp.casting_ring_cooldown);
                }
            } else {
                spellCastRing = false;
            }
            if (ClientProxy.ABILITY_1.func_151470_d() && Minecraft.func_71410_x().field_71415_G) {
                soul = Mana.getSoul((EntityPlayer)player);
                if (soul == null) {
                    return;
                }
                if (!abilityMode) {
                    abilityMode = true;
                    int mode = soul.getMode() + 1 > 1 ? 0 : 1;
                    soul.setMode((EntityPlayer)player, mode);
                    TalesControlHandler.switchAbility(mode);
                }
            } else {
                abilityMode = false;
            }
            if (ClientProxy.MANUAL_CHANT.func_151470_d() && Minecraft.func_71410_x().field_71415_G) {
                if (!manualInscription) {
                    manualInscription = true;
                    TalesControlHandler.setManualInscription((EntityPlayer)player);
                }
            } else {
                manualInscription = false;
            }
        }
    }

    public static boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        if (castingTick == 0 ? MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers)) : MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers, castingTick))) {
            return false;
        }
        IManaStoringItem mana = (IManaStoringItem)stack.func_77973_b();
        int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
        if (spell.isContinuous) {
            cost = TalesControlHandler.getDistributedCost(cost, castingTick) * 5;
        }
        return cost <= mana.getMana(stack) && (WandHelper.getCurrentCooldown((ItemStack)stack) == 0 || caster.func_184812_l_());
    }

    protected static int getDistributedCost(int cost, int castingTick) {
        int partialCost = castingTick % 20 == 0 ? cost / 2 + cost % 2 : (castingTick % 10 == 0 ? cost / 2 : 0);
        return partialCost;
    }

    @SubscribeEvent
    public static void onMouseEvent(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack wand = TalesControlHandler.getWandInUse((EntityPlayer)player);
        if (wand == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71415_G && !wand.func_190926_b() && event.getDwheel() != 0 && player.func_70093_af() && Wizardry.settings.shiftScrolling) {
            int d;
            event.setCanceled(true);
            int n = d = Wizardry.settings.reverseScrollDirection ? -event.getDwheel() : event.getDwheel();
            if (d > 0) {
                TalesControlHandler.selectNextSpell(wand);
            } else if (d < 0) {
                TalesControlHandler.selectPreviousSpell(wand);
            }
        }
    }

    private static ItemStack getWandInUse(EntityPlayer player) {
        if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)TalesItems.casting_ring) && Thief.testPredicateHands((EntityLivingBase)player, i -> !(i.func_77973_b() instanceof ISpellCastingItem))) {
            return Thief.getItem(player, item -> item.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)item.func_77973_b()).getSpells(item).length >= 2 && item.func_77973_b() instanceof IManaStoringItem);
        }
        return null;
    }

    private static ItemStack getWandInUseSmarter(EntityPlayer player) {
        if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)TalesItems.casting_ring) && Thief.testPredicateHands((EntityLivingBase)player, i -> !(i.func_77973_b() instanceof ISpellCastingItem))) {
            return Thief.getItem(player, item -> item.func_77973_b() instanceof ISpellCastingItem && item.func_77973_b() instanceof IManaStoringItem);
        }
        return null;
    }

    private static void spellCastRing(int casterID, Spell spell, SpellModifiers modifiers) {
        PacketCastingRing msg = new PacketCastingRing(casterID, spell, modifiers);
        PacketMagic.net.sendToServer((IMessage)msg);
    }

    private static void setManualInscription(EntityPlayer player) {
        List<ItemStack> stacks = SpellcastingHandler.getChantedItems(player);
        for (ItemStack stack : stacks) {
            NBTTagCompound tag;
            if (stack == null || !SpellcastingHandler.checkCondition(stack, "manual") || player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || (tag = stack.func_77978_p()) == null || !tag.func_74764_b("spell") || !tag.func_74764_b("condition") || !SpellCreation.findIn(tag.func_74779_i("condition"), "manual")) continue;
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            String msg = SpellCreation.getMsg(tag.func_74779_i("spell"));
            List<String> words = SpellCreation.getSpell(msg);
            String[] spell = words.toArray(new String[0]);
            ArrayList set = Lists.newArrayList();
            try {
                set.addAll(Arrays.asList(spell));
                set.remove("shape");
                set.remove("inscribe scribe");
            }
            catch (Exception e) {
                Aterna.messageBar(player, "Problem when casting!");
            }
            SpellCreation.createSpell(set, (Entity)player, (Entity)player, false);
        }
        PacketIncantate msg = new PacketIncantate();
        PacketMagic.net.sendToServer((IMessage)msg);
    }

    private static void switchAbility(int mode) {
        PacketAbilityMode msg = new PacketAbilityMode(mode);
        PacketMagic.net.sendToServer((IMessage)msg);
    }

    private static void selectNextSpell(ItemStack wand) {
        PacketControlInput.Message msg = new PacketControlInput.Message(PacketControlInput.ControlType.NEXT_SPELL_KEY);
        WizardryPacketHandler.net.sendToServer((IMessage)msg);
        ((ISpellCastingItem)wand.func_77973_b()).selectNextSpell(wand);
        GuiSpellDisplay.playSpellSwitchAnimation((boolean)true);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.ITEM_WAND_SWITCH_SPELL, (float)1.0f));
    }

    private static void selectPreviousSpell(ItemStack wand) {
        PacketControlInput.Message msg = new PacketControlInput.Message(PacketControlInput.ControlType.PREVIOUS_SPELL_KEY);
        WizardryPacketHandler.net.sendToServer((IMessage)msg);
        ((ISpellCastingItem)wand.func_77973_b()).selectPreviousSpell(wand);
        GuiSpellDisplay.playSpellSwitchAnimation((boolean)false);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.ITEM_WAND_SWITCH_SPELL, (float)1.0f));
    }

    private static void selectSpell(ItemStack wand, int index) {
        if (((ISpellCastingItem)wand.func_77973_b()).selectSpell(wand, index)) {
            PacketSpellQuickAccess.Message msg = new PacketSpellQuickAccess.Message(index);
            WizardryPacketHandler.net.sendToServer((IMessage)msg);
            GuiSpellDisplay.playSpellSwitchAnimation((boolean)true);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.ITEM_WAND_SWITCH_SPELL, (float)1.0f));
        }
    }
}

