/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.events;

import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.api.Wizard;
import astramusfate.wizardry_tales.data.EventsBase;
import astramusfate.wizardry_tales.data.Tales;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VisualEffects
extends EventsBase {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void OnSummon(EntityJoinWorldEvent event) {
        int summon = 0;
        if (event.getEntity() instanceof EntitySummonedCreature) {
            summon = 1;
        }
        if (event.getEntity() instanceof ISummonedCreature) {
            summon = 2;
        }
        if (summon == 0) {
            return;
        }
        if (Tales.effects.onSummon && !event.getEntity().getEntityData().func_74764_b("spawned")) {
            World world = event.getWorld();
            try {
                if (summon == 1 && ((EntitySummonedCreature)event.getEntity()).func_70902_q() != null) {
                    event.getEntity().getEntityData().func_74757_a("spawned", true);
                    Wizard.conjureCircle(world, Element.NECROMANCY, event.getEntity().func_174791_d());
                } else if (summon == 2 && ((ISummonedCreature)event.getEntity()).func_70902_q() != null) {
                    event.getEntity().getEntityData().func_74757_a("spawned", true);
                    Wizard.conjureCircle(world, Element.NECROMANCY, event.getEntity().func_174791_d());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void OnCast(SpellCastEvent.Post event) {
        if (event.getCaster() != null && event.getWorld().field_72995_K) {
            try {
                if (!event.getSpell().isContinuous && event.getSpell().getChargeup() <= 0 && Tales.effects.long_spelled) {
                    return;
                }
                Wizard.conjureCircle(event.getWorld(), event.getSpell().getElement(), event.getCaster().func_174791_d());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void OnCastVertical(SpellCastEvent.Post event) {
        if (event.getCaster() != null && event.getWorld().field_72995_K) {
            try {
                if (!event.getSpell().isContinuous && event.getSpell().getChargeup() <= 0 && Tales.effects.vertical_long_spelled) {
                    return;
                }
                if (event.getSpell().getType() == SpellType.BUFF) {
                    return;
                }
                Wizard.conjureVerticalCircle(event.getWorld(), event.getSpell().getElement(), event.getCaster().func_174791_d(), (Entity)event.getCaster());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void OnCastClient(SpellCastEvent.Post event) {
        if (event.getCaster() != null && event.getWorld().field_72995_K) {
            try {
                Wizard.castParticles(event.getWorld(), event.getSpell().getElement(), event.getCaster().func_174791_d());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void tickCast(SpellCastEvent.Tick event) {
        if (event.getCaster() != null && Solver.doEvery(event.getCount(), 2.0)) {
            try {
                if (!event.getSpell().isContinuous && event.getSpell().getChargeup() <= 0 && Tales.effects.long_spelled) {
                    return;
                }
                Wizard.conjureCircle(event.getWorld(), event.getSpell().getElement(), event.getCaster().func_174791_d());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void castingProcess(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemStack stack2;
            ISpellCastingItem casting;
            Spell spell;
            EntityPlayer player = event.player;
            if (Solver.doEvery((Entity)player, 2.0)) {
                try {
                    if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ISpellCastingItem && (spell = (casting = (ISpellCastingItem)(stack2 = player.func_184607_cu()).func_77973_b()).getCurrentSpell(stack2)) != Spells.none && player.func_184605_cv() < spell.getChargeup()) {
                        Wizard.conjureCircle(player.field_70170_p, spell.getElement(), player.func_174791_d());
                    }
                }
                catch (Exception stack2) {
                    // empty catch block
                }
            }
            if (Solver.doEvery((Entity)player, 0.5)) {
                try {
                    if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ISpellCastingItem && (spell = (casting = (ISpellCastingItem)(stack2 = player.func_184607_cu()).func_77973_b()).getCurrentSpell(stack2)) != Spells.none && player.func_184605_cv() < spell.getChargeup()) {
                        Wizard.castParticles(player.field_70170_p, spell.getElement(), player.func_174791_d(), 9);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

