/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.items;

import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.Mana;
import astramusfate.wizardry_tales.registry.TalesTabs;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPoolFlask
extends Item {
    public final Size size;

    public ItemPoolFlask(Size size) {
        this.size = size;
        this.func_77637_a(TalesTabs.Items);
        this.func_77625_d(16);
    }

    @Nonnull
    public EnumRarity getForgeRarity(@Nonnull ItemStack stack) {
        return this.size.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item.wizardry_tales:pool_flask.desc", new Object[]{this.size.capacity});
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return this.size.useDuration;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack flask = player.func_184586_b(hand);
        ISoul soul = Mana.getSoul(player);
        if (soul != null) {
            if (player.field_71075_bZ.field_75098_d) {
                this.findAndChargeItem(flask, player);
            } else {
                player.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)flask);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)flask);
    }

    public void onUsingTick(@Nonnull ItemStack stack, EntityLivingBase player, int count) {
        if (player.field_70170_p.field_72995_K) {
            float f = (float)count / (float)this.func_77626_a(stack);
            Vec3d pos = player.func_174824_e(0.0f).func_178786_a(0.0, 0.2, 0.0).func_178787_e(player.func_70040_Z().func_186678_a(0.6));
            Vec3d delta = new Vec3d(0.0, 0.2 * (double)f, 0.0).func_178789_a((float)count * 0.5f).func_178785_b((float)Math.toRadians(90.0f - player.field_70759_as));
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(pos.func_178787_e(delta)).vel(delta.func_186678_a(0.2)).time(12 + player.field_70170_p.field_73012_v.nextInt(6)).clr(1.0f, 1.0f, 0.65f).fade(0.7f, 0.0f, 1.0f).spawn(player.field_70170_p);
        }
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && Mana.getSoul((EntityPlayer)entity) != null) {
            this.findAndChargeItem(stack, (EntityPlayer)entity);
        }
        return stack;
    }

    private void findAndChargeItem(ItemStack stack, EntityPlayer player) {
        ISoul soul = Mana.getSoul(player);
        if (soul == null) {
            return;
        }
        if (soul.getMP() < soul.getMaxMP()) {
            soul.addMana(player, this.size.capacity);
            EntityUtils.playSoundAtPlayer((EntityPlayer)player, (SoundEvent)WizardrySounds.ITEM_MANA_FLASK_USE, (float)1.0f, (float)1.0f);
            EntityUtils.playSoundAtPlayer((EntityPlayer)player, (SoundEvent)WizardrySounds.ITEM_MANA_FLASK_RECHARGE, (float)0.7f, (float)1.1f);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 20);
        }
    }

    public static enum Size {
        SMALL(Tales.mp.mana_flask_small, 25, EnumRarity.COMMON),
        MEDIUM(Tales.mp.mana_flask_medium, 40, EnumRarity.COMMON),
        LARGE(Tales.mp.mana_flask_large, 60, EnumRarity.RARE);

        public final int capacity;
        public final int useDuration;
        public final EnumRarity rarity;

        private Size(int capacity, int useDuration, EnumRarity rarity) {
            this.capacity = capacity;
            this.useDuration = useDuration;
            this.rarity = rarity;
        }
    }
}

