/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.proxy;

import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.SoulProvider;
import astramusfate.wizardry_tales.data.packets.PacketAbilityMode;
import astramusfate.wizardry_tales.data.packets.PacketCastingRingCooldown;
import astramusfate.wizardry_tales.data.packets.PacketLearnSpell;
import astramusfate.wizardry_tales.data.packets.PacketRace;
import astramusfate.wizardry_tales.data.packets.PacketSoulMana;
import astramusfate.wizardry_tales.data.packets.PacketSyncLearning;
import astramusfate.wizardry_tales.data.packets.PacketSyncMode;
import astramusfate.wizardry_tales.proxy.CommonProxy;
import astramusfate.wizardry_tales.registry.TalesBlocks;
import astramusfate.wizardry_tales.registry.TalesEntities;
import astramusfate.wizardry_tales.renderers.GuiTalesSpellDisplay;
import astramusfate.wizardry_tales.renderers.layers.LayerBurningDisease;
import astramusfate.wizardry_tales.renderers.layers.LayerLeafDisguise;
import astramusfate.wizardry_tales.renderers.layers.LayerStormArmor;
import astramusfate.wizardry_tales.renderers.layers.LayerTangled;
import astramusfate.wizardry_tales.renderers.layers.TalesLayerTiledOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    public static final KeyBinding CAST_SPELL = new KeyBinding("key.wizardry_tales.cast_spell", (IKeyConflictContext)KeyConflictContext.IN_GAME, 34, "key.categories.wizardry_tales");
    public static final KeyBinding ABILITY_1 = new KeyBinding("key.wizardry_tales.ability_1", (IKeyConflictContext)KeyConflictContext.IN_GAME, 79, "key.categories.wizardry_tales");
    public static final KeyBinding MANUAL_CHANT = new KeyBinding("key.wizardry_tales.manual_chant", (IKeyConflictContext)KeyConflictContext.IN_GAME, 19, "key.categories.wizardry_tales");

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        TalesEntities.RegisterRenderers();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        TalesBlocks.initRenders();
    }

    @Override
    public void handleSoulMana(PacketSoulMana message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ISoul soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul != null) {
            soul.setMP(message.mana);
            soul.setMaxMP(message.maxMana);
        }
    }

    @Override
    public void handleCastingRingCooldown(PacketCastingRingCooldown message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ISoul soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul != null) {
            soul.setCooldown((EntityPlayer)player, message.cooldown);
        }
    }

    @Override
    public void handleRace(PacketRace message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ISoul soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul != null) {
            soul.setRace((EntityPlayer)player, message.race);
        }
    }

    @Override
    public void handleSpellsLearning(PacketSyncLearning message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ISoul soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul != null && Tales.addon.learning) {
            soul.setLearnedSpells((EntityPlayer)player, message.spells);
        }
    }

    @Override
    public void handleLearnSpell(PacketLearnSpell message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ISoul soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul != null && Tales.addon.learning) {
            soul.learnSpell((EntityPlayer)player, message.spell);
        }
    }

    @Override
    public void handleSyncMode(PacketSyncMode message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ISoul soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul != null) {
            soul.setMode((EntityPlayer)player, message.mode);
        }
    }

    @Override
    public void handleAbilitySwitch(PacketAbilityMode message) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ISoul soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul != null) {
            soul.setMode((EntityPlayer)player, message.ability);
        }
    }

    @Override
    public void initialiseLayers() {
        TalesLayerTiledOverlay.initialiseLayers(LayerTangled::new);
        TalesLayerTiledOverlay.initialiseLayers(LayerLeafDisguise::new);
        TalesLayerTiledOverlay.initialiseLayers(LayerBurningDisease::new);
        TalesLayerTiledOverlay.initialiseLayers(LayerStormArmor::new);
    }

    @Override
    public void registerResourceReloadListeners() {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_110542_a(GuiTalesSpellDisplay::loadSkins);
        }
    }

    @Override
    public void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)CAST_SPELL);
        ClientRegistry.registerKeyBinding((KeyBinding)ABILITY_1);
        ClientRegistry.registerKeyBinding((KeyBinding)MANUAL_CHANT);
    }
}

