/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.registry;

import astramusfate.wizardry_tales.api.Alchemy;
import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.api.Tenebria;
import astramusfate.wizardry_tales.potion.BurningDiseaseEffect;
import astramusfate.wizardry_tales.potion.EntangledEffect;
import astramusfate.wizardry_tales.potion.LeafDisguiseEffect;
import astramusfate.wizardry_tales.potion.MageHandEffect;
import astramusfate.wizardry_tales.potion.MantisAgilityEffect;
import astramusfate.wizardry_tales.potion.OreMarkPotion;
import astramusfate.wizardry_tales.potion.StormArmourEffect;
import astramusfate.wizardry_tales.potion.TalesPresetEffect;
import astramusfate.wizardry_tales.potion.TeleportationCurseEffect;
import astramusfate.wizardry_tales.spells.TalesSpells;
import astramusfate.wizardry_tales.spells.list.TeleportationCurse;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.awt.Color;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="wizardry_tales")
@Mod.EventBusSubscriber
public class TalesEffects {
    public static final Potion ore_mark = (Potion)TalesEffects.placeholder();
    public static final Potion entangled = (Potion)TalesEffects.placeholder();
    public static final Potion leaf_disguise = (Potion)TalesEffects.placeholder();
    public static final Potion burning_disease = (Potion)TalesEffects.placeholder();
    public static final Potion wrapped = (Potion)TalesEffects.placeholder();
    public static final Potion storm_armour = (Potion)TalesEffects.placeholder();
    public static final Potion mantis_agility = (Potion)TalesEffects.placeholder();
    public static final Potion teleportation_curse = (Potion)TalesEffects.placeholder();
    public static final Potion mage_hand = (Potion)TalesEffects.placeholder();
    public static final Potion magic_exhaust = (Potion)TalesEffects.placeholder();

    @Nonnull
    private static <T> T placeholder() {
        return null;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "ore_mark", (Potion)new OreMarkPotion());
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "entangled", (Potion)new EntangledEffect());
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "leaf_disguise", (Potion)new LeafDisguiseEffect());
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "burning_disease", (Potion)new BurningDiseaseEffect());
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "storm_armour", (Potion)new StormArmourEffect());
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "mantis_agility", (Potion)new MantisAgilityEffect());
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "teleportation_curse", (Potion)new TeleportationCurseEffect());
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "mage_hand", (Potion)new MageHandEffect());
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "magic_exhaust", (Potion)new TalesPresetEffect("magic_exhaust", "magic_exhaust", 14048000){

            @Override
            public void applyAttributeModifiers() {
                UUID id = UUID.fromString("faa112b1-33f0-5a43-7f3f-06ad62d384f9");
                this.func_111184_a(SharedMonsterAttributes.field_111263_d, id.toString(), -0.2, 2);
                this.func_111184_a(SharedMonsterAttributes.field_188790_f, id.toString(), -0.2, 2);
            }
        });
        TalesEffects.registerPotion((IForgeRegistry<Potion>)registry, "wrapped", (Potion)new TalesPresetEffect("wrapped", "curse_of_nausea", Color.MAGENTA.getRGB()){

            @Override
            public void applyAttributeModifiers() {
                UUID id = UUID.fromString("faa141b0-33f0-4a64-8f2f-06ad62d384f9");
                this.func_111184_a(SharedMonsterAttributes.field_111263_d, id.toString(), -0.2, 2);
                this.func_111184_a(SharedMonsterAttributes.field_188790_f, id.toString(), -0.2, 2);
            }
        });
    }

    public static void registerPotion(IForgeRegistry<Potion> registry, String name, Potion potion) {
        potion.setRegistryName("wizardry_tales", name);
        potion.func_76390_b("potion." + Objects.requireNonNull(potion.getRegistryName()).toString());
        registry.register((IForgeRegistryEntry)potion);
    }

    public static boolean isCursedUndeadly(EntityLivingBase target) {
        return target.func_70644_a(WizardryPotions.curse_of_undeath);
    }

    public static boolean is(PotionEffect potion, Potion effect) {
        return potion.func_188419_a() == effect;
    }

    public static boolean is(PotionEffect potion, Potion ... effects) {
        boolean bool;
        block1: {
            bool = false;
            int n = 0;
            Potion[] potionArray = effects;
            int n2 = potionArray.length;
            if (n >= n2) break block1;
            Potion effect = potionArray[n];
            if (potion.func_188419_a() == effect) {
                bool = true;
            }
        }
        return bool;
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living.func_70644_a(entangled) && (event.getSource().func_76347_k() || event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_76370_b || event.getSource().field_76373_n.equals(MagicDamage.DamageType.FIRE.name()))) {
            event.setAmount(event.getAmount() * (1.0f + TalesSpells.entangle.getProperty("increase_fire_damage").floatValue() / 100.0f));
        }
        if (living.func_70644_a(leaf_disguise)) {
            living.func_184589_d(leaf_disguise);
        }
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && EntityUtils.isMeleeDamage((DamageSource)event.getSource())) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            if (attacker.func_70644_a(storm_armour) && attacker.field_70170_p.func_175710_j(living.func_180425_c().func_177984_a())) {
                EntityLightningBolt lightning = new EntityLightningBolt(attacker.field_70170_p, (double)living.func_180425_c().func_177958_n(), (double)living.func_180425_c().func_177956_o(), (double)living.func_180425_c().func_177952_p(), true);
                Tenebria.create(attacker.field_70170_p, (Entity)lightning);
                if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)living) && living.func_70089_S()) {
                    event.setAmount(event.getAmount() + 4.0f);
                }
            }
            if (attacker.func_70644_a(leaf_disguise)) {
                ((EntityLivingBase)event.getSource().func_76346_g()).func_184589_d(leaf_disguise);
                TalesEffects.removeDisguise(event.getSource().func_76346_g().field_70170_p, (EntityLivingBase)event.getSource().func_76346_g(), 8);
                event.setAmount(event.getAmount() * 1.5f);
            }
        }
        if (living.func_70644_a(burning_disease) && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)living) && living.func_70089_S()) {
            event.setAmount(event.getAmount() + TalesSpells.burning_disease.getProperty("damage").floatValue());
            PotionEffect effect = living.func_70660_b(burning_disease);
            Alchemy.decreaseDuration(living, effect, 40);
            if (Solver.chance(TalesSpells.burning_disease.getProperty("proc_chance").intValue() + (living.func_110143_aJ() <= living.func_110138_aP() * 0.7f && living.func_70027_ad() ? 40 : 0))) {
                event.setAmount(event.getAmount() + TalesSpells.burning_disease.getProperty("proc_damage").floatValue());
                living.func_70015_d(2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onInputUpdateEvent(InputUpdateEvent event) {
        if (event.getEntityPlayer().func_70644_a(magic_exhaust) && Objects.requireNonNull(event.getEntityPlayer().func_70660_b(magic_exhaust)).func_76458_c() > 3) {
            event.getMovementInput().field_78901_c = false;
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (event.getEntityPlayer().func_70644_a(leaf_disguise) && !(event.getItemStack().func_77973_b() instanceof ISpellCastingItem)) {
            event.getEntityPlayer().func_184589_d(leaf_disguise);
            TalesEffects.removeDisguise(event.getEntityPlayer().field_70170_p, (EntityLivingBase)event.getEntityPlayer(), 8);
        }
    }

    @SubscribeEvent
    public static void onPlayerPickedAsTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && event.getTarget().func_70644_a(leaf_disguise) && event.getTarget().func_70093_af() && event.getEntityLiving().func_70643_av() != event.getTarget() && event.getEntityLiving() instanceof EntityLiving) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerSpellcast(SpellCastEvent.Pre event) {
        if (event.getCaster() != null && event.getCaster().func_70644_a(leaf_disguise)) {
            event.getCaster().func_184589_d(leaf_disguise);
            TalesEffects.removeDisguise(event.getWorld(), event.getCaster(), 8);
        }
    }

    public static void removeDisguise(World world, EntityLivingBase target, int count) {
        if (world.field_72995_K) {
            for (int i = 0; i < count; ++i) {
                double x = target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() / 2.0;
                double y = target.field_70163_u + world.field_73012_v.nextDouble();
                double z = target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() / 2.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).pos(x, y, z).time(20).spawn(world);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity;
        if (Solver.doEvery(event.getEntityLiving().field_70173_aa, 10.0) && event.getEntityLiving().func_70089_S() && (entity = event.getEntityLiving()).func_70644_a(teleportation_curse)) {
            World world = entity.field_70170_p;
            double minRadius = TalesSpells.teleportation_curse.getProperty("minimum_teleport_distance").doubleValue();
            double maxRadius = TalesSpells.teleportation_curse.getProperty("maximum_teleport_distance").doubleValue();
            double radius = minRadius + world.field_73012_v.nextDouble() * maxRadius - minRadius;
            TeleportationCurse.teleport(entity, world, radius);
        }
    }
}

