/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.registry;

import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.entity.EntityManaBomb;
import astramusfate.wizardry_tales.entity.construct.EntityMagicCircle;
import astramusfate.wizardry_tales.entity.construct.EntityPoisonousGas;
import astramusfate.wizardry_tales.entity.construct.EntityRedGas;
import astramusfate.wizardry_tales.entity.construct.sigils.EntityMagicCircleVertical;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCircleAreaOnceCast;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCircleArray;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCircleManaCollector;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCircleTeleportation;
import astramusfate.wizardry_tales.entity.construct.sigils.chanting.EntityCustomSigil;
import astramusfate.wizardry_tales.entity.living.EntityBigMushroom;
import astramusfate.wizardry_tales.entity.living.EntityEnvenomedBlade;
import astramusfate.wizardry_tales.entity.living.EntityMushroom;
import astramusfate.wizardry_tales.entity.projectile.EntityChantingArrow;
import astramusfate.wizardry_tales.entity.summon.EntityEmber;
import astramusfate.wizardry_tales.renderers.RenderBigMushroom;
import astramusfate.wizardry_tales.renderers.RenderCircle;
import astramusfate.wizardry_tales.renderers.RenderEnvenomedBlade;
import astramusfate.wizardry_tales.renderers.RenderMushroom;
import astramusfate.wizardry_tales.renderers.RenderNothing;
import astramusfate.wizardry_tales.renderers.RenderVerticalCircle;
import electroblob.wizardry.client.renderer.entity.RenderProjectile;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="wizardry_tales")
public class TalesEntities {
    private static int id = 0;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry reg = event.getRegistry();
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityMushroom.class, "mushroom", TrackingType.LIVING).egg(8851717, 15456465).spawn(EnumCreatureType.MONSTER, Tales.entities.mushroomSpawnRate, 1, 4, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> Arrays.asList(Tales.toResourceLocations(Tales.entities.mushroomBiomeWhitelist)).contains(b.getRegistryName())).collect(Collectors.toSet())).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityBigMushroom.class, "big_mushroom", TrackingType.LIVING).egg(8851717, 15456465).spawn(EnumCreatureType.MONSTER, Tales.entities.big_mushroomSpawnRate, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> Arrays.asList(Tales.toResourceLocations(Tales.entities.big_mushroomBiomeWhitelist)).contains(b.getRegistryName())).collect(Collectors.toSet())).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityEnvenomedBlade.class, "envenomed_blade", TrackingType.LIVING).egg(3442504, 4753183).spawn(EnumCreatureType.MONSTER, Tales.entities.envenomed_bladeSpawnRate, 1, 1, (Iterable)ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> Arrays.asList(Tales.toResourceLocations(Tales.entities.envenomed_bladeBiomeWhitelist)).contains(b.getRegistryName())).collect(Collectors.toSet())).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityPoisonousGas.class, "poisonous_gas", TrackingType.CONSTRUCT).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityRedGas.class, "red_gas", TrackingType.CONSTRUCT).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityChantingArrow.class, "chanting_arrow", TrackingType.PROJECTILE).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityManaBomb.class, "mana_bomb", TrackingType.PROJECTILE).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityEmber.class, "ember", TrackingType.LIVING).build());
        TalesEntities.registerCircles((IForgeRegistry<EntityEntry>)reg);
    }

    private static void registerCircles(IForgeRegistry<EntityEntry> reg) {
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityMagicCircle.class, "circle", TrackingType.CONSTRUCT).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityMagicCircleVertical.class, "vertical_circle", TrackingType.CONSTRUCT).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityCircleManaCollector.class, "circle_collector", TrackingType.CONSTRUCT).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityCircleAreaOnceCast.class, "circle_area_once", TrackingType.CONSTRUCT).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityCircleTeleportation.class, "circle_teleport", TrackingType.CONSTRUCT).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityCustomSigil.class, "circle_sigil", TrackingType.CONSTRUCT).build());
        reg.register((IForgeRegistryEntry)TalesEntities.createEntry(EntityCircleArray.class, "circle_array", TrackingType.CONSTRUCT).build());
    }

    @SideOnly(value=Side.CLIENT)
    public static void RegisterRenderers() {
        TalesEntities.registerNothing(EntityPoisonousGas.class);
        TalesEntities.registerNothing(EntityRedGas.class);
        TalesEntities.registerNothing(EntityEmber.class);
        TalesEntities.registerNothing(EntityChantingArrow.class);
        RenderingRegistry.registerEntityRenderingHandler(EntityManaBomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("wizardry_tales", "textures/items/mana_bomb.png"), false));
        TalesEntities.registerRender(EntityMushroom.class, RenderMushroom::new);
        TalesEntities.registerRender(EntityBigMushroom.class, RenderBigMushroom::new);
        TalesEntities.registerRender(EntityEnvenomedBlade.class, RenderEnvenomedBlade::new);
        TalesEntities.registerCirclesRenderers();
    }

    public static <T extends Entity> void registerNothing(Class<T> entityClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, RenderNothing::new);
    }

    public static <T extends Entity> void registerRender(Class<T> entityClass, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerCirclesRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicCircle.class, manager -> new RenderCircle(manager, 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityMagicCircleVertical.class, manager -> new RenderVerticalCircle(manager, 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityCircleManaCollector.class, manager -> new RenderCircle(manager, 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityCircleAreaOnceCast.class, manager -> new RenderCircle(manager, 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityCircleTeleportation.class, manager -> new RenderCircle(manager, 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomSigil.class, manager -> new RenderCircle(manager, 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityCircleArray.class, manager -> new RenderCircle(manager, 0.5f));
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, TrackingType tracking) {
        return TalesEntities.createEntry(entityClass, name).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name) {
        ResourceLocation registryName = new ResourceLocation("wizardry_tales", name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    static enum TrackingType {
        LIVING(80, 3, true),
        PROJECTILE(64, 10, true),
        CONSTRUCT(160, 10, false);

        int range;
        int interval;
        boolean trackVelocity;

        private TrackingType(int range, int interval, boolean trackVelocity) {
            this.range = range;
            this.interval = interval;
            this.trackVelocity = trackVelocity;
        }
    }
}

