/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.registry;

import astramusfate.wizardry_tales.items.ItemChantingScroll;
import astramusfate.wizardry_tales.items.ItemManaBomb;
import astramusfate.wizardry_tales.items.ItemManaDust;
import astramusfate.wizardry_tales.items.ItemPoolFlask;
import astramusfate.wizardry_tales.items.ItemTales;
import astramusfate.wizardry_tales.items.TalesArtefact;
import astramusfate.wizardry_tales.items.TalesBook;
import astramusfate.wizardry_tales.items.TalesScroll;
import astramusfate.wizardry_tales.items.TalesWandUpgrade;
import astramusfate.wizardry_tales.items.artefacts.ChantingCloak;
import astramusfate.wizardry_tales.items.artefacts.ChantingRing;
import astramusfate.wizardry_tales.items.artefacts.IceHalberd;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemBlockMultiTextured;
import electroblob.wizardry.registry.WizardryTabs;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="wizardry_tales")
@Mod.EventBusSubscriber
public final class TalesItems {
    @GameRegistry.ObjectHolder(value="chant_upgrade_range")
    public static final Item chant_upgrade_range = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="chant_upgrade_power")
    public static final Item chant_upgrade_power = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="chant_upgrade_duration")
    public static final Item chant_upgrade_duration = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="chant_upgrade_delay")
    public static final Item chant_upgrade_delay = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="chant_upgrade_count")
    public static final Item chant_upgrade_count = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="tales_book")
    public static final Item tales_book = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="tales_scroll")
    public static final Item tales_scroll = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="chanting_scroll")
    public static final Item chanting_scroll = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="ring_poison_entangle")
    public static final Item ring_poison_entangle = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="ring_protector")
    public static final Item ring_protector = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="ring_new_moon")
    public static final Item ring_new_moon = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="amulet_petal_blooming")
    public static final Item amulet_petal_blooming = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="artefact_earth")
    public static final Item artefact_earth = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="ice_halberd")
    public static final Item ice_halberd = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="casting_ring")
    public static final Item casting_ring = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="chanting_cloak")
    public static final Item chanting_cloak = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="chanting_ring")
    public static final Item chanting_ring = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="mana_bomb")
    public static final Item mana_bomb = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="dull_ring")
    public static final Item dull_ring = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="chanting_stone")
    public static final Item chanting_stone = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="small_pool_flask")
    public static final Item small_pool_flask = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="medium_pool_flask")
    public static final Item medium_pool_flask = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="large_pool_flask")
    public static final Item large_pool_flask = (Item)TalesItems.placeholder();
    @GameRegistry.ObjectHolder(value="mana_dust")
    public static final Item mana_dust = (Item)TalesItems.placeholder();

    private TalesItems() {
    }

    @Nonnull
    private static <T> T placeholder() {
        return null;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Item> event) {
        IForgeRegistry reg = event.getRegistry();
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "chant_upgrade_range", (Item)new TalesWandUpgrade());
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "chant_upgrade_power", (Item)new TalesWandUpgrade());
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "chant_upgrade_duration", (Item)new TalesWandUpgrade());
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "chant_upgrade_delay", (Item)new TalesWandUpgrade());
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "chant_upgrade_count", (Item)new TalesWandUpgrade());
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "small_pool_flask", new ItemPoolFlask(ItemPoolFlask.Size.SMALL));
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "medium_pool_flask", new ItemPoolFlask(ItemPoolFlask.Size.MEDIUM));
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "large_pool_flask", new ItemPoolFlask(ItemPoolFlask.Size.LARGE));
        reg.register((IForgeRegistryEntry)new TalesBook());
        reg.register((IForgeRegistryEntry)new TalesScroll());
        reg.register((IForgeRegistryEntry)new ItemChantingScroll());
        reg.register((IForgeRegistryEntry)new TalesArtefact("artefact_earth", EnumRarity.RARE, ItemArtefact.Type.AMULET));
        reg.register((IForgeRegistryEntry)new TalesArtefact("amulet_petal_blooming", EnumRarity.UNCOMMON, ItemArtefact.Type.AMULET));
        reg.register((IForgeRegistryEntry)new TalesArtefact("ring_protector", EnumRarity.RARE, ItemArtefact.Type.RING));
        reg.register((IForgeRegistryEntry)new TalesArtefact("ring_new_moon", EnumRarity.COMMON, ItemArtefact.Type.RING));
        reg.register((IForgeRegistryEntry)new TalesArtefact("ring_poison_entangle", EnumRarity.RARE, ItemArtefact.Type.RING));
        reg.register((IForgeRegistryEntry)new TalesArtefact("casting_ring", EnumRarity.EPIC, ItemArtefact.Type.RING));
        reg.register((IForgeRegistryEntry)new TalesArtefact("dull_ring", EnumRarity.COMMON, ItemArtefact.Type.RING));
        reg.register((IForgeRegistryEntry)new ChantingCloak("chanting_cloak"));
        reg.register((IForgeRegistryEntry)new ChantingRing("chanting_ring", EnumRarity.COMMON, ItemArtefact.Type.RING));
        reg.register((IForgeRegistryEntry)new IceHalberd());
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "mana_bomb", new ItemManaBomb());
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "chanting_stone", new ItemTales(16));
        TalesItems.registerItem((IForgeRegistry<Item>)reg, "mana_dust", new ItemManaDust());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRegistryModel(ModelRegistryEvent e) {
        TalesItems.registerItemModel(tales_book);
        TalesItems.registerItemModel(tales_scroll);
        TalesItems.registerItemModel(chanting_scroll);
        TalesItems.registryModel(ring_protector);
        TalesItems.registryModel(ring_new_moon);
        TalesItems.registryModel(ring_poison_entangle);
        TalesItems.registryModel(casting_ring);
        TalesItems.registryModel(chanting_cloak);
        TalesItems.registryModel(chanting_ring);
        TalesItems.registryModel(amulet_petal_blooming);
        TalesItems.registryModel(artefact_earth);
        TalesItems.registryModel(ice_halberd);
        TalesItems.registryModel(mana_bomb);
        TalesItems.registryModel(dull_ring);
        TalesItems.registryModel(chanting_stone);
        TalesItems.registryModel(small_pool_flask);
        TalesItems.registryModel(medium_pool_flask);
        TalesItems.registryModel(large_pool_flask);
        TalesItems.registryModel(mana_dust);
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, Item item) {
        TalesItems.registerItem(registry, name, item, false);
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, String modid, Item item) {
        TalesItems.registerItem(registry, name, modid, item, false);
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, Item item, boolean setTabIcon) {
        item.setRegistryName("wizardry_tales", name);
        item.func_77655_b("wizardry_tales:" + name);
        registry.register((IForgeRegistryEntry)item);
        if (setTabIcon && item.func_77640_w() instanceof WizardryTabs.CreativeTabSorted) {
            ((WizardryTabs.CreativeTabSorted)item.func_77640_w()).setIconItem(new ItemStack(item));
        }
        if (item.func_77640_w() instanceof WizardryTabs.CreativeTabListed) {
            ((WizardryTabs.CreativeTabListed)item.func_77640_w()).order.add(item);
        }
    }

    public static void registerItem(IForgeRegistry<Item> registry, String modid, String name, Item item, boolean setTabIcon) {
        item.setRegistryName(modid, name);
        item.setRegistryName(Objects.requireNonNull(item.getRegistryName()).toString());
        registry.register((IForgeRegistryEntry)item);
        if (setTabIcon && item.func_77640_w() instanceof WizardryTabs.CreativeTabSorted) {
            ((WizardryTabs.CreativeTabSorted)item.func_77640_w()).setIconItem(new ItemStack(item));
        }
        if (item.func_77640_w() instanceof WizardryTabs.CreativeTabListed) {
            ((WizardryTabs.CreativeTabListed)item.func_77640_w()).order.add(item);
        }
    }

    private static void registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        Item itemblock = (Item)new ItemBlock(block).setRegistryName(Objects.requireNonNull(block.getRegistryName()));
        registry.register((IForgeRegistryEntry)itemblock);
    }

    private static void registerItemBlock(IForgeRegistry<Item> registry, Block block, Item itemblock) {
        itemblock.setRegistryName(Objects.requireNonNull(block.getRegistryName()));
        registry.register((IForgeRegistryEntry)itemblock);
    }

    private static void registerItemModel(Item item) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)item, s -> new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void registryModel(Item item) {
        ResourceLocation regName = item.getRegistryName();
        assert (regName != null);
        ModelResourceLocation mrl = new ModelResourceLocation(regName, "inventory");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{mrl});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)mrl);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registryModel(Item item, String regMame) {
        item.setRegistryName(regMame);
        item.func_77655_b(regMame);
        ResourceLocation regName = item.getRegistryName();
        assert (regName != null);
        ModelResourceLocation mrl = new ModelResourceLocation(regName, "inventory");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{mrl});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)mrl);
    }

    private static void registerItemBlock(IForgeRegistry<Item> registry, String name, Block block, ItemBlock itemblock) {
        itemblock.setRegistryName("wizardry_tales", name);
        registry.register((IForgeRegistryEntry)itemblock);
        if (block.func_149708_J() instanceof WizardryTabs.CreativeTabListed) {
            ((WizardryTabs.CreativeTabListed)block.func_149708_J()).order.add(itemblock);
        }
    }

    private static void registerMultiTexturedItemBlock(IForgeRegistry<Item> registry, Block block, boolean separateNames, String ... prefixes) {
        Item itemblock = (Item)new ItemBlockMultiTextured(block, separateNames, prefixes).setRegistryName(Objects.requireNonNull(block.getRegistryName()));
        registry.register((IForgeRegistryEntry)itemblock);
        if (block.func_149708_J() instanceof WizardryTabs.CreativeTabListed) {
            ((WizardryTabs.CreativeTabListed)block.func_149708_J()).order.add(itemblock);
        }
    }
}

