/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.registry;

import astramusfate.wizardry_tales.WizardryTales;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class TalesLoot {
    private static LootTable WAND_UPGRADES;
    private static LootTable UNCOMMON_ARTEFACTS;
    private static LootTable RARE_ARTEFACTS;
    private static LootTable EPIC_ARTEFACTS;

    private TalesLoot() {
    }

    public static void preInit() {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "subsets/uncommon_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "subsets/rare_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "subsets/epic_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "chests/shrine"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "chests/anchor"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "chests/underground_house"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "chests/high_values_double"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "chests/dungeon_additions"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("wizardry_tales", "grant_book_on_first_join"));
    }

    @SubscribeEvent
    public static void onLootTableLoadEvent(LootTableLoadEvent event) {
        LootPool sourcePool;
        LootPool targetPool;
        if (event.getName().toString().equals("wizardry_tales:subsets/uncommon_artefacts")) {
            UNCOMMON_ARTEFACTS = event.getTable();
        }
        if (event.getName().toString().equals("wizardry_tales:subsets/rare_artefacts")) {
            RARE_ARTEFACTS = event.getTable();
        }
        if (event.getName().toString().equals("wizardry_tales:subsets/epic_artefacts")) {
            EPIC_ARTEFACTS = event.getTable();
        }
        if (event.getName().toString().equals("ebwizardry:subsets/uncommon_artefacts") && UNCOMMON_ARTEFACTS != null) {
            targetPool = event.getTable().getPool("uncommon_artefacts");
            sourcePool = UNCOMMON_ARTEFACTS.getPool("main");
            TalesLoot.injectEntries(sourcePool, targetPool);
        }
        if (event.getName().toString().equals("ebwizardry:subsets/rare_artefacts") && RARE_ARTEFACTS != null) {
            targetPool = event.getTable().getPool("rare_artefacts");
            sourcePool = RARE_ARTEFACTS.getPool("main");
            TalesLoot.injectEntries(sourcePool, targetPool);
        }
        if (event.getName().toString().equals("ebwizardry:subsets/epic_artefacts") && EPIC_ARTEFACTS != null) {
            targetPool = event.getTable().getPool("epic_artefacts");
            sourcePool = EPIC_ARTEFACTS.getPool("main");
            TalesLoot.injectEntries(sourcePool, targetPool);
        }
    }

    private static void injectEntries(LootPool sourcePool, LootPool targetPool) {
        if (sourcePool != null && targetPool != null) {
            List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)sourcePool, (String)"field_186453_a");
            for (LootEntry entry : lootEntries) {
                targetPool.addEntry(entry);
            }
        } else {
            WizardryTales.log.warn("Attempted to inject to null pool source or target.");
        }
    }

    private static LootPool getAdditive(String entryName, String poolName) {
        return new LootPool(new LootEntry[]{TalesLoot.getAdditiveEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "wizardry_tales_" + poolName);
    }

    private static LootEntryTable getAdditiveEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation(name), weight, 0, new LootCondition[0], "wizardry_tales_additive_entry");
    }
}

