/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.renderers.layers;

import astramusfate.wizardry_tales.api.Arcanist;
import astramusfate.wizardry_tales.registry.TalesEffects;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerStormArmor
extends LayerArmorBase<ModelBiped> {
    private final RenderLivingBase<?> renderer;

    public LayerStormArmor(RenderLivingBase<?> rendererIn) {
        super(rendererIn);
        this.renderer = rendererIn;
    }

    protected void func_177177_a() {
        this.field_177189_c = new ModelBiped(0.5f);
        this.field_177186_d = new ModelBiped(1.0f);
    }

    protected void setModelSlotVisible(@Nonnull ModelBiped model, EntityEquipmentSlot slotIn) {
        this.setModelVisible(model);
        switch (slotIn) {
            case HEAD: {
                model.field_78116_c.field_78806_j = true;
                model.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                model.field_78115_e.field_78806_j = true;
                model.field_178723_h.field_78806_j = true;
                model.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                model.field_78115_e.field_78806_j = true;
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
            }
        }
    }

    public boolean isReady(EntityLivingBase living) {
        return living.func_70644_a(TalesEffects.storm_armour);
    }

    public boolean isEmpowered(EntityLivingBase living) {
        return living.func_70644_a(MobEffects.field_76420_g) || living.func_70644_a(MobEffects.field_76429_m);
    }

    public void func_177141_a(@Nonnull EntityLivingBase living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.isReady(living)) {
            this.renderArmorLayer(living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
            this.renderArmorLayer(living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
            this.renderArmorLayer(living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
            this.renderArmorLayer(living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
        }
    }

    protected void setModelVisible(ModelBiped model) {
        model.func_178719_a(false);
    }

    @Nonnull
    protected ModelBiped getArmorModelHook(@Nonnull EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped model) {
        return model;
    }

    @Nonnull
    public ResourceLocation getArmorResource(@Nonnull Entity entity, @Nonnull ItemStack stack, @Nonnull EntityEquipmentSlot slot, @Nonnull String type) {
        String string = "textures/layers/storm_king_armor.png";
        if (slot == EntityEquipmentSlot.LEGS) {
            string = "textures/layers/storm_king_armor_legs.png";
        }
        return new ResourceLocation("wizardry_tales", string);
    }

    private void renderArmorLayer(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn) {
        ModelBiped t = (ModelBiped)this.func_188360_a(slotIn);
        t.func_178686_a(this.renderer.func_177087_b());
        t.func_78086_a(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
        this.setModelSlotVisible(t, slotIn);
        boolean flag = this.isLegSlot(slotIn);
        String string = "textures/layers/storm_king_armor.png";
        if (flag) {
            string = "textures/layers/storm_king_armor_legs.png";
        }
        this.renderer.func_110776_a(new ResourceLocation("wizardry_tales", string));
        Arcanist.alpha(1.0f);
        t.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (this.isEmpowered(entityLivingBaseIn)) {
            LayerStormArmor.func_188364_a(this.renderer, (EntityLivingBase)entityLivingBaseIn, (ModelBase)t, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
        }
    }

    private boolean isLegSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.LEGS;
    }
}

