/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.spells.list;

import astramusfate.wizardry_tales.blocks.tile.TileEntityBlooming;
import astramusfate.wizardry_tales.registry.TalesBlocks;
import astramusfate.wizardry_tales.registry.TalesItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Blooming
extends Spell {
    public Blooming() {
        super("wizardry_tales", "blooming", SpellActions.POINT, false);
        this.addProperties(new String[]{"range", "duration", "effect_duration", "effect_strength"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        RayTraceResult rayTrace = RayTracer.standardBlockRayTrace((World)world, (EntityLivingBase)caster, (double)range, (boolean)false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_178782_a();
            if (rayTrace.field_178784_b == EnumFacing.UP && world.isSideSolid(pos, EnumFacing.UP) && BlockUtils.canBlockBeReplaced((World)world, (BlockPos)pos.func_177984_a())) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos.func_177984_a(), TalesBlocks.blooming_flower.func_176223_P());
                    TileEntity tileEntity = world.func_175625_s(pos.func_177984_a());
                    if (tileEntity instanceof TileEntityBlooming) {
                        TileEntityBlooming tile = (TileEntityBlooming)tileEntity;
                        tile.setCaster(caster);
                        tile.setDurationMod(modifiers.get(WizardryItems.duration_upgrade));
                        tile.setPotencyMod(modifiers.get("potency"));
                        world.markAndNotifyBlock(pos.func_177984_a(), null, world.func_180495_p(pos.func_177984_a()), world.func_180495_p(pos.func_177984_a()), 3);
                    }
                }
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                return true;
            }
        }
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == TalesItems.tales_book || item == TalesItems.tales_scroll;
    }
}

