/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.spells.list;

import astramusfate.wizardry_tales.api.Sage;
import astramusfate.wizardry_tales.registry.TalesEffects;
import astramusfate.wizardry_tales.registry.TalesItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BurningDisease
extends SpellRay {
    public static final String PROC_DAMAGE = "proc_damage";
    public static final String PROC_CHANCE = "proc_chance";

    public BurningDisease() {
        super("wizardry_tales", "burning_disease", SpellActions.POINT, false);
        this.addProperties(new String[]{"effect_duration", "effect_strength", "damage", PROC_DAMAGE, PROC_CHANCE});
        this.soundValues(1.0f, 1.4f, 0.4f);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(TalesEffects.burning_disease, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(Sage.DURATION)), this.getProperty("effect_strength").intValue()));
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean applicableForItem(Item item) {
        return item == TalesItems.tales_book || item == TalesItems.tales_scroll;
    }
}

