/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.spells.list;

import astramusfate.wizardry_tales.api.Sage;
import astramusfate.wizardry_tales.registry.TalesEffects;
import astramusfate.wizardry_tales.registry.TalesItems;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Entangle
extends SpellRay {
    public static final String FIRE_DAMAGE = "increase_fire_damage";

    public Entangle() {
        super("wizardry_tales", "entangle", SpellActions.POINT, false);
        this.addProperties(new String[]{"effect_duration", "effect_strength", FIRE_DAMAGE, "damage_if_burning"});
        this.soundValues(1.0f, 1.4f, 0.4f);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            if (target.func_70027_ad()) {
                return false;
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(TalesEffects.entangled, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(Sage.DURATION)), this.getProperty("effect_strength").intValue()));
            if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)TalesItems.ring_poison_entangle)) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(Sage.DURATION)), (int)Math.min((float)this.getProperty("effect_strength").intValue() * (modifiers.get("potency") - 0.25f), 1.0f)));
            }
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = world.field_73012_v.nextFloat() * 0.25f;
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(20 + world.field_73012_v.nextInt(8)).clr(brightness, brightness + 0.1f, 0.0f).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).pos(x, y, z).vel(0.0, -0.01, 0.0).time(40 + world.field_73012_v.nextInt(10)).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == TalesItems.tales_book || item == TalesItems.tales_scroll;
    }
}

