/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.spells.list;

import astramusfate.wizardry_tales.api.Alchemy;
import astramusfate.wizardry_tales.api.Selena;
import astramusfate.wizardry_tales.api.Wizard;
import astramusfate.wizardry_tales.registry.TalesItems;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class Meow
extends Spell {
    public static final String NBT_KEY = "fearedEntity";
    public static final String DURATION = "duration";

    public Meow() {
        super("wizardry_tales", "meow", SpellActions.POINT_DOWN, false);
        this.addProperties(new String[]{"range", DURATION});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null) {
            List<EntityCreeper> creepers = Selena.getAround(world, (float)this.getProperty("range").intValue() * modifiers.get("potency"), caster.func_180425_c(), EntityCreeper.class);
            if (creepers.isEmpty()) {
                return false;
            }
            for (EntityCreeper creep : creepers) {
                int bonusAmplifier = SpellBuff.getStandardBonusAmplifier((float)modifiers.get("potency"));
                NBTTagCompound entityNBT = creep.getEntityData();
                entityNBT.func_186854_a(NBT_KEY, caster.func_110124_au());
                Alchemy.applyPotionHide((EntityLivingBase)creep, (int)(this.getProperty(DURATION).floatValue() * modifiers.get(WizardryItems.duration_upgrade)), bonusAmplifier, WizardryPotions.fear);
                Wizard.conjureCircle(world, Element.EARTH, creep.func_174791_d());
            }
            return true;
        }
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == TalesItems.tales_book || item == TalesItems.tales_scroll;
    }
}

