/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.spells.list;

import astramusfate.wizardry_tales.api.Sage;
import astramusfate.wizardry_tales.registry.TalesItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class NecroAttackSpell
extends SpellRay {
    public NecroAttackSpell() {
        super("wizardry_tales", "necro_attack", SpellActions.POINT, false);
        this.addProperties(new String[]{"damage"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.WITHER, (Entity)target)) {
                if (!world.field_72995_K && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else {
                Sage.causeDamage(MagicDamage.DamageType.WITHER, caster, target, Math.min(this.getProperty("damage").floatValue() * modifiers.get("potency"), this.getProperty("damage").floatValue() * 2.0f));
            }
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        world.func_175688_a(EnumParticleTypes.PORTAL, x, y - 0.5, z, 0.0, 0.0, 0.0, new int[0]);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.2f, 0.0f, 0.2f).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == TalesItems.tales_book || item == TalesItems.tales_scroll;
    }
}

