/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.worldgen;

import astramusfate.wizardry_tales.data.Tales;
import com.google.common.collect.ImmutableList;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockPedestal;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityShrineCore;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenAnchor
extends WorldGenSurfaceStructure {
    private static final String CORE_DATA_BLOCK_TAG = "core";
    private static final List<BiomeDictionary.Type> BIOME_TYPES = ImmutableList.of((Object)BiomeDictionary.Type.FOREST, (Object)BiomeDictionary.Type.JUNGLE, (Object)BiomeDictionary.Type.SWAMP, (Object)BiomeDictionary.Type.WASTELAND, (Object)BiomeDictionary.Type.HOT);

    public String getStructureName() {
        return "anchor";
    }

    public ResourceLocation getStructureFile(Random random) {
        return new ResourceLocation("wizardry_tales", "anchor");
    }

    public long getRandomSeedModifier() {
        return 15512579L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        if (!ArrayUtils.contains((int[])Tales.struct.anchor_angry_dims, (int)world.field_73011_w.getDimension())) return false;
        if (!BiomeDictionary.getTypes((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16))).stream().anyMatch(BIOME_TYPES::contains)) return false;
        if (Tales.struct.anchor_angry <= 0) return false;
        if (random.nextInt(Tales.struct.anchor_angry) != 0) return false;
        return true;
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        ITemplateProcessor processor = (w, p, i) -> {
            TileEntity tile = w.func_175625_s(p);
            if (w.func_180495_p(p).func_177230_c() == WizardryBlocks.magic_light && tile instanceof TileEntityTimer) {
                ((TileEntityTimer)tile).setLifetime(-1);
            }
            return i;
        };
        template.func_189960_a(world, origin, processor, settings, 18);
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            if (((String)entry.getValue()).equals(CORE_DATA_BLOCK_TAG)) {
                world.func_175656_a((BlockPos)entry.getKey(), WizardryBlocks.runestone_pedestal.func_176223_P().func_177226_a((IProperty)BlockPedestal.ELEMENT, (Comparable)Element.SORCERY).func_177226_a((IProperty)BlockPedestal.NATURAL, (Comparable)Boolean.valueOf(true)));
                TileEntity core = world.func_175625_s((BlockPos)entry.getKey());
                TileEntity container = world.func_175625_s(((BlockPos)entry.getKey()).func_177984_a());
                if (container != null) {
                    container.getTileData().func_186854_a("arcaneLockOwner", new UUID(0L, 0L));
                    if (core instanceof TileEntityShrineCore) {
                        ((TileEntityShrineCore)core).linkContainer(container);
                        continue;
                    }
                    Wizardry.logger.info("What?!");
                    continue;
                }
                Wizardry.logger.info("Expected chest or other container at {} in structure {}, found no tile entity", entry.getKey(), (Object)structureFile);
                continue;
            }
            Wizardry.logger.info("Unrecognised data block value {} in structure {}", entry.getValue(), (Object)structureFile);
        }
    }
}

