/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.worldgen;

import astramusfate.wizardry_tales.data.Tales;
import com.google.common.collect.ImmutableList;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenFlyingLibrary
extends WorldGenSurfaceStructure {
    private static final List<BiomeDictionary.Type> BIOME_TYPES = ImmutableList.of((Object)BiomeDictionary.Type.FOREST, (Object)BiomeDictionary.Type.JUNGLE, (Object)BiomeDictionary.Type.SWAMP);

    public String getStructureName() {
        return "flying_library";
    }

    public ResourceLocation getStructureFile(Random random) {
        return new ResourceLocation("wizardry_tales", "flying_library");
    }

    public long getRandomSeedModifier() {
        return 13458697L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        if (!ArrayUtils.contains((int[])Tales.struct.flying_lib_dims, (int)world.field_73011_w.getDimension())) return false;
        if (!BiomeDictionary.getTypes((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16))).stream().anyMatch(BIOME_TYPES::contains)) return false;
        if (Tales.struct.flying_lib <= 0) return false;
        if (random.nextInt(Tales.struct.flying_lib) != 0) return false;
        return true;
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Biome biome = world.func_180494_b(origin);
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{new WoodTypeTemplateProcessor(woodType), (w, p, i) -> {
            TileEntityBookshelf.markAsNatural((NBTTagCompound)i.field_186244_c);
            return i;
        }});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
    }
}

