/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.worldgen;

import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.data.Tales;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockRunestone;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.integration.antiqueatlas.WizardryAntiqueAtlasIntegration;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenLibrary
extends WorldGenSurfaceStructure {
    private static final List<BiomeDictionary.Type> BIOME_TYPES = ImmutableList.of((Object)BiomeDictionary.Type.FOREST, (Object)BiomeDictionary.Type.JUNGLE, (Object)BiomeDictionary.Type.SWAMP, (Object)BiomeDictionary.Type.MESA, (Object)BiomeDictionary.Type.MOUNTAIN, (Object)BiomeDictionary.Type.NETHER, (Object)BiomeDictionary.Type.SANDY);
    private static final String WIZARD_DATA_BLOCK_TAG = "wizard";
    private static final String YOUNG_WIZARD_DATA_BLOCK_TAG = "young";
    private final Map<BiomeDictionary.Type, IBlockState> specialWallBlocks = ImmutableMap.of((Object)BiomeDictionary.Type.MESA, (Object)Blocks.field_180395_cM.func_176223_P(), (Object)BiomeDictionary.Type.MOUNTAIN, (Object)Blocks.field_150417_aV.func_176223_P(), (Object)BiomeDictionary.Type.NETHER, (Object)Blocks.field_150385_bj.func_176223_P(), (Object)BiomeDictionary.Type.SANDY, (Object)Blocks.field_150322_A.func_176223_P());

    public String getStructureName() {
        return "library";
    }

    public ResourceLocation getStructureFile(Random random) {
        return new ResourceLocation("wizardry_tales", "library");
    }

    public long getRandomSeedModifier() {
        return 15867967L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        if (!ArrayUtils.contains((int[])Tales.struct.lib_dims, (int)world.field_73011_w.getDimension())) return false;
        if (!BiomeDictionary.getTypes((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16))).stream().anyMatch(BIOME_TYPES::contains)) return false;
        if (Tales.struct.lib <= 0) return false;
        if (random.nextInt(Tales.struct.lib) != 0) return false;
        return true;
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Biome biome = world.func_180494_b(origin);
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        Element element = Element.values()[1 + random.nextInt(Element.values().length - 1)];
        IBlockState wallMaterial = this.specialWallBlocks.keySet().stream().filter(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)).findFirst().map(this.specialWallBlocks::get).orElse(Blocks.field_150347_e.func_176223_P());
        HashSet blocksPlaced = new HashSet();
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{new WoodTypeTemplateProcessor(woodType), (w, p, i) -> {
            TileEntityBookshelf.markAsNatural((NBTTagCompound)i.field_186244_c);
            return i;
        }, (w, p, i) -> i.field_186243_b.func_177230_c() instanceof BlockRunestone ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a((IProperty)BlockRunestone.ELEMENT, (Comparable)element), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150347_e ? new Template.BlockInfo(i.field_186242_a, wallMaterial, i.field_186244_c) : i, (w, p, i) -> {
            if (i.field_186243_b.func_177230_c() != Blocks.field_150350_a) {
                blocksPlaced.add(p);
            }
            return i;
        }});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
        WizardryAntiqueAtlasIntegration.markLibrary((World)world, (int)origin.func_177958_n(), (int)origin.func_177952_p(), (boolean)false);
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            EntityWizard wizard;
            Vec3d vec = GeometryUtils.getCentre((BlockPos)((BlockPos)entry.getKey()));
            if (((String)entry.getValue()).equals(WIZARD_DATA_BLOCK_TAG)) {
                wizard = new EntityWizard(world);
                wizard.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
                wizard.func_180482_a(world.func_175649_E(origin), null);
                wizard.setTowerBlocks(blocksPlaced);
                world.func_72838_d((Entity)wizard);
                continue;
            }
            if (((String)entry.getValue()).equals(YOUNG_WIZARD_DATA_BLOCK_TAG)) {
                if (!Solver.chance(30)) continue;
                wizard = new EntityWizard(world);
                wizard.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
                wizard.func_180482_a(world.func_175649_E(origin), null);
                wizard.setTowerBlocks(blocksPlaced);
                world.func_72838_d((Entity)wizard);
                continue;
            }
            Wizardry.logger.info("Unrecognised data block value {} in structure {}", entry.getValue(), (Object)structureFile);
        }
    }
}

