/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.worldgen;

import astramusfate.wizardry_tales.data.Tales;
import com.google.common.collect.ImmutableList;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenPeacefulAnchor
extends WorldGenSurfaceStructure {
    private static final List<BiomeDictionary.Type> BIOME_TYPES = ImmutableList.of((Object)BiomeDictionary.Type.FOREST, (Object)BiomeDictionary.Type.JUNGLE, (Object)BiomeDictionary.Type.SWAMP, (Object)BiomeDictionary.Type.WASTELAND, (Object)BiomeDictionary.Type.HOT);

    public String getStructureName() {
        return "anchor_peaceful";
    }

    public ResourceLocation getStructureFile(Random random) {
        return new ResourceLocation("wizardry_tales", "anchor_peaceful");
    }

    public long getRandomSeedModifier() {
        return 16792834L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        if (!ArrayUtils.contains((int[])Tales.struct.anchor_dims, (int)world.field_73011_w.getDimension())) return false;
        if (!BiomeDictionary.getTypes((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16))).stream().anyMatch(BIOME_TYPES::contains)) return false;
        if (Tales.struct.anchor <= 0) return false;
        if (random.nextInt(Tales.struct.anchor) != 0) return false;
        return true;
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        ITemplateProcessor processor = (w, p, i) -> {
            TileEntity tile = w.func_175625_s(p);
            if (w.func_180495_p(p).func_177230_c() == WizardryBlocks.magic_light && tile instanceof TileEntityTimer) {
                ((TileEntityTimer)tile).setLifetime(-1);
            }
            return i;
        };
        template.func_189960_a(world, origin, processor, settings, 18);
    }
}

