/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.worldgen;

import astramusfate.wizardry_tales.data.Tales;
import com.google.common.collect.ImmutableList;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenShrineHealing
extends WorldGenSurfaceStructure {
    private static final List<BiomeDictionary.Type> BIOME_TYPES = ImmutableList.of((Object)BiomeDictionary.Type.FOREST, (Object)BiomeDictionary.Type.MOUNTAIN, (Object)BiomeDictionary.Type.JUNGLE);

    public String getStructureName() {
        return "shrine_healing";
    }

    public ResourceLocation getStructureFile(Random random) {
        return new ResourceLocation("wizardry_tales", "shrine_healing");
    }

    public long getRandomSeedModifier() {
        return 13621824L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        if (!ArrayUtils.contains((int[])Tales.struct.shrine_healing_dims, (int)world.field_73011_w.getDimension())) return false;
        if (!BiomeDictionary.getTypes((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16))).stream().anyMatch(BIOME_TYPES::contains)) return false;
        if (Tales.struct.shrine_healing <= 0) return false;
        if (random.nextInt(Tales.struct.shrine_healing) != 0) return false;
        return true;
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Biome biome = world.func_180494_b(origin);
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{new WoodTypeTemplateProcessor(woodType)});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
    }
}

