/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.worldgen;

import astramusfate.wizardry_tales.data.Tales;
import com.google.common.collect.ImmutableList;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import electroblob.wizardry.worldgen.WorldGenUndergroundStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenUndergroundHouse
extends WorldGenUndergroundStructure {
    private static final List<BiomeDictionary.Type> BIOME_TYPES = ImmutableList.of((Object)BiomeDictionary.Type.SANDY, (Object)BiomeDictionary.Type.JUNGLE, (Object)BiomeDictionary.Type.SWAMP);

    public String getStructureName() {
        return "underground_house";
    }

    public long getRandomSeedModifier() {
        return 12016745L;
    }

    public ResourceLocation getStructureFile(Random random) {
        return new ResourceLocation("wizardry_tales", "underground_house");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        if (!ArrayUtils.contains((int[])Tales.struct.underground_house_dims, (int)world.field_73011_w.getDimension())) return false;
        if (!BiomeDictionary.getTypes((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16))).stream().anyMatch(BIOME_TYPES::contains)) return false;
        if (Tales.struct.underground_house <= 0) return false;
        if (random.nextInt(Tales.struct.underground_house) != 0) return false;
        return true;
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Biome biome = world.func_180494_b(origin);
        float stoneBrickChance = random.nextFloat();
        float mossiness = 0.6f;
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{(w, p, i) -> w.func_175623_d(p) ? null : i, (w, p, i) -> {
            if (w.field_73012_v.nextFloat() > stoneBrickChance) {
                if (i.field_186243_b.func_177230_c() == Blocks.field_150347_e) {
                    return new Template.BlockInfo(i.field_186242_a, Blocks.field_150417_aV.func_176223_P(), i.field_186244_c);
                }
                if (i.field_186243_b.func_177230_c() == Blocks.field_150333_U && i.field_186243_b.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.COBBLESTONE) {
                    return new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SMOOTHBRICK), i.field_186244_c);
                }
                if (i.field_186243_b.func_177230_c() == Blocks.field_150446_ar) {
                    return new Template.BlockInfo(i.field_186242_a, BlockUtils.copyState((Block)Blocks.field_150390_bg, (IBlockState)i.field_186243_b), i.field_186244_c);
                }
            }
            return i;
        }, new WoodTypeTemplateProcessor(woodType), new MossifierTemplateProcessor(0.6f, 0.04f, origin.func_177956_o() + 1), (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150417_aV && w.field_73012_v.nextFloat() < 0.1f ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED), i.field_186244_c) : i, (w, p, i) -> {
            TileEntityBookshelf.markAsNatural((NBTTagCompound)i.field_186244_c);
            return i;
        }});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
    }
}

