/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.TargetHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.logic.knockback.ConfigurableKnockback;
import net.bettercombat.mixin.LivingEntityAccessor;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.MathHelper;
import net.bettercombat.utils.SoundHelper;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2824;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import org.slf4j.Logger;

public class ServerNetwork {
    static final Logger LOGGER = LogUtils.getLogger();
    private static class_2540 configSerialized = PacketByteBufs.create();
    private static final UUID COMBO_DAMAGE_MODIFIER_ID = UUID.randomUUID();
    private static final UUID DUAL_WIELDING_MODIFIER_ID = UUID.randomUUID();
    private static final UUID SWEEPING_MODIFIER_ID = UUID.randomUUID();

    public static void initializeHandlers() {
        configSerialized = Packets.ConfigSync.write(BetterCombat.config);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            sender.sendPacket(Packets.WeaponRegistrySync.ID, WeaponRegistry.getEncodedRegistry());
            sender.sendPacket(Packets.ConfigSync.ID, configSerialized);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.AttackAnimation.ID, (server, player, handler, buf, responseSender) -> {
            class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_37908()).orNull();
            if (world == null || world.field_9236) {
                return;
            }
            Packets.AttackAnimation packet = Packets.AttackAnimation.read(buf);
            class_2540 forwardBuffer = new Packets.AttackAnimation(player.method_5628(), packet.animatedHand(), packet.animationName(), packet.length(), packet.upswing()).write();
            try {
                if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)Packets.AttackAnimation.ID)) {
                    ServerPlayNetworking.send((class_3222)player, (class_2960)Packets.AttackAnimation.ID, (class_2540)forwardBuffer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            PlayerLookup.tracking((class_1297)player).forEach(serverPlayer -> {
                try {
                    if (ServerPlayNetworking.canSend((class_3222)serverPlayer, (class_2960)Packets.AttackAnimation.ID)) {
                        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)Packets.AttackAnimation.ID, (class_2540)forwardBuffer);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.C2S_AttackRequest.ID, (server, player, handler, buf, responseSender) -> {
            class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_37908()).orNull();
            if (world == null || world.field_9236) {
                return;
            }
            Packets.C2S_AttackRequest request = Packets.C2S_AttackRequest.read(buf);
            AttackHand hand = PlayerAttackHelper.getCurrentAttack((class_1657)player, request.comboCount());
            if (hand == null) {
                LOGGER.error("Server handling Packets.C2S_AttackRequest - No current attack hand!");
                LOGGER.error("Combo count: " + request.comboCount() + " is dual wielding: " + PlayerAttackHelper.isDualWielding((class_1657)player));
                LOGGER.error("Main-hand stack: " + player.method_6047());
                LOGGER.error("Off-hand stack: " + player.method_6079());
                LOGGER.error("Selected slot server: " + player.method_31548().field_7545 + " | client: " + request.selectedSlot());
                return;
            }
            WeaponAttributes.Attack attack = hand.attack();
            WeaponAttributes attributes = hand.attributes();
            boolean useVanillaPacket = Packets.C2S_AttackRequest.UseVanillaPacket;
            world.method_8503().method_40000(() -> {
                ((PlayerAttackProperties)player).setComboCount(request.comboCount());
                HashMultimap comboAttributes = null;
                HashMultimap dualWieldingAttributes = null;
                HashMultimap sweepingModifiers = HashMultimap.create();
                double range = 18.0;
                if (attributes != null && attack != null) {
                    range = attributes.attackRange();
                    comboAttributes = HashMultimap.create();
                    double comboMultiplier = attack.damageMultiplier() - 1.0;
                    comboAttributes.put((Object)class_5134.field_23721, (Object)new class_1322(COMBO_DAMAGE_MODIFIER_ID, "COMBO_DAMAGE_MULTIPLIER", comboMultiplier, class_1322.class_1323.field_6330));
                    player.method_6127().method_26854((Multimap)comboAttributes);
                    float dualWieldingMultiplier = PlayerAttackHelper.getDualWieldingAttackDamageMultiplier((class_1657)player, hand) - 1.0f;
                    if (dualWieldingMultiplier != 0.0f) {
                        dualWieldingAttributes = HashMultimap.create();
                        dualWieldingAttributes.put((Object)class_5134.field_23721, (Object)new class_1322(DUAL_WIELDING_MODIFIER_ID, "DUAL_WIELDING_DAMAGE_MULTIPLIER", (double)dualWieldingMultiplier, class_1322.class_1323.field_6331));
                        player.method_6127().method_26854((Multimap)dualWieldingAttributes);
                    }
                    if (hand.isOffHand()) {
                        PlayerAttackHelper.setAttributesForOffHandAttack((class_1657)player, true);
                    }
                    SoundHelper.playSound(world, (class_1297)player, attack.swingSound());
                    if (BetterCombat.config.allow_reworked_sweeping && request.entityIds().length > 1) {
                        boolean playEffects;
                        double multiplier = 1.0 - (double)(BetterCombat.config.reworked_sweeping_maximum_damage_penalty / (float)BetterCombat.config.reworked_sweeping_extra_target_count * (float)Math.min(BetterCombat.config.reworked_sweeping_extra_target_count, request.entityIds().length - 1));
                        int sweepingLevel = class_1890.method_8225((class_1887)class_1893.field_9115, (class_1799)hand.itemStack());
                        double sweepingSteps = (double)BetterCombat.config.reworked_sweeping_enchant_restores / (double)class_1893.field_9115.method_8183();
                        multiplier += (double)sweepingLevel * sweepingSteps;
                        multiplier = Math.min(multiplier, 1.0);
                        sweepingModifiers.put((Object)class_5134.field_23721, (Object)new class_1322(SWEEPING_MODIFIER_ID, "SWEEPING_DAMAGE_MODIFIER", multiplier - 1.0, class_1322.class_1323.field_6331));
                        player.method_6127().method_26854((Multimap)sweepingModifiers);
                        boolean bl = playEffects = !BetterCombat.config.reworked_sweeping_sound_and_particles_only_for_swords || hand.itemStack().method_7909() instanceof class_1829;
                        if (BetterCombat.config.reworked_sweeping_plays_sound && playEffects) {
                            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14706, player.method_5634(), 1.0f, 1.0f);
                        }
                        if (BetterCombat.config.reworked_sweeping_emits_particles && playEffects) {
                            player.method_7263();
                        }
                    }
                }
                float attackCooldown = PlayerAttackHelper.getAttackCooldownTicksCapped((class_1657)player);
                float knockbackMultiplier = BetterCombat.config.knockback_reduced_for_fast_attacks ? MathHelper.clamp(attackCooldown / 12.5f, 0.1f, 1.0f) : 1.0f;
                int lastAttackedTicks = ((LivingEntityAccessor)player).getLastAttackedTicks();
                if (!useVanillaPacket) {
                    player.method_5660(request.isSneaking());
                }
                for (int entityId : request.entityIds()) {
                    class_1309 livingEntity;
                    boolean isBossPart = false;
                    class_1297 entity = world.method_8469(entityId);
                    if (entity == null) {
                        isBossPart = true;
                        entity = world.method_31424(entityId);
                    }
                    if (entity == null || entity.equals((Object)player.method_5854()) && !TargetHelper.isAttackableMount(entity) || entity instanceof class_1531 && ((class_1531)entity).method_6912()) continue;
                    if (entity instanceof class_1309) {
                        livingEntity = (class_1309)entity;
                        if (BetterCombat.config.allow_fast_attacks) {
                            livingEntity.field_6008 = 0;
                        }
                        if (knockbackMultiplier != 1.0f) {
                            ((ConfigurableKnockback)livingEntity).setKnockbackMultiplier_BetterCombat(knockbackMultiplier);
                        }
                    }
                    ((LivingEntityAccessor)player).setLastAttackedTicks(lastAttackedTicks);
                    if (!isBossPart && useVanillaPacket) {
                        class_2824 vanillaAttackPacket = class_2824.method_34206((class_1297)entity, (boolean)request.isSneaking());
                        handler.method_12062(vanillaAttackPacket);
                    } else {
                        if (entity instanceof class_1542 || entity instanceof class_1303 || entity instanceof class_1665 || entity == player) {
                            handler.method_14367((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.invalid_entity_attacked"));
                            LOGGER.warn("Player {} tried to attack an invalid entity", (Object)player.method_5477().getString());
                            return;
                        }
                        player.method_7324(entity);
                    }
                    if (!(entity instanceof class_1309)) continue;
                    livingEntity = (class_1309)entity;
                    if (knockbackMultiplier == 1.0f) continue;
                    ((ConfigurableKnockback)livingEntity).setKnockbackMultiplier_BetterCombat(1.0f);
                }
                if (!useVanillaPacket) {
                    player.method_14234();
                }
                if (comboAttributes != null) {
                    player.method_6127().method_26847((Multimap)comboAttributes);
                    if (hand.isOffHand()) {
                        PlayerAttackHelper.setAttributesForOffHandAttack((class_1657)player, false);
                    }
                }
                if (dualWieldingAttributes != null) {
                    player.method_6127().method_26847(dualWieldingAttributes);
                }
                if (!sweepingModifiers.isEmpty()) {
                    player.method_6127().method_26847((Multimap)sweepingModifiers);
                }
                ((PlayerAttackProperties)player).setComboCount(-1);
            });
        });
    }
}

