/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.network;

import com.google.gson.Gson;
import java.util.List;
import net.bettercombat.config.ServerConfig;
import net.bettercombat.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.bettercombat.logic.AnimatedHand;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class Packets {

    public record ConfigSync(String json) {
        public static ResourceLocation ID = new ResourceLocation("bettercombat", "config_sync");

        public static String serialize(ServerConfig config) {
            Gson gson = new Gson();
            return gson.toJson((Object)config);
        }

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.m_130070_(this.json);
            return buffer;
        }

        public static ServerConfig read(FriendlyByteBuf buffer) {
            Gson gson = new Gson();
            String json = buffer.m_130277_();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return config;
        }
    }

    public record WeaponRegistrySync(List<String> chunks) {
        public static ResourceLocation ID = new ResourceLocation("bettercombat", "weapon_registry");

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeInt(this.chunks.size());
            for (String chunk : this.chunks) {
                buffer.m_130070_(chunk);
            }
            return buffer;
        }

        public static ServerConfig read(FriendlyByteBuf buffer) {
            Gson gson = new Gson();
            String json = buffer.m_130277_();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return config;
        }
    }

    public record AttackSound(double x, double y, double z, String soundId, float volume, float pitch, long seed) {
        public static ResourceLocation ID = new ResourceLocation("bettercombat", "attack_sound");

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeDouble(this.x);
            buffer.writeDouble(this.y);
            buffer.writeDouble(this.z);
            buffer.m_130070_(this.soundId);
            buffer.writeFloat(this.volume);
            buffer.writeFloat(this.pitch);
            buffer.writeLong(this.seed);
            return buffer;
        }

        public static AttackSound read(FriendlyByteBuf buffer) {
            double x = buffer.readDouble();
            double y = buffer.readDouble();
            double z = buffer.readDouble();
            String soundId = buffer.m_130277_();
            float volume = buffer.readFloat();
            float pitch = buffer.readFloat();
            long seed = buffer.readLong();
            return new AttackSound(x, y, z, soundId, volume, pitch, seed);
        }
    }

    public record AttackAnimation(int playerId, AnimatedHand animatedHand, String animationName, float length, float upswing) {
        public static ResourceLocation ID = new ResourceLocation("bettercombat", "attack_animation");
        public static String StopSymbol = "!STOP!";

        public static AttackAnimation stop(int playerId, int length) {
            return new AttackAnimation(playerId, AnimatedHand.MAIN_HAND, StopSymbol, length, 0.0f);
        }

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeInt(this.playerId);
            buffer.writeInt(this.animatedHand.ordinal());
            buffer.m_130070_(this.animationName);
            buffer.writeFloat(this.length);
            buffer.writeFloat(this.upswing);
            return buffer;
        }

        public static AttackAnimation read(FriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            AnimatedHand animatedHand = AnimatedHand.values()[buffer.readInt()];
            String animationName = buffer.m_130277_();
            float length = buffer.readFloat();
            float upswing = buffer.readFloat();
            return new AttackAnimation(playerId, animatedHand, animationName, length, upswing);
        }
    }

    public record C2S_AttackRequest(int comboCount, boolean isSneaking, int selectedSlot, int[] entityIds) {
        public static ResourceLocation ID = new ResourceLocation("bettercombat", "c2s_request_attack");
        public static boolean UseVanillaPacket = true;

        public C2S_AttackRequest(int comboCount, boolean isSneaking, int selectedSlot, List<Entity> entities) {
            this(comboCount, isSneaking, selectedSlot, C2S_AttackRequest.convertEntityList(entities));
        }

        private static int[] convertEntityList(List<Entity> entities) {
            int[] ids = new int[entities.size()];
            for (int i = 0; i < entities.size(); ++i) {
                ids[i] = entities.get(i).m_19879_();
            }
            return ids;
        }

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeInt(this.comboCount);
            buffer.writeBoolean(this.isSneaking);
            buffer.writeInt(this.selectedSlot);
            buffer.m_130089_(this.entityIds);
            return buffer;
        }

        public static C2S_AttackRequest read(FriendlyByteBuf buffer) {
            int comboCount = buffer.readInt();
            boolean isSneaking = buffer.readBoolean();
            int selectedSlot = buffer.readInt();
            int[] ids = buffer.m_130100_();
            return new C2S_AttackRequest(comboCount, isSneaking, selectedSlot, ids);
        }
    }
}

