/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.entity;

import hu.xannosz.betterminecarts.entity.AbstractLocomotive;
import hu.xannosz.betterminecarts.entity.ModEntities;
import hu.xannosz.betterminecarts.item.ModItems;
import hu.xannosz.betterminecarts.screen.SteamLocomotiveMenu;
import hu.xannosz.betterminecarts.utils.ButtonId;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import hu.xannosz.betterminecarts.utils.MinecartHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SteamLocomotive
extends AbstractLocomotive
implements Container {
    public static final int STEAM_KEY = 4;
    public static final int WATER_KEY = 5;
    public static final int HEAT_KEY = 6;
    public static final int BURN_KEY = 7;
    public static final int MAX_BURN_KEY = 8;
    public static final int DATA_SIZE = 9;
    public static final int MAX_STEAM = 2000;
    public static final int MAX_WATER = 2000;
    public static final int MAX_HEAT = 520;
    public static final int MINIMUM_HEAT = 32;
    public static final int MINIMUM_STEAM = 10;
    private int steam = 0;
    private int water = 0;
    private int heat = 32;
    private int burn = 0;
    private int maxBurn = 0;
    private int clock = 0;
    private final ItemStackHandler itemHandler = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            SteamLocomotive.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 1, 2, 3 -> {
                    if (stack.m_41720_() == Items.f_42447_) {
                        yield true;
                    }
                    yield false;
                }
                case 4, 5, 6, 7 -> {
                    if (ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public SteamLocomotive(EntityType<?> entityType, Level level) {
        super(entityType, level, MinecartColor.LIGHT_GRAY, MinecartColor.GRAY, 9);
    }

    public SteamLocomotive(Level level, double x, double y, double z, MinecartColor top, MinecartColor bottom) {
        super((EntityType)ModEntities.STEAM_LOCOMOTIVE.get(), x, y, z, level, top, bottom, 9);
    }

    @NotNull
    protected Item m_213728_() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + 1);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        ItemStack locomotive = new ItemStack((ItemLike)ModItems.STEAM_LOCOMOTIVE.get());
        locomotive.m_41784_().m_128359_("topColor", this.getTopFilter().getLabel());
        locomotive.m_41784_().m_128359_("bottomColor", this.getBottomFilter().getLabel());
        if (this.m_8077_()) {
            locomotive.m_41714_(this.m_7770_());
        }
        inventory.m_6836_(this.itemHandler.getSlots(), locomotive);
        Containers.m_19002_((Level)this.f_19853_, (BlockPos)this.m_20183_(), (Container)inventory);
        return Items.f_41852_;
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        this.updateData();
        return new SteamLocomotiveMenu(id, inventory, (Entity)this, this.data);
    }

    @Override
    protected boolean canPush() {
        return this.steam > 10;
    }

    public boolean canWhistle() {
        if (this.steam > 10) {
            --this.steam;
            return true;
        }
        return false;
    }

    @Override
    protected List<Component> getEngineData() {
        return Arrays.asList(Component.m_237115_((String)"text.betterminecarts.data.water").m_7220_((Component)Component.m_237113_((String)(this.water + "/2000")).m_130940_(ChatFormatting.BLUE)), Component.m_237115_((String)"text.betterminecarts.data.steam").m_7220_((Component)Component.m_237113_((String)(this.steam + "/2000")).m_130940_(ChatFormatting.GRAY)), Component.m_237115_((String)"text.betterminecarts.data.bucket").m_7220_((Component)Component.m_237113_((String)("" + (this.itemHandler.getStackInSlot(1).m_41613_() + this.itemHandler.getStackInSlot(2).m_41613_() + this.itemHandler.getStackInSlot(3).m_41613_()))).m_130940_(ChatFormatting.BOLD)), Component.m_237115_((String)"text.betterminecarts.data.coal").m_7220_((Component)Component.m_237113_((String)(this.itemHandler.getStackInSlot(4).m_41613_() + "/" + this.itemHandler.getStackInSlot(5).m_41613_() + "/" + this.itemHandler.getStackInSlot(6).m_41613_() + "/" + this.itemHandler.getStackInSlot(7).m_41613_())).m_130940_(ChatFormatting.BLACK)));
    }

    @Override
    public void updateData() {
        this.data.m_8050_(4, this.steam);
        this.data.m_8050_(5, this.water);
        this.data.m_8050_(6, this.heat);
        this.data.m_8050_(7, this.burn);
        this.data.m_8050_(8, this.maxBurn);
        super.updateData();
        if (this.f_19853_.m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(MinecartHelper.IS_BURN, (Object)(this.burn > 0 ? 1 : 0));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Steam", this.steam);
        compoundTag.m_128405_("Water", this.water);
        compoundTag.m_128405_("Heat", this.heat);
        compoundTag.m_128405_("Burn", this.burn);
        compoundTag.m_128405_("MaxBurn", this.maxBurn);
        compoundTag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.steam = compoundTag.m_128451_("Steam");
        this.water = compoundTag.m_128451_("Water");
        this.heat = compoundTag.m_128451_("Heat");
        this.burn = compoundTag.m_128451_("Burn");
        this.maxBurn = compoundTag.m_128451_("MaxBurn");
        this.itemHandler.deserializeNBT(compoundTag.m_128469_("Inventory"));
        this.updateData();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isBurn() && this.f_19796_.m_188503_(2) == 0) {
            Vec3 smokeCoordinates = this.getSmokeCoordinates();
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, smokeCoordinates.m_7096_() + ((double)this.f_19796_.m_188501_() - 0.5) * 0.1, smokeCoordinates.m_7098_(), smokeCoordinates.m_7094_() + ((double)this.f_19796_.m_188501_() - 0.5) * 0.1, 0.0, 0.2, 0.0);
        }
        if (this.f_19853_.m_5776_()) {
            return;
        }
        --this.burn;
        this.burn = Math.max(this.burn, 0);
        this.heat = this.burn > 0 ? ++this.heat : --this.heat;
        this.heat = Math.max(Math.min(this.heat, 520), 32);
        if (this.clock > 4) {
            this.clock = 0;
            if (!this.activeButton.equals((Object)ButtonId.PAUSE)) {
                this.steam -= this.speed;
            }
            this.moveStack(2, 1);
            this.moveStack(3, 2);
            this.moveStack(5, 4);
            this.moveStack(6, 5);
            this.moveStack(7, 6);
        } else {
            ++this.clock;
        }
        if (this.heat > 110 && this.water > 0 && this.steam < 1999) {
            this.steam += 2;
            --this.water;
            --this.heat;
        }
        if (this.heat < 100) {
            if (this.steam > 2) {
                ++this.water;
            }
            this.steam -= 3;
        }
        this.steam = Math.max(Math.min(this.steam, 2000), 0);
        this.water = Math.max(Math.min(this.water, 2000), 0);
        if (this.burn == 0 && !this.activeButton.equals((Object)ButtonId.STOP) && this.heat < 210) {
            this.consumeFuel();
        }
        if (this.water <= 1000) {
            this.loadWater();
        }
        if (this.steam < 10 && this.activeButton != ButtonId.PAUSE) {
            this.xPush = 0.0;
            this.zPush = 0.0;
            this.activeButton = ButtonId.STOP;
        }
        this.updateData();
        this.m_6596_();
    }

    private Vec3 getSmokeCoordinates() {
        switch (this.m_6374_()) {
            case NORTH: {
                return new Vec3(this.m_20185_(), this.m_20186_() + 1.23, this.m_20189_() - 0.45);
            }
            case SOUTH: {
                return new Vec3(this.m_20185_(), this.m_20186_() + 1.23, this.m_20189_() + 0.45);
            }
            case WEST: {
                return new Vec3(this.m_20185_() - 0.45, this.m_20186_() + 1.23, this.m_20189_());
            }
            case EAST: {
                return new Vec3(this.m_20185_() + 0.45, this.m_20186_() + 1.23, this.m_20189_());
            }
        }
        return new Vec3(this.m_20185_(), this.m_20186_() + 1.23, this.m_20189_());
    }

    private void consumeFuel() {
        if (this.itemHandler.getStackInSlot(4).m_41720_().equals(Items.f_41852_)) {
            return;
        }
        if (this.itemHandler.getStackInSlot(4).m_41720_().equals(Items.f_42448_)) {
            if (this.itemHandler.getStackInSlot(0).m_41619_()) {
                this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_, 1));
            } else if (this.itemHandler.getStackInSlot(0).m_41613_() < 16) {
                this.itemHandler.getStackInSlot(0).m_41769_(1);
            } else {
                return;
            }
        }
        this.burn = this.maxBurn = ForgeHooks.getBurnTime((ItemStack)this.itemHandler.getStackInSlot(4), (RecipeType)RecipeType.f_44108_);
        this.itemHandler.getStackInSlot(4).m_41774_(1);
    }

    private void loadWater() {
        if (this.itemHandler.getStackInSlot(1).m_41720_().equals(Items.f_42447_)) {
            if (this.itemHandler.getStackInSlot(0).m_41619_()) {
                this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_, 1));
            } else if (this.itemHandler.getStackInSlot(0).m_41613_() < 16) {
                this.itemHandler.getStackInSlot(0).m_41769_(1);
            } else {
                return;
            }
            this.itemHandler.getStackInSlot(1).m_41774_(1);
            this.water += 1000;
        }
    }

    private void moveStack(int s, int t) {
        if (this.itemHandler.getStackInSlot(s).m_41619_()) {
            return;
        }
        if (this.itemHandler.getStackInSlot(t).m_41619_()) {
            this.itemHandler.setStackInSlot(t, new ItemStack((ItemLike)this.itemHandler.getStackInSlot(s).m_41720_(), 1));
        } else if (this.itemHandler.getStackInSlot(t).m_41613_() < this.itemHandler.getStackInSlot(t).m_41741_() && this.itemHandler.getStackInSlot(s).m_41720_().equals(this.itemHandler.getStackInSlot(t).m_41720_())) {
            this.itemHandler.getStackInSlot(t).m_41769_(1);
        } else {
            return;
        }
        this.itemHandler.getStackInSlot(s).m_41774_(1);
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MinecartHelper.IS_BURN, (Object)false);
    }

    public boolean isBurn() {
        return (Boolean)this.f_19804_.m_135370_(MinecartHelper.IS_BURN);
    }

    public int m_6643_() {
        return 8;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemstack = this.itemHandler.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int count) {
        if (slot == 0) {
            return count > 0 ? this.itemHandler.getStackInSlot(slot).m_41620_(count) : ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Blocks.f_50016_, 0);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return this.m_8020_(slot);
    }

    public void m_6836_(int slot, @NotNull ItemStack itemStack) {
        this.itemHandler.setStackInSlot(slot, itemStack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player player) {
        return false;
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, new ItemStack((ItemLike)Blocks.f_50016_, 0));
        }
    }

    public boolean m_7013_(int slot, @NotNull ItemStack itemStack) {
        return this.itemHandler.isItemValid(slot, itemStack);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IItemHandler> getLazyItemHandler() {
        return this.lazyItemHandler;
    }
}

