/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.item;

import hu.xannosz.betterminecarts.entity.AbstractLocomotive;
import hu.xannosz.betterminecarts.entity.ElectricLocomotive;
import hu.xannosz.betterminecarts.entity.SteamLocomotive;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractLocomotiveItem
extends Item {
    public static final String TOP_COLOR_TAG = "topColor";
    public static final String BOTTOM_COLOR_TAG = "bottomColor";
    private final boolean isSteam;

    public AbstractLocomotiveItem(boolean isSteam) {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40752_));
        this.isSteam = isSteam;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        BlockPos blockpos = useOnContext.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        MinecartColor topColor = MinecartColor.getFromLabel(useOnContext.m_43722_().m_41784_().m_128461_(TOP_COLOR_TAG));
        MinecartColor bottomColor = MinecartColor.getFromLabel(useOnContext.m_43722_().m_41784_().m_128461_(BOTTOM_COLOR_TAG));
        if (topColor == null || bottomColor == null) {
            if (this.isSteam) {
                topColor = MinecartColor.LIGHT_GRAY;
                bottomColor = MinecartColor.GRAY;
            } else {
                topColor = MinecartColor.YELLOW;
                bottomColor = MinecartColor.BROWN;
            }
        }
        if (!blockstate.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = useOnContext.m_43722_();
        if (!level.f_46443_) {
            AbstractLocomotive abstractLocomotive;
            RailShape railshape = blockstate.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)level, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.m_61745_()) {
                d0 = 0.5;
            }
            AbstractLocomotive abstractLocomotive2 = abstractLocomotive = this.isSteam ? this.createSteamLocomotive(bottomColor, topColor, level, blockpos, d0) : this.createElectricLocomotive(bottomColor, topColor, level, blockpos, d0);
            if (itemstack.m_41788_()) {
                abstractLocomotive.m_6593_(itemstack.m_41786_());
                abstractLocomotive.m_20340_(true);
            }
            abstractLocomotive.setStartDirection(useOnContext.m_8125_());
            level.m_7967_((Entity)abstractLocomotive);
            level.m_220407_(GameEvent.f_157810_, blockpos, GameEvent.Context.m_223719_((Entity)useOnContext.m_43723_(), (BlockState)level.m_8055_(blockpos.m_7495_())));
        }
        itemstack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        MinecartColor topColor = MinecartColor.getFromLabel(itemStack.m_41784_().m_128461_(TOP_COLOR_TAG));
        MinecartColor bottomColor = MinecartColor.getFromLabel(itemStack.m_41784_().m_128461_(BOTTOM_COLOR_TAG));
        if (topColor == null || bottomColor == null) {
            if (this.isSteam) {
                topColor = MinecartColor.LIGHT_GRAY;
                bottomColor = MinecartColor.GRAY;
            } else {
                topColor = MinecartColor.YELLOW;
                bottomColor = MinecartColor.BROWN;
            }
        }
        components.add((Component)Component.m_237115_((String)("text.betterminecarts.locomotive.color." + topColor.getLabel())).m_130940_(topColor.getLabelColor()));
        components.add((Component)Component.m_237115_((String)("text.betterminecarts.locomotive.color." + bottomColor.getLabel())).m_130940_(bottomColor.getLabelColor()));
        super.m_7373_(itemStack, level, components, tooltipFlag);
    }

    private AbstractLocomotive createElectricLocomotive(MinecartColor bottom, MinecartColor top, Level level, BlockPos blockpos, double d0) {
        return new ElectricLocomotive(level, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5, top, bottom);
    }

    private AbstractLocomotive createSteamLocomotive(MinecartColor bottom, MinecartColor top, Level level, BlockPos blockpos, double d0) {
        return new SteamLocomotive(level, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5, top, bottom);
    }

    @NotNull
    public String m_5524_() {
        return "item.betterminecarts." + this.getLocomotiveName();
    }

    public String getLocomotiveName() {
        return (this.isSteam ? "steam" : "electric") + "_locomotive";
    }
}

