/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.mixin;

import hu.xannosz.betterminecarts.config.BetterMinecartsConfig;
import hu.xannosz.betterminecarts.utils.Linkable;
import hu.xannosz.betterminecarts.utils.MinecartHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecartFurnace.class})
public abstract class FurnaceMinecartEntityMixin
extends AbstractMinecart
implements Linkable {
    @Shadow
    private int f_38548_;
    @Shadow
    public double f_38545_;
    @Shadow
    public double f_38546_;
    @Shadow
    @Final
    @Mutable
    private static Ingredient f_38549_;
    @Unique
    private int altFuel;
    @Unique
    private double altPushX;
    @Unique
    private double altPushZ;
    @Unique
    private static final Ingredient OLD_ACCEPTABLE_FUEL;
    @Unique
    private final Set<AbstractMinecart> train = new HashSet<AbstractMinecart>();
    @Unique
    private ChunkPos prevChunkPos;

    @Shadow
    protected abstract boolean m_38579_();

    @Shadow
    public abstract InteractionResult m_6096_(Player var1, InteractionHand var2);

    protected FurnaceMinecartEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDD)V"}, at={@At(value="TAIL")})
    public void betterminecarts$initPrevChunPos(Level world, double x, double y, double z, CallbackInfo info) {
        this.prevChunkPos = this.m_146902_();
    }

    @Inject(method={"getMaxSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    public void betterminecarts$increaseSpeed(CallbackInfoReturnable<Double> info) {
        if (this.m_38579_()) {
            info.setReturnValue((Object)2.0);
        } else {
            info.setReturnValue((Object)super.m_7097_());
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void betterminecarts$loadChunks(CallbackInfo info) {
        Level level;
        if (((Boolean)BetterMinecartsConfig.FURNACE_MINECARTS_LOAD_CHUNKS.get()).booleanValue() && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ChunkPos currentChunkPos = SectionPos.m_235861_((EntityAccess)this).m_123251_();
            if (this.f_38548_ > 0) {
                server.m_7726_().m_8387_(TicketType.f_9444_, currentChunkPos, 3, (Object)this.m_146902_());
            }
            if (!currentChunkPos.equals((Object)this.prevChunkPos) || this.f_38548_ <= 0) {
                server.m_7726_().m_8438_(TicketType.f_9444_, this.prevChunkPos, 3, (Object)this.m_146902_());
            }
            this.prevChunkPos = currentChunkPos;
        }
    }

    @Inject(method={"moveAlongTrack"}, at={@At(value="TAIL")})
    public void betterminecarts$slowDown(BlockPos pos, BlockState state, CallbackInfo info) {
        if (this.altFuel <= 0 && this.f_38548_ > 0) {
            if (state.m_60713_(Blocks.f_50030_) && !((Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
                this.altPushX = this.f_38545_;
                this.altPushZ = this.f_38546_;
                this.altFuel += this.f_38548_;
                this.f_38548_ = 0;
            }
        } else if (!state.m_60713_(Blocks.f_50030_) || state.m_60713_(Blocks.f_50030_) && ((Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
            this.f_38548_ += this.altFuel;
            this.altFuel = 0;
            this.f_38545_ = this.altPushX;
            this.f_38546_ = this.altPushZ;
        }
        AtomicBoolean shouldSlowDown = new AtomicBoolean(MinecartHelper.shouldSlowDown(this, this.f_19853_));
        this.train.add(this);
        if (this.getLinkedChild() != null) {
            Linkable linkable = (Linkable)this.getLinkedChild();
            this.train.add(this.getLinkedChild());
            while ((linkable = (Linkable)linkable.getLinkedChild()) instanceof Linkable && !this.train.contains(linkable)) {
                this.train.add(linkable.getLinkedChild());
            }
            this.train.forEach(child -> shouldSlowDown.set(shouldSlowDown.get() || MinecartHelper.shouldSlowDown(child, this.f_19853_)));
        }
        if (shouldSlowDown.get() && this.m_20184_().m_82553_() > 0.4) {
            this.m_20256_(this.m_20184_().m_82541_().m_82490_(0.4));
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterminecarts$addOtherFuels(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0) {
            int fuelTime = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_);
            if (!player.m_7500_() && fuelTime > 0) {
                if (stack.m_41720_() instanceof BucketItem) {
                    player.m_150109_().m_6836_(player.m_150109_().f_35977_, BucketItem.m_40699_((ItemStack)stack, (Player)player));
                } else {
                    stack.m_41774_(1);
                }
            }
            if (stack.m_41720_() instanceof BucketItem) {
                SoundEvent soundEvent = SoundEvents.f_11780_;
                this.f_19853_.m_5594_(player, player.m_20183_(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.f_38548_ = (int)Math.min(72000.0, (double)this.f_38548_ + (double)fuelTime * 2.25);
        }
        if (this.f_38548_ > 0) {
            this.f_38545_ = this.m_20185_() - player.m_20185_();
            this.f_38546_ = this.m_20189_() - player.m_20189_();
        }
        f_38549_ = Ingredient.m_151265_();
        info.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_()));
    }

    @ModifyConstant(method={"interact"}, constant={@Constant(intValue=32000)})
    public int betterminecarts$maxBurnTime(int maxBurnTime) {
        return 72000;
    }

    @ModifyArg(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/RandomSource;nextInt(I)I"))
    public int betterminecarts$removeRandom(int i) {
        return 1;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void betterminecarts$readNbt(CompoundTag nbt, CallbackInfo info) {
        this.f_38548_ = nbt.m_128451_("RealFuel");
        this.altFuel = nbt.m_128451_("AltFuel");
        this.altPushX = nbt.m_128459_("AltPushX");
        this.altPushZ = nbt.m_128459_("AltPushZ");
        this.prevChunkPos = new ChunkPos(nbt.m_128454_("PrevChunkPos"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void betterminecarts$writeNbt(CompoundTag nbt, CallbackInfo info) {
        if (this.f_38548_ > Short.MAX_VALUE) {
            nbt.m_128376_("Fuel", (short)Short.MAX_VALUE);
        }
        nbt.m_128405_("RealFuel", this.f_38548_);
        nbt.m_128405_("AltFuel", this.altFuel);
        nbt.m_128347_("AltPushX", this.altPushX);
        nbt.m_128347_("AltPushZ", this.altPushZ);
        nbt.m_128356_("PrevChunkPos", this.prevChunkPos.m_45588_());
    }

    static {
        OLD_ACCEPTABLE_FUEL = f_38549_;
    }
}

