/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import hu.xannosz.betterminecarts.utils.Linkable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecartRenderer.class})
public abstract class MinecartEntityRendererMixin<T extends AbstractMinecart>
extends EntityRenderer<T> {
    @Unique
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("betterminecarts", "textures/entity/chain.png");
    @Unique
    private static final RenderType CHAIN_LAYER = RenderType.m_110458_((ResourceLocation)CHAIN_TEXTURE);

    protected MinecartEntityRendererMixin(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void betterminecarts$render(T child, float yaw, float tickDelta, PoseStack stack, MultiBufferSource provider, int light, CallbackInfo info) {
        Linkable linkable;
        AbstractMinecart parent;
        if (child instanceof Linkable && (parent = (linkable = (Linkable)child).getLinkedParentForRender()) != null) {
            double startX = parent.m_20185_();
            double startY = parent.m_20186_();
            double startZ = parent.m_20189_();
            double endX = child.m_20185_();
            double endY = child.m_20186_();
            double endZ = child.m_20189_();
            float distanceX = (float)(startX - endX);
            float distanceY = (float)(startY - endY);
            float distanceZ = (float)(startZ - endZ);
            float distance = child.m_20270_((Entity)parent);
            double hAngle = Math.toDegrees(Math.atan2(endZ - startZ, endX - startX));
            hAngle += Math.ceil(-hAngle / 360.0) * 360.0;
            double vAngle = Math.asin(distanceY / distance);
            this.renderChain(distanceX, distanceY, distanceZ, (float)hAngle, (float)vAngle, stack, provider, 0xF000F0);
        }
    }

    @Unique
    public void renderChain(float x, float y, float z, float hAngle, float vAngle, PoseStack stack, MultiBufferSource provider, int light) {
        float squaredLength = x * x + y * y + z * z;
        float length = Mth.m_14116_((float)squaredLength) - 1.0f;
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122225_.m_122240_(-hAngle - 90.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122270_(-vAngle));
        stack.m_85837_(0.0, 0.0, 0.5);
        stack.m_85836_();
        VertexConsumer vertexConsumer = provider.m_6299_(CHAIN_LAYER);
        float vertX1 = 0.0f;
        float vertY1 = 0.25f;
        float vertX2 = Mth.m_14031_((float)((float)Math.PI * 2)) * 0.125f;
        float vertY2 = Mth.m_14089_((float)((float)Math.PI * 2)) * 0.125f;
        float minU = 0.0f;
        float maxU = 0.1875f;
        float minV = 0.0f;
        float maxV = length / 10.0f;
        PoseStack.Pose entry = stack.m_85850_();
        Matrix4f matrix4f = entry.m_85861_();
        Matrix3f matrix3f = entry.m_85864_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        stack.m_85849_();
        stack.m_85837_(0.19, 0.19, 0.0);
        stack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        entry = stack.m_85850_();
        matrix4f = entry.m_85861_();
        matrix3f = entry.m_85864_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        stack.m_85849_();
    }
}

