/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.screen;

import hu.xannosz.betterminecarts.entity.SteamLocomotive;
import hu.xannosz.betterminecarts.screen.ModMenus;
import hu.xannosz.betterminecarts.utils.ButtonId;
import hu.xannosz.betterminecarts.utils.MinecartHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class SteamLocomotiveMenu
extends AbstractContainerMenu {
    private static final int PLAYER_INVENTORY_HEIGHT = 96;
    private final SteamLocomotive entity;
    private final Level level;
    private SlotItemHandler out;
    private final ContainerData data;
    private List<ItemStack> itemStacks;
    private static final int HOT_BAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 8;

    public SteamLocomotiveMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, null, (ContainerData)new SimpleContainerData(9));
    }

    public SteamLocomotiveMenu(int containerId, Inventory inv, Entity entity, ContainerData data) {
        super((MenuType)ModMenus.STEAM_LOCOMOTIVE_MENU.get(), containerId);
        SteamLocomotiveMenu.m_38869_((Container)inv, (int)8);
        this.entity = (SteamLocomotive)entity;
        this.level = inv.f_35978_.f_19853_;
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotBar(inv);
        this.m_38884_(data);
        if (this.entity != null) {
            this.createSlotsInternal(this.entity);
        }
    }

    public void createSlots() {
        if (this.out == null && this.getEntity() != null) {
            this.createSlotsInternal(this.getEntity());
        }
        if (this.itemStacks != null && this.out != null) {
            this.m_182410_(1, this.itemStacks, new ItemStack((ItemLike)Blocks.f_50016_, 1));
            this.itemStacks = null;
        }
    }

    public void m_182410_(int stateId, List<ItemStack> itemStacks, @NotNull ItemStack carried) {
        if (itemStacks.size() > this.f_38839_.size()) {
            this.itemStacks = itemStacks;
            return;
        }
        super.m_182410_(stateId, itemStacks, carried);
    }

    private void createSlotsInternal(SteamLocomotive steamLocomotive) {
        ItemStackHandler handler = steamLocomotive.getItemHandler();
        SlotItemHandler waterIn1 = new SlotItemHandler((IItemHandler)handler, 1, 71, 29);
        SlotItemHandler waterIn2 = new SlotItemHandler((IItemHandler)handler, 2, 81, 9);
        SlotItemHandler waterIn3 = new SlotItemHandler((IItemHandler)handler, 3, 61, 9);
        SlotItemHandler fuelIn1 = new SlotItemHandler((IItemHandler)handler, 4, 130, 29);
        SlotItemHandler fuelIn2 = new SlotItemHandler((IItemHandler)handler, 5, 130, 9);
        SlotItemHandler fuelIn3 = new SlotItemHandler((IItemHandler)handler, 6, 150, 9);
        SlotItemHandler fuelIn4 = new SlotItemHandler((IItemHandler)handler, 7, 110, 9);
        this.out = new SlotItemHandler((IItemHandler)handler, 0, 71, 58);
        this.m_38897_((Slot)waterIn1);
        this.m_38897_((Slot)waterIn2);
        this.m_38897_((Slot)waterIn3);
        this.m_38897_((Slot)fuelIn1);
        this.m_38897_((Slot)fuelIn2);
        this.m_38897_((Slot)fuelIn3);
        this.m_38897_((Slot)fuelIn4);
        this.m_38897_((Slot)this.out);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 44, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 44) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(@NotNull Player player) {
        ContainerLevelAccess containerLevelAccess = ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.entity.m_20097_());
        return (Boolean)containerLevelAccess.m_39299_((level, blockPos) -> player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 96 + i * 18));
            }
        }
    }

    private void addPlayerHotBar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 154));
        }
    }

    public int getSteamLocomotiveId() {
        return MinecartHelper.shortsToInt(new short[]{(short)this.data.m_6413_(0), (short)this.data.m_6413_(1)});
    }

    public SteamLocomotive getEntity() {
        return (SteamLocomotive)this.level.m_6815_(this.getSteamLocomotiveId());
    }

    public ButtonId getActiveButton() {
        return ButtonId.getButtonFromId(this.data.m_6413_(2));
    }

    public boolean isSignalActive() {
        return MinecartHelper.convertIntToBitArray(this.data.m_6413_(3), 2)[0];
    }

    public boolean isLampOn() {
        return MinecartHelper.convertIntToBitArray(this.data.m_6413_(3), 2)[1];
    }

    public int getSteam() {
        return this.data.m_6413_(4);
    }

    public int getWater() {
        return this.data.m_6413_(5);
    }

    public int getHeat() {
        return this.data.m_6413_(6);
    }

    public int getBurn() {
        return this.data.m_6413_(7);
    }

    public int getMaxBurn() {
        return this.data.m_6413_(8);
    }
}

