/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.utils;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import hu.xannosz.betterminecarts.blocks.CrossedRailBlock;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class MinecartHelper {
    public static final EntityDataAccessor<Integer> LINKED_PARENT = SynchedEntityData.m_135353_(AbstractMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> TOP_FILTER = SynchedEntityData.m_135353_(AbstractMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> BOTTOM_FILTER = SynchedEntityData.m_135353_(AbstractMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> IS_LAMP_ON = SynchedEntityData.m_135353_(AbstractMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_BURN = SynchedEntityData.m_135353_(AbstractMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = (Map)Util.m_137469_((Object)Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i vec3i = Direction.WEST.m_122436_();
        Vec3i vec3i1 = Direction.EAST.m_122436_();
        Vec3i vec3i2 = Direction.NORTH.m_122436_();
        Vec3i vec3i3 = Direction.SOUTH.m_122436_();
        Vec3i vec3i4 = vec3i.m_7495_();
        Vec3i vec3i5 = vec3i1.m_7495_();
        Vec3i vec3i6 = vec3i2.m_7495_();
        Vec3i vec3i7 = vec3i3.m_7495_();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)vec3i2, (Object)vec3i3));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)vec3i4, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)vec3i5));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)vec3i2, (Object)vec3i7));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)vec3i6, (Object)vec3i3));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)vec3i3, (Object)vec3i1));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)vec3i3, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)vec3i2, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)vec3i2, (Object)vec3i1));
    });

    public static boolean shouldSlowDown(AbstractMinecart minecart, Level world) {
        boolean slowEm = false;
        if (minecart != null) {
            int velocity = Mth.m_14165_((double)minecart.m_20184_().m_165924_());
            Direction direction = Direction.m_122366_((double)minecart.m_20184_().m_7096_(), (double)0.0, (double)minecart.m_20184_().m_7094_());
            BlockPos minecartPos = minecart.m_20183_();
            Vec3i pain = new Vec3i(minecartPos.m_123341_(), 0, minecartPos.m_123343_());
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            ArrayList<Object> poses = new ArrayList<Object>();
            poses.add(minecartPos);
            for (int i = 0; i < poses.size(); ++i) {
                Block block;
                BlockState state;
                pos.m_122190_((Vec3i)poses.get(i));
                int distance = pain.m_123333_(new Vec3i(pos.m_123341_(), 0, pos.m_123343_()));
                if (distance > velocity) break;
                if (world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    pos.m_122184_(0, -1, 0);
                }
                if (!(state = world.m_8055_((BlockPos)pos)).m_204336_(BlockTags.f_13034_) || !((block = state.m_60734_()) instanceof BaseRailBlock)) continue;
                BaseRailBlock rails = (BaseRailBlock)block;
                RailShape shape = (RailShape)state.m_61143_(rails.m_7978_());
                if (rails instanceof CrossedRailBlock && minecart.m_20184_().m_165924_() > 0.0) {
                    if (shape == RailShape.NORTH_SOUTH && (direction == Direction.EAST || direction == Direction.WEST)) {
                        world.m_7731_((BlockPos)pos, (BlockState)state.m_61124_(rails.m_7978_(), (Comparable)RailShape.EAST_WEST), 3);
                        break;
                    }
                    if (shape == RailShape.EAST_WEST && (direction == Direction.NORTH || direction == Direction.SOUTH)) {
                        world.m_7731_((BlockPos)pos, (BlockState)state.m_61124_(rails.m_7978_(), (Comparable)RailShape.NORTH_SOUTH), 3);
                        break;
                    }
                }
                if (shape != RailShape.NORTH_SOUTH && shape != RailShape.EAST_WEST) {
                    slowEm = true;
                    break;
                }
                Pair<Vec3i, Vec3i> pair = EXITS.get(shape);
                Vec3i first = ((Vec3i)pair.getFirst()).m_121955_((Vec3i)pos);
                Vec3i second = ((Vec3i)pair.getSecond()).m_121955_((Vec3i)pos);
                if (distance < 2) {
                    if (!poses.contains(first)) {
                        poses.add(first);
                    }
                    if (poses.contains(second)) continue;
                    poses.add(second);
                    continue;
                }
                if (shape == RailShape.NORTH_SOUTH && direction == Direction.NORTH || shape == RailShape.EAST_WEST && direction == Direction.WEST) {
                    if (poses.contains(first)) continue;
                    poses.add(first);
                    continue;
                }
                if (poses.contains(second)) continue;
                poses.add(second);
            }
        }
        return slowEm;
    }

    public static int convertBitArrayToInt(boolean[] booleans) {
        int value = 0;
        for (int i = 0; i < booleans.length; ++i) {
            if (!booleans[i]) continue;
            value |= 1 << i;
        }
        return value;
    }

    public static boolean[] convertIntToBitArray(int value, int size) {
        boolean[] booleans = new boolean[size];
        for (int i = 0; i < size; ++i) {
            booleans[i] = (value & 1 << i) != 0;
        }
        return booleans;
    }

    public static short convertBitArrayToShort(boolean[] booleans) {
        short value = 0;
        for (int i = 0; i < booleans.length; ++i) {
            if (!booleans[i]) continue;
            value = (short)(value | 1 << i);
        }
        return value;
    }

    public static boolean[] convertShortToBitArray(short value, int size) {
        boolean[] booleans = new boolean[size];
        for (int i = 0; i < size; ++i) {
            booleans[i] = (value & 1 << i) != 0;
        }
        return booleans;
    }

    public static short[] intToShorts(int in) {
        boolean[] arr = MinecartHelper.convertIntToBitArray(in, 32);
        boolean[] arr1 = new boolean[16];
        boolean[] arr2 = new boolean[16];
        for (int i = 0; i < 32; i += 2) {
            arr1[i / 2] = arr[i];
            arr2[i / 2] = arr[i + 1];
        }
        return new short[]{MinecartHelper.convertBitArrayToShort(arr1), MinecartHelper.convertBitArrayToShort(arr2)};
    }

    public static int shortsToInt(short[] in) {
        boolean[] arr = new boolean[32];
        boolean[] arr1 = MinecartHelper.convertShortToBitArray(in[0], 16);
        boolean[] arr2 = MinecartHelper.convertShortToBitArray(in[1], 16);
        for (int i = 0; i < 32; i += 2) {
            arr[i] = arr1[i / 2];
            arr[i + 1] = arr2[i / 2];
        }
        return MinecartHelper.convertBitArrayToInt(arr);
    }
}

