/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts;

import hu.xannosz.betterminecarts.blockentity.ModBlockEntities;
import hu.xannosz.betterminecarts.blocks.ModBlocks;
import hu.xannosz.betterminecarts.client.models.ElectricLocomotiveModel;
import hu.xannosz.betterminecarts.client.models.SteamLocomotiveModel;
import hu.xannosz.betterminecarts.client.renderer.LocomotiveRenderer;
import hu.xannosz.betterminecarts.config.BetterMinecartsConfig;
import hu.xannosz.betterminecarts.entity.ModEntities;
import hu.xannosz.betterminecarts.item.ModItems;
import hu.xannosz.betterminecarts.network.ModMessages;
import hu.xannosz.betterminecarts.screen.ElectricLocomotiveScreen;
import hu.xannosz.betterminecarts.screen.ModMenus;
import hu.xannosz.betterminecarts.screen.SteamLocomotiveScreen;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="betterminecarts")
public class BetterMinecarts {
    public static final String MOD_ID = "betterminecarts";
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"betterminecarts");
    public static RegistryObject<SoundEvent> STEAM_WHISTLE = SOUND_EVENTS.register("steam_whistle", () -> SoundEvent.m_262856_((ResourceLocation)new ResourceLocation(MOD_ID, "steam_whistle"), (float)16.0f));

    public BetterMinecarts() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ModMessages::setupMessages);
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModMenus.MENUS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BetterMinecartsConfig.SPEC, "betterminecarts.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    public static DamageSource minecart(Entity entity) {
        return new EntityDamageSource("betterminecarts.minecart", entity);
    }

    private void addCreative(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_257028_ || event.getTab() == CreativeModeTabs.f_256869_) {
            event.accept(ModItems.CROWBAR);
            event.accept(ModItems.CRAFTING_MINECART_ITEM);
            event.accept((Supplier)ModItems.LOCOMOTIVE_ITEMS.get(BetterMinecarts.generateNameFromData(MinecartColor.YELLOW, MinecartColor.BROWN, false)));
            event.accept((Supplier)ModItems.LOCOMOTIVE_ITEMS.get(BetterMinecarts.generateNameFromData(MinecartColor.LIGHT_GRAY, MinecartColor.GRAY, true)));
            ModItems.BLOCK_ITEMS.forEach(arg_0 -> ((CreativeModeTabEvent.BuildContents)event).accept(arg_0));
        }
    }

    public static String generateNameFromData(MinecartColor topColor, MinecartColor bottomColor, boolean isSteam) {
        if (isSteam) {
            return "steam_locomotive_item_" + topColor.getLabel() + "_" + bottomColor.getLabel();
        }
        return "electric_locomotive_item_" + topColor.getLabel() + "_" + bottomColor.getLabel();
    }

    @Mod.EventBusSubscriber(modid="betterminecarts", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ModEntities.ELECTRIC_LOCOMOTIVE.get(), context -> new LocomotiveRenderer(context, new ElectricLocomotiveModel(context.m_174023_(ElectricLocomotiveModel.LAYER_LOCATION))));
            event.registerEntityRenderer((EntityType)ModEntities.STEAM_LOCOMOTIVE.get(), context -> new LocomotiveRenderer(context, new SteamLocomotiveModel(context.m_174023_(SteamLocomotiveModel.LAYER_LOCATION))));
            event.registerEntityRenderer((EntityType)ModEntities.CRAFTING_MINECART.get(), context -> new MinecartRenderer(context, ModelLayers.f_171149_));
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.ELECTRIC_LOCOMOTIVE_MENU.get()), ElectricLocomotiveScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.STEAM_LOCOMOTIVE_MENU.get()), SteamLocomotiveScreen::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(ElectricLocomotiveModel.LAYER_LOCATION, ElectricLocomotiveModel::createBodyLayer);
            event.registerLayerDefinition(SteamLocomotiveModel.LAYER_LOCATION, SteamLocomotiveModel::createBodyLayer);
        }
    }
}

