/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.blocks;

import hu.xannosz.betterminecarts.entity.AbstractLocomotive;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class SignalRailBlock
extends DetectorRailBlock {
    public SignalRailBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50031_));
    }

    public void m_7892_(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Entity entity) {
        if (!level.f_46443_ && !((Boolean)blockState.m_61143_((Property)f_52428_)).booleanValue()) {
            this.checkPressed(level, blockPos, blockState);
        }
    }

    public void m_213897_(BlockState blockState, @NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)f_52428_)).booleanValue()) {
            this.checkPressed((Level)serverLevel, blockPos, blockState);
        }
    }

    public void m_6807_(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState bottomBlock, boolean update) {
        if (!bottomBlock.m_60713_(blockState.m_60734_())) {
            BlockState blockstate = this.m_49389_(blockState, level, blockPos, update);
            this.checkPressed(level, blockPos, blockstate);
        }
    }

    private void checkPressed(Level level, BlockPos blockPos, BlockState inputBlockState) {
        if (this.m_7898_(inputBlockState, (LevelReader)level, blockPos)) {
            BlockState blockState;
            boolean isPowered = (Boolean)inputBlockState.m_61143_((Property)f_52428_);
            boolean locomotiveOnRail = false;
            boolean minecartOnRail = false;
            List<AbstractMinecart> list = this.getInteractingMinecartOfType(level, blockPos, AbstractMinecart.class, entity -> true);
            for (AbstractMinecart locomotive : list) {
                AbstractLocomotive abstractLocomotive;
                if (locomotive instanceof AbstractLocomotive && (abstractLocomotive = (AbstractLocomotive)locomotive).popSignal()) {
                    locomotiveOnRail = true;
                }
                minecartOnRail = true;
            }
            if (locomotiveOnRail && !isPowered) {
                blockState = (BlockState)inputBlockState.m_61124_((Property)f_52428_, (Comparable)Boolean.TRUE);
                level.m_7731_(blockPos, blockState, 3);
                this.m_52472_(level, blockPos, blockState, true);
                level.m_46672_(blockPos, (Block)this);
                level.m_46672_(blockPos.m_7495_(), (Block)this);
                level.m_6550_(blockPos, inputBlockState, blockState);
            }
            if (!locomotiveOnRail && isPowered && !minecartOnRail) {
                blockState = (BlockState)inputBlockState.m_61124_((Property)f_52428_, (Comparable)Boolean.FALSE);
                level.m_7731_(blockPos, blockState, 3);
                this.m_52472_(level, blockPos, blockState, false);
                level.m_46672_(blockPos, (Block)this);
                level.m_46672_(blockPos.m_7495_(), (Block)this);
                level.m_6550_(blockPos, inputBlockState, blockState);
            }
            if (locomotiveOnRail || minecartOnRail) {
                level.m_186460_(blockPos, (Block)this, 28);
            }
            level.m_46717_(blockPos, (Block)this);
        }
    }

    private <T extends AbstractMinecart> List<T> getInteractingMinecartOfType(Level level, BlockPos blockPos, Class<T> clazz, Predicate<Entity> predicate) {
        return level.m_6443_(clazz, this.getSearchBB(blockPos), predicate);
    }

    private AABB getSearchBB(BlockPos blockPos) {
        return new AABB((double)blockPos.m_123341_() - 0.2, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() - 0.2, (double)(blockPos.m_123341_() + 1) + 0.2, (double)(blockPos.m_123342_() + 1) - 0.2, (double)(blockPos.m_123343_() + 1) + 0.2);
    }
}

