/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import hu.xannosz.betterminecarts.entity.AbstractLocomotive;
import hu.xannosz.betterminecarts.entity.ElectricLocomotive;
import hu.xannosz.betterminecarts.entity.SteamLocomotive;
import hu.xannosz.betterminecarts.utils.Linkable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Unique;

public class LocomotiveRenderer
extends EntityRenderer<AbstractLocomotive> {
    private static final ResourceLocation ELECTRIC_LOCOMOTIVE = new ResourceLocation("betterminecarts", "textures/entity/electric_locomotive.png");
    private static final ResourceLocation STEAM_LOCOMOTIVE = new ResourceLocation("betterminecarts", "textures/entity/steam_locomotive.png");
    private static final ResourceLocation ELECTRIC_LOCOMOTIVE_ON = new ResourceLocation("betterminecarts", "textures/entity/electric_locomotive_on.png");
    private static final ResourceLocation STEAM_LOCOMOTIVE_ON = new ResourceLocation("betterminecarts", "textures/entity/steam_locomotive_on.png");
    private static final ResourceLocation STEAM_LOCOMOTIVE_BURN = new ResourceLocation("betterminecarts", "textures/entity/steam_locomotive_burn.png");
    private static final ResourceLocation STEAM_LOCOMOTIVE_ON_BURN = new ResourceLocation("betterminecarts", "textures/entity/steam_locomotive_on_burn.png");
    protected final EntityModel<AbstractLocomotive> model;
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("betterminecarts", "textures/entity/chain.png");
    private static final RenderType CHAIN_LAYER = RenderType.m_110458_((ResourceLocation)CHAIN_TEXTURE);

    public LocomotiveRenderer(EntityRendererProvider.Context context, EntityModel<AbstractLocomotive> model) {
        super(context);
        this.f_114477_ = 0.7f;
        this.model = model;
    }

    public void render(@NotNull AbstractLocomotive locomotive, float yRotation, float p_115420_, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        Linkable linkable;
        AbstractMinecart parent;
        super.m_7392_((Entity)locomotive, yRotation, p_115420_, poseStack, multiBufferSource, packedLight);
        poseStack.m_85836_();
        long i = (long)locomotive.m_19879_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.m_85837_((double)f, (double)f1, (double)f2);
        double d0 = Mth.m_14139_((double)p_115420_, (double)locomotive.f_19790_, (double)locomotive.m_20185_());
        double d1 = Mth.m_14139_((double)p_115420_, (double)locomotive.f_19791_, (double)locomotive.m_20186_());
        double d2 = Mth.m_14139_((double)p_115420_, (double)locomotive.f_19792_, (double)locomotive.m_20189_());
        Vec3 vec3 = locomotive.m_38179_(d0, d1, d2);
        float f3 = Mth.m_14179_((float)p_115420_, (float)locomotive.f_19860_, (float)locomotive.m_146909_());
        if (vec3 != null) {
            Vec3 vec31 = locomotive.m_38096_(d0, d1, d2, 0.3f);
            Vec3 vec32 = locomotive.m_38096_(d0, d1, d2, -0.3f);
            if (vec31 == null) {
                vec31 = vec3;
            }
            if (vec32 == null) {
                vec32 = vec3;
            }
            poseStack.m_85837_(vec3.f_82479_ - d0, (vec31.f_82480_ + vec32.f_82480_) / 2.0 - d1, vec3.f_82481_ - d2);
            Vec3 vec33 = vec32.m_82520_(-vec31.f_82479_, -vec31.f_82480_, -vec31.f_82481_);
            if (vec33.m_82553_() != 0.0) {
                vec33 = vec33.m_82541_();
                yRotation = (float)(Math.atan2(vec33.f_82481_, vec33.f_82479_) * 180.0 / Math.PI);
                yRotation = locomotive.normalizeRotation(yRotation);
                f3 = (float)(Math.atan(vec33.f_82480_) * 73.0);
                f3 = locomotive.normalizePitch(f3);
            }
        }
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yRotation));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-f3));
        float f5 = (float)locomotive.m_38176_() - p_115420_;
        float f6 = locomotive.m_38169_() - p_115420_;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f5) * f5 * f6 / 10.0f * (float)locomotive.m_38177_()));
        }
        int j = locomotive.m_38183_();
        BlockState blockstate = locomotive.m_38178_();
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            poseStack.m_85837_(-0.5, (double)((float)(j - 8) / 16.0f), 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_85849_();
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_6973_((Entity)locomotive, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(this.model.m_103119_(this.getTextureLocation(locomotive)));
        this.model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        if (locomotive instanceof Linkable && (parent = (linkable = (Linkable)((Object)locomotive)).getLinkedParentForRender()) != null) {
            double startX = parent.m_20185_();
            double startY = parent.m_20186_();
            double startZ = parent.m_20189_();
            double endX = locomotive.m_20185_();
            double endY = locomotive.m_20186_();
            double endZ = locomotive.m_20189_();
            float distanceX = (float)(startX - endX);
            float distanceY = (float)(startY - endY);
            float distanceZ = (float)(startZ - endZ);
            float distance = locomotive.m_20270_((Entity)parent);
            double hAngle = Math.toDegrees(Math.atan2(endZ - startZ, endX - startX));
            hAngle += Math.ceil(-hAngle / 360.0) * 360.0;
            double vAngle = Math.asin(distanceY / distance);
            this.renderChain(distanceX, distanceY, distanceZ, (float)hAngle, (float)vAngle, poseStack, multiBufferSource, 0xF000F0);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull AbstractLocomotive locomotive) {
        if (locomotive instanceof ElectricLocomotive) {
            if (locomotive.isLampOn()) {
                return ELECTRIC_LOCOMOTIVE_ON;
            }
            return ELECTRIC_LOCOMOTIVE;
        }
        if (locomotive instanceof SteamLocomotive) {
            SteamLocomotive steamLocomotive = (SteamLocomotive)locomotive;
            if (steamLocomotive.isBurn()) {
                if (locomotive.isLampOn()) {
                    return STEAM_LOCOMOTIVE_ON_BURN;
                }
                return STEAM_LOCOMOTIVE_BURN;
            }
            if (locomotive.isLampOn()) {
                return STEAM_LOCOMOTIVE_ON;
            }
            return STEAM_LOCOMOTIVE;
        }
        return ELECTRIC_LOCOMOTIVE;
    }

    @Unique
    public void renderChain(float x, float y, float z, float hAngle, float vAngle, PoseStack stack, MultiBufferSource provider, int light) {
        float squaredLength = x * x + y * y + z * z;
        float length = Mth.m_14116_((float)squaredLength) - 1.0f;
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(-hAngle - 90.0f));
        stack.m_252781_(Axis.f_252529_.m_252961_(-vAngle));
        stack.m_85837_(0.0, 0.0, 0.5);
        stack.m_85836_();
        VertexConsumer vertexConsumer = provider.m_6299_(CHAIN_LAYER);
        float vertX1 = 0.0f;
        float vertY1 = 0.25f;
        float vertX2 = Mth.m_14031_((float)((float)Math.PI * 2)) * 0.125f;
        float vertY2 = Mth.m_14089_((float)((float)Math.PI * 2)) * 0.125f;
        float minU = 0.0f;
        float maxU = 0.1875f;
        float minV = 0.0f;
        float maxV = length / 10.0f;
        PoseStack.Pose entry = stack.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        stack.m_85849_();
        stack.m_85837_(0.19, 0.19, 0.0);
        stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        entry = stack.m_85850_();
        matrix4f = entry.m_252922_();
        matrix3f = entry.m_252943_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        stack.m_85849_();
    }
}

