/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.datagen;

import hu.xannosz.betterminecarts.BetterMinecarts;
import hu.xannosz.betterminecarts.item.AbstractLocomotiveItem;
import hu.xannosz.betterminecarts.item.ModItems;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(DataGenerator dataGenerator) {
        super(dataGenerator.getPackOutput());
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer) {
        this.createRecipes(finishedRecipeConsumer, MinecartColor.LIGHT_GRAY, MinecartColor.GRAY, true);
        this.createRecipes(finishedRecipeConsumer, MinecartColor.YELLOW, MinecartColor.BROWN, false);
    }

    private void createRecipes(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer, MinecartColor top, MinecartColor bottom, boolean isSteam) {
        for (MinecartColor additional1 : MinecartColor.values()) {
            this.topColorize(finishedRecipeConsumer, bottom, top, isSteam, additional1);
            this.bottomColorize(finishedRecipeConsumer, bottom, top, isSteam, additional1);
            for (MinecartColor additional2 : MinecartColor.values()) {
                this.bothColorize(finishedRecipeConsumer, bottom, top, isSteam, additional1, additional2);
                this.deColorize(finishedRecipeConsumer, bottom, top, isSteam, additional1, additional2);
            }
        }
    }

    private void bothColorize(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer, MinecartColor sourceBottom, MinecartColor sourceTop, boolean isSteam, MinecartColor targetBottom, MinecartColor targetTop) {
        if (sourceTop.equals((Object)targetTop) || sourceBottom.equals((Object)targetBottom)) {
            return;
        }
        String sourceId = BetterMinecarts.generateNameFromData(sourceTop, sourceBottom, isSteam);
        String targetId = BetterMinecarts.generateNameFromData(targetTop, targetBottom, isSteam);
        AbstractLocomotiveItem source = (AbstractLocomotiveItem)((Object)ModItems.LOCOMOTIVE_ITEMS.get(sourceId).get());
        AbstractLocomotiveItem target = (AbstractLocomotiveItem)((Object)ModItems.LOCOMOTIVE_ITEMS.get(targetId).get());
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)target).m_126127_(Character.valueOf('T'), (ItemLike)targetTop.getDye()).m_126127_(Character.valueOf('L'), (ItemLike)source).m_126127_(Character.valueOf('B'), (ItemLike)targetBottom.getDye()).m_126130_("T").m_126130_("L").m_126130_("B").m_126132_("never", (CriterionTriggerInstance)ModRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.getItemPredicate()})).m_126140_(finishedRecipeConsumer, new ResourceLocation("betterminecarts", sourceId + "_" + targetId + "_both"));
    }

    private void topColorize(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer, MinecartColor sourceBottom, MinecartColor sourceTop, boolean isSteam, MinecartColor targetTop) {
        if (sourceTop.equals((Object)targetTop)) {
            return;
        }
        String sourceId = BetterMinecarts.generateNameFromData(sourceTop, sourceBottom, isSteam);
        String targetId = BetterMinecarts.generateNameFromData(targetTop, sourceBottom, isSteam);
        AbstractLocomotiveItem source = (AbstractLocomotiveItem)((Object)ModItems.LOCOMOTIVE_ITEMS.get(sourceId).get());
        AbstractLocomotiveItem target = (AbstractLocomotiveItem)((Object)ModItems.LOCOMOTIVE_ITEMS.get(targetId).get());
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)target).m_126127_(Character.valueOf('T'), (ItemLike)targetTop.getDye()).m_126127_(Character.valueOf('L'), (ItemLike)source).m_126130_("T").m_126130_("L").m_126132_("never", (CriterionTriggerInstance)ModRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.getItemPredicate()})).m_126140_(finishedRecipeConsumer, new ResourceLocation("betterminecarts", sourceId + "_" + targetId + "_top"));
    }

    private void bottomColorize(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer, MinecartColor sourceBottom, MinecartColor sourceTop, boolean isSteam, MinecartColor targetBottom) {
        if (sourceBottom.equals((Object)targetBottom)) {
            return;
        }
        String sourceId = BetterMinecarts.generateNameFromData(sourceTop, sourceBottom, isSteam);
        String targetId = BetterMinecarts.generateNameFromData(sourceTop, targetBottom, isSteam);
        AbstractLocomotiveItem source = (AbstractLocomotiveItem)((Object)ModItems.LOCOMOTIVE_ITEMS.get(sourceId).get());
        AbstractLocomotiveItem target = (AbstractLocomotiveItem)((Object)ModItems.LOCOMOTIVE_ITEMS.get(targetId).get());
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)target).m_126127_(Character.valueOf('L'), (ItemLike)source).m_126127_(Character.valueOf('B'), (ItemLike)targetBottom.getDye()).m_126130_("L").m_126130_("B").m_126132_("never", (CriterionTriggerInstance)ModRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.getItemPredicate()})).m_126140_(finishedRecipeConsumer, new ResourceLocation("betterminecarts", sourceId + "_" + targetId + "_bottom"));
    }

    private void deColorize(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer, MinecartColor sourceBottom, MinecartColor sourceTop, boolean isSteam, MinecartColor targetBottom, MinecartColor targetTop) {
        if (sourceTop.equals((Object)targetTop) && sourceBottom.equals((Object)targetBottom)) {
            return;
        }
        String sourceId = BetterMinecarts.generateNameFromData(sourceTop, sourceBottom, isSteam);
        String targetId = BetterMinecarts.generateNameFromData(targetTop, targetBottom, isSteam);
        AbstractLocomotiveItem source = (AbstractLocomotiveItem)((Object)ModItems.LOCOMOTIVE_ITEMS.get(sourceId).get());
        AbstractLocomotiveItem target = (AbstractLocomotiveItem)((Object)ModItems.LOCOMOTIVE_ITEMS.get(targetId).get());
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)source).m_126209_((ItemLike)target).m_126132_("never", (CriterionTriggerInstance)ModRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.getItemPredicate()})).m_126140_(finishedRecipeConsumer, new ResourceLocation("betterminecarts", sourceId + "_" + targetId + "_revert"));
    }

    private ItemPredicate getItemPredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("never", 0);
        return ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42127_}).m_45075_(tag).m_45077_();
    }
}

