/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.entity;

import hu.xannosz.betterminecarts.BetterMinecarts;
import hu.xannosz.betterminecarts.entity.AbstractLocomotive;
import hu.xannosz.betterminecarts.entity.ModEntities;
import hu.xannosz.betterminecarts.item.ModItems;
import hu.xannosz.betterminecarts.screen.ElectricLocomotiveMenu;
import hu.xannosz.betterminecarts.utils.ButtonId;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ElectricLocomotive
extends AbstractLocomotive {
    public static final int POWER_KEY = 4;
    public static final int MAX_POWER = 20;
    public static final int DATA_SIZE = 5;
    private int power = 0;
    private BlockPos lastBlockPos;

    public ElectricLocomotive(EntityType<?> entityType, Level level) {
        super(entityType, level, MinecartColor.YELLOW, MinecartColor.BROWN, 5);
    }

    public ElectricLocomotive(Level level, double x, double y, double z, MinecartColor top, MinecartColor bottom) {
        super((EntityType)ModEntities.ELECTRIC_LOCOMOTIVE.get(), x, y, z, level, top, bottom, 5);
    }

    @NotNull
    protected Item m_213728_() {
        return (Item)ModItems.LOCOMOTIVE_ITEMS.get(BetterMinecarts.generateNameFromData(this.getTopFilter(), this.getBottomFilter(), false)).get();
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory inv, @NotNull Player player) {
        this.updateData();
        return new ElectricLocomotiveMenu(containerId, inv, (Entity)this, this.data);
    }

    @Override
    protected boolean canPush() {
        return this.power > 0;
    }

    @Override
    protected List<Component> getEngineData() {
        return List.of(Component.m_237115_((String)"text.betterminecarts.data.energy").m_7220_((Component)Component.m_237113_((String)(this.power + "/20")).m_130940_(ChatFormatting.DARK_GREEN)));
    }

    @Override
    public void updateData() {
        this.data.m_8050_(4, this.power);
        super.updateData();
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Power", this.power);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.power = compoundTag.m_128451_("Power");
        this.updateData();
    }

    @Override
    protected void m_6401_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        super.m_6401_(blockPos, blockState);
        if (!blockPos.equals((Object)this.lastBlockPos)) {
            this.lastBlockPos = blockPos;
            --this.power;
        }
        if (this.power < 0) {
            this.power = 0;
            this.xPush = 0.0;
            this.zPush = 0.0;
            this.activeButton = ButtonId.STOP;
        }
        if (blockState.m_60734_().equals(Blocks.f_50030_) && ((Boolean)blockState.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
            this.power = 20;
        }
    }
}

