/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.item;

import hu.xannosz.betterminecarts.entity.AbstractLocomotive;
import hu.xannosz.betterminecarts.entity.ElectricLocomotive;
import hu.xannosz.betterminecarts.entity.SteamLocomotive;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractLocomotiveItem
extends Item {
    private final MinecartColor topColor;
    private final MinecartColor bottomColor;
    private final boolean isSteam;

    public AbstractLocomotiveItem(MinecartColor topColor, MinecartColor bottomColor, boolean isSteam) {
        super(new Item.Properties().m_41487_(1));
        this.topColor = topColor;
        this.bottomColor = bottomColor;
        this.isSteam = isSteam;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        BlockPos blockpos;
        Level level = useOnContext.m_43725_();
        BlockState blockstate = level.m_8055_(blockpos = useOnContext.m_8083_());
        if (!blockstate.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = useOnContext.m_43722_();
        if (!level.f_46443_) {
            AbstractLocomotive abstractLocomotive;
            RailShape railshape = blockstate.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)level, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.m_61745_()) {
                d0 = 0.5;
            }
            AbstractLocomotive abstractLocomotive2 = abstractLocomotive = this.isSteam ? this.createSteamLocomotive(this.bottomColor, this.topColor, level, blockpos, d0) : this.createElectricLocomotive(this.bottomColor, this.topColor, level, blockpos, d0);
            if (itemstack.m_41788_()) {
                abstractLocomotive.m_6593_(itemstack.m_41786_());
                abstractLocomotive.m_20340_(true);
            }
            abstractLocomotive.setStartDirection(useOnContext.m_8125_());
            level.m_7967_((Entity)abstractLocomotive);
            level.m_220407_(GameEvent.f_157810_, blockpos, GameEvent.Context.m_223719_((Entity)useOnContext.m_43723_(), (BlockState)level.m_8055_(blockpos.m_7495_())));
        }
        itemstack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        if (this.topColor != null && this.bottomColor != null) {
            components.add((Component)Component.m_237115_((String)("text.betterminecarts.locomotive.color." + this.topColor.getLabel())).m_130940_(this.topColor.getLabelColor()));
            components.add((Component)Component.m_237115_((String)("text.betterminecarts.locomotive.color." + this.bottomColor.getLabel())).m_130940_(this.bottomColor.getLabelColor()));
        }
        super.m_7373_(itemStack, level, components, tooltipFlag);
    }

    private AbstractLocomotive createElectricLocomotive(MinecartColor bottom, MinecartColor top, Level level, BlockPos blockpos, double d0) {
        return new ElectricLocomotive(level, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5, top, bottom);
    }

    private AbstractLocomotive createSteamLocomotive(MinecartColor bottom, MinecartColor top, Level level, BlockPos blockpos, double d0) {
        return new SteamLocomotive(level, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5, top, bottom);
    }

    @NotNull
    public String m_5524_() {
        return "item.betterminecarts." + this.getLocomotiveName();
    }

    public String getLocomotiveName() {
        return (this.isSteam ? "steam" : "electric") + "_locomotive";
    }
}

