/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.item;

import hu.xannosz.betterminecarts.BetterMinecarts;
import hu.xannosz.betterminecarts.item.AbstractLocomotiveItem;
import hu.xannosz.betterminecarts.item.CraftingMinecartItem;
import hu.xannosz.betterminecarts.item.Crowbar;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"betterminecarts");
    public static final Map<String, RegistryObject<AbstractLocomotiveItem>> LOCOMOTIVE_ITEMS = ModItems.createLocomotiveItems();
    public static final Set<RegistryObject<BlockItem>> BLOCK_ITEMS = new HashSet<RegistryObject<BlockItem>>();
    public static final RegistryObject<Item> CROWBAR = ITEMS.register("crowbar", () -> new Crowbar(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> CRAFTING_MINECART_ITEM = ITEMS.register("crafting_minecart_item", CraftingMinecartItem::new);

    private static Map<String, RegistryObject<AbstractLocomotiveItem>> createLocomotiveItems() {
        HashMap<String, RegistryObject<AbstractLocomotiveItem>> result = new HashMap<String, RegistryObject<AbstractLocomotiveItem>>();
        for (MinecartColor topColor : MinecartColor.values()) {
            for (MinecartColor bottomColor : MinecartColor.values()) {
                result.put(BetterMinecarts.generateNameFromData(topColor, bottomColor, true), (RegistryObject<AbstractLocomotiveItem>)ITEMS.register(BetterMinecarts.generateNameFromData(topColor, bottomColor, true), () -> new AbstractLocomotiveItem(topColor, bottomColor, true)));
                result.put(BetterMinecarts.generateNameFromData(topColor, bottomColor, false), (RegistryObject<AbstractLocomotiveItem>)ITEMS.register(BetterMinecarts.generateNameFromData(topColor, bottomColor, false), () -> new AbstractLocomotiveItem(topColor, bottomColor, false)));
            }
        }
        return result;
    }
}

