/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.mixin;

import hu.xannosz.betterminecarts.BetterMinecarts;
import hu.xannosz.betterminecarts.config.BetterMinecartsConfig;
import hu.xannosz.betterminecarts.item.ModItems;
import hu.xannosz.betterminecarts.utils.Linkable;
import hu.xannosz.betterminecarts.utils.MinecartHelper;
import hu.xannosz.betterminecarts.utils.TrainUtil;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractMinecart.class})
public abstract class AbstractMinecartEntityMixin
extends Entity
implements Linkable {
    @Unique
    private AbstractMinecart linkedParent;
    @Unique
    private AbstractMinecart linkedChild;
    @Unique
    private UUID parentUuid;
    @Unique
    private UUID childUuid;
    @Unique
    private boolean isUpdated = false;

    @Shadow
    public abstract Direction m_6374_();

    @Shadow
    public abstract float getMaxSpeedAirVertical();

    public AbstractMinecartEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"getMaxSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    public void betterminecarts$increaseSpeed(CallbackInfoReturnable<Double> info) {
        if (this.getLinkedParent() != null) {
            try {
                Class<?> clazz = this.getLinkedParent().getClass();
                Method retrieveItems = clazz.getDeclaredMethod("getMaxSpeed", new Class[0]);
                retrieveItems.setAccessible(true);
                info.setReturnValue((Object)((Double)retrieveItems.invoke((Object)this.getLinkedParent(), new Object[0])));
            }
            catch (Exception ex) {
                info.setReturnValue((Object)0.0);
            }
        } else {
            info.setReturnValue((Object)0.5);
        }
    }

    @Inject(method={"comeOffTrack"}, at={@At(value="HEAD")}, cancellable=true)
    public void comeOffTrackHack(CallbackInfo info) {
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(0.96));
        }
        if (this.getMaxSpeedAirVertical() > 0.0f && this.m_20184_().f_82480_ > (double)this.getMaxSpeedAirVertical()) {
            if (Math.abs(this.m_20184_().f_82479_) < (double)0.3f && Math.abs(this.m_20184_().f_82481_) < (double)0.3f) {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, (double)0.15f, this.m_20184_().f_82481_));
            } else {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, (double)this.getMaxSpeedAirVertical(), this.m_20184_().f_82481_));
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        info.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void betterminecarts$tick(CallbackInfo info) {
        if (!this.f_19853_.m_5776_()) {
            if (this.getLinkedParent() != null) {
                double distance = this.getLinkedParent().m_20270_((Entity)this) - 1.0f;
                if (distance <= 4.0) {
                    Vec3 direction = this.getLinkedParent().m_20182_().m_82546_(this.m_20182_()).m_82541_();
                    Vec3 parentVelocity = this.getLinkedParent().m_20184_();
                    if (distance > 1.0) {
                        if (parentVelocity.m_82553_() == 0.0) {
                            this.m_20256_(direction.m_82490_(0.05));
                        } else {
                            this.m_20256_(direction.m_82490_(parentVelocity.m_82553_()));
                            this.m_20256_(this.m_20184_().m_82490_(distance));
                        }
                    } else if (distance < 0.8) {
                        if (parentVelocity.m_82553_() == 0.0) {
                            this.m_20256_(direction.m_82490_(-0.05));
                        } else {
                            this.m_20256_(direction.m_82490_(parentVelocity.m_82553_()));
                            this.m_20256_(this.m_20184_().m_82490_(-1.5));
                        }
                    } else {
                        this.m_20256_(this.m_20184_().m_82490_(0.6));
                    }
                } else {
                    ((Linkable)this.getLinkedParent()).setLinkedChild(null);
                    this.setLinkedParent(null);
                    return;
                }
                if (this.getLinkedParent().m_213877_()) {
                    this.setLinkedParent(null);
                }
            } else {
                MinecartHelper.shouldSlowDown((AbstractMinecart)this, this.f_19853_);
            }
            if (this.getLinkedChild() != null && this.getLinkedChild().m_213877_()) {
                this.setLinkedChild(null);
            }
            this.updateChains();
        }
    }

    @Inject(method={"canCollideWith"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterminecarts$damageEntities(Entity other, CallbackInfoReturnable<Boolean> info) {
        LivingEntity living;
        float damage;
        if (other instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)other;
            if (this.getLinkedParent() != null && !this.getLinkedParent().equals((Object)minecart)) {
                minecart.m_20256_(this.m_20184_());
            }
        }
        if ((damage = ((Float)BetterMinecartsConfig.MINECART_DAMAGE.get()).floatValue()) > 0.0f && !this.f_19853_.m_5776_() && other instanceof LivingEntity && (living = (LivingEntity)other).m_6084_() && !living.m_20159_() && this.m_20184_().m_82553_() > 1.5) {
            living.m_6469_(BetterMinecarts.minecart(this), damage);
            Vec3 knockBack = living.m_20184_().m_82520_(this.m_20184_().m_7096_() * 0.9, this.m_20184_().m_82553_() * 0.2, this.m_20184_().m_7094_() * 0.9);
            living.m_20256_(knockBack);
            living.f_19812_ = true;
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    public void betterminecarts$readNbt(CompoundTag nbt, CallbackInfo info) {
        if (nbt.m_128441_("ParentUuid")) {
            this.parentUuid = nbt.m_128342_("ParentUuid");
        }
        if (nbt.m_128441_("ChildUuid")) {
            this.childUuid = nbt.m_128342_("ChildUuid");
        }
        this.updateChains();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    public void betterminecarts$writeNbt(CompoundTag nbt, CallbackInfo info) {
        if (this.getLinkedParent() != null) {
            nbt.m_128362_("ParentUuid", this.getLinkedParent().m_20148_());
        }
        if (this.getLinkedChild() != null) {
            nbt.m_128362_("ChildUuid", this.getLinkedChild().m_20148_());
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="HEAD")})
    protected void defineSynchedDataAdditional(CallbackInfo info) {
        this.f_19804_.m_135372_(MinecartHelper.LINKED_PARENT, (Object)-1);
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.CROWBAR.get())) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                TrainUtil.clickedByCrowbar(stack, this, server);
                this.updateChains();
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    @Override
    public AbstractMinecart getLinkedParent() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.linkedParent == null && this.parentUuid != null && (level = server.m_8791_(this.parentUuid)) instanceof AbstractMinecart) {
                AbstractMinecart parent = (AbstractMinecart)level;
                this.setLinkedParent(parent);
            }
        }
        return this.linkedParent;
    }

    @Override
    public void setLinkedParent(AbstractMinecart parent) {
        this.linkedParent = parent;
        if (parent == null) {
            this.parentUuid = null;
        }
    }

    @Override
    public AbstractMinecart getLinkedChild() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.linkedChild == null && this.childUuid != null && (level = server.m_8791_(this.childUuid)) instanceof AbstractMinecart) {
                AbstractMinecart child = (AbstractMinecart)level;
                this.setLinkedChild(child);
            }
        }
        return this.linkedChild;
    }

    @Override
    public void setLinkedChild(AbstractMinecart child) {
        this.linkedChild = child;
        if (child == null) {
            this.childUuid = null;
        }
    }

    @Override
    public void updateChains() {
        if (!this.f_19853_.m_5776_()) {
            AbstractMinecart parent = this.getLinkedParent();
            if (parent == null) {
                this.f_19804_.m_135381_(MinecartHelper.LINKED_PARENT, (Object)-1);
            } else {
                this.f_19804_.m_135381_(MinecartHelper.LINKED_PARENT, (Object)this.linkedParent.m_19879_());
            }
        }
    }

    @Override
    public AbstractMinecart getLinkedParentForRender() {
        int id = (Integer)this.f_19804_.m_135370_(MinecartHelper.LINKED_PARENT);
        if (id == -1) {
            return null;
        }
        return (AbstractMinecart)this.f_19853_.m_6815_(id);
    }
}

