/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import hu.xannosz.betterminecarts.screen.ButtonConfig;
import hu.xannosz.betterminecarts.screen.Gauge;
import hu.xannosz.betterminecarts.screen.GraphicalButton;
import hu.xannosz.betterminecarts.screen.SteamLocomotiveMenu;
import hu.xannosz.betterminecarts.utils.ButtonId;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SteamLocomotiveScreen
extends AbstractContainerScreen<SteamLocomotiveMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("betterminecarts", "textures/gui/steam_locomotive.png");
    private int x;
    private int y;
    private GraphicalButton back;
    private GraphicalButton stop;
    private GraphicalButton pause;
    private GraphicalButton forward;
    private GraphicalButton fForward;
    private GraphicalButton ffForward;
    private GraphicalButton lamp;
    private GraphicalButton whistle;
    private GraphicalButton redstone;
    private Gauge steam;
    private Gauge water;
    private Gauge heat;
    private Gauge burn;

    public SteamLocomotiveScreen(SteamLocomotiveMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97727_ = 178;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        this.back = new GraphicalButton(this.generateConfig(61, 0, 7, ButtonId.BACK));
        this.stop = new GraphicalButton(this.generateConfig(69, 7, 7, ButtonId.STOP));
        this.pause = new GraphicalButton(this.generateConfig(77, 14, 7, ButtonId.PAUSE));
        this.forward = new GraphicalButton(this.generateConfig(85, 21, 7, ButtonId.FORWARD));
        this.fForward = new GraphicalButton(this.generateConfig(93, 28, 10, ButtonId.F_FORWARD));
        this.ffForward = new GraphicalButton(this.generateConfig(104, 38, 13, ButtonId.FF_FORWARD));
        this.lamp = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.LAMP).hitBoxX(this.x + 155).hitBoxY(this.y + 46).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(84).build());
        this.whistle = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.WHISTLE).hitBoxX(this.x + 155).hitBoxY(this.y + 62).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(96).build());
        this.redstone = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.REDSTONE).hitBoxX(this.x + 155).hitBoxY(this.y + 78).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(108).build());
        this.steam = new Gauge(this.x + 11, this.y + 9, 178, 2, 15, 79);
        this.water = new Gauge(this.x + 30, this.y + 9, 197, 2, 15, 79);
        this.heat = new Gauge(this.x + 50, this.y + 9, 216, 2, 3, 79);
        this.burn = new Gauge(this.x + 102, this.y + 59, 189, 84, 13, 13);
        this.m_142416_((GuiEventListener)this.back);
        this.m_142416_((GuiEventListener)this.stop);
        this.m_142416_((GuiEventListener)this.pause);
        this.m_142416_((GuiEventListener)this.forward);
        this.m_142416_((GuiEventListener)this.fForward);
        this.m_142416_((GuiEventListener)this.ffForward);
        this.m_142416_((GuiEventListener)this.lamp);
        this.m_142416_((GuiEventListener)this.whistle);
        this.m_142416_((GuiEventListener)this.redstone);
    }

    protected void m_7286_(@NotNull PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.m_69478_();
        this.m_93228_(poseStack, this.x, this.y, 0, 0, this.f_97726_, this.f_97727_);
        ((SteamLocomotiveMenu)this.f_97732_).createSlots();
        this.back.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.stop.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.pause.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.forward.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.fForward.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.ffForward.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.lamp.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.whistle.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.redstone.setEntityId(((SteamLocomotiveMenu)this.f_97732_).getSteamLocomotiveId());
        this.back.setSelected(false);
        this.stop.setSelected(false);
        this.pause.setSelected(false);
        this.forward.setSelected(false);
        this.fForward.setSelected(false);
        this.ffForward.setSelected(false);
        switch (((SteamLocomotiveMenu)this.f_97732_).getActiveButton()) {
            case BACK: {
                this.back.setSelected(true);
                break;
            }
            case STOP: {
                this.stop.setSelected(true);
                break;
            }
            case PAUSE: {
                this.pause.setSelected(true);
                break;
            }
            case FORWARD: {
                this.forward.setSelected(true);
                break;
            }
            case F_FORWARD: {
                this.fForward.setSelected(true);
                break;
            }
            case FF_FORWARD: {
                this.ffForward.setSelected(true);
            }
        }
        this.lamp.setSelected(((SteamLocomotiveMenu)this.f_97732_).isLampOn());
        this.redstone.setSelected(((SteamLocomotiveMenu)this.f_97732_).isSignalActive());
        this.steam.render(poseStack, ((SteamLocomotiveMenu)this.f_97732_).getSteam(), 2000, partialTick);
        this.water.render(poseStack, ((SteamLocomotiveMenu)this.f_97732_).getWater(), 2000, partialTick);
        this.heat.render(poseStack, ((SteamLocomotiveMenu)this.f_97732_).getHeat(), 125, partialTick);
        this.burn.render(poseStack, ((SteamLocomotiveMenu)this.f_97732_).getBurn(), ((SteamLocomotiveMenu)this.f_97732_).getMaxBurn(), partialTick);
    }

    public void m_86412_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        super.m_86412_(poseStack, mouseX, mouseY, delta);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
    }

    private ButtonConfig generateConfig(int buttonX, int hoverX, int w, ButtonId buttonId) {
        return ButtonConfig.builder().buttonId(buttonId).hitBoxX(this.x + buttonX).hitBoxY(this.y + 80).hitBoxW(w).hitBoxH(9).hoveredX(hoverX).hoveredY(178).build();
    }
}

