/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.utils;

import hu.xannosz.betterminecarts.utils.CrowbarMode;
import hu.xannosz.betterminecarts.utils.Linkable;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;

public final class TrainUtil {
    public static Linkable getHeadOfTrain(Linkable cart) {
        if (cart.getLinkedParent() == null) {
            return cart;
        }
        return TrainUtil.getHeadOfTrain((Linkable)cart.getLinkedParent());
    }

    public static void clickedByCrowbar(ItemStack itemStack, Entity minecart, ServerLevel server) {
        CrowbarMode mode = CrowbarMode.getFromLabel(itemStack.m_41784_().m_128461_("mode"));
        int firstCartIdTag = itemStack.m_41784_().m_128451_("firstCartId");
        if (firstCartIdTag == minecart.m_19879_()) {
            return;
        }
        if (firstCartIdTag == 0) {
            itemStack.m_41784_().m_128405_("firstCartId", minecart.m_19879_());
            return;
        }
        Linkable parent = (Linkable)server.m_6815_(firstCartIdTag);
        Linkable child = (Linkable)minecart;
        BlockPos position = minecart.m_20097_();
        if (parent == null) {
            return;
        }
        switch (mode) {
            case CONNECT: {
                if (parent.getLinkedChild() != null || child.getLinkedParent() != null) break;
                parent.setLinkedChild((AbstractMinecart)child);
                child.setLinkedParent((AbstractMinecart)parent);
                server.m_6263_(null, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), SoundEvents.f_11745_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                break;
            }
            case DISCONNECT: {
                if (!child.equals(parent.getLinkedChild()) || !parent.equals(child.getLinkedParent())) break;
                parent.setLinkedChild(null);
                child.setLinkedParent(null);
                server.m_6263_(null, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), SoundEvents.f_11744_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                break;
            }
            case REVERT: {
                HashSet<Linkable> train = new HashSet<Linkable>();
                LinkedList<Linkable> carts = new LinkedList<Linkable>();
                carts.add(child);
                while (!carts.isEmpty()) {
                    Linkable cart = (Linkable)carts.pop();
                    train.add(cart);
                    if (cart.getLinkedChild() != null && !train.contains((Linkable)cart.getLinkedChild())) {
                        carts.add((Linkable)cart.getLinkedChild());
                    }
                    if (cart.getLinkedParent() == null || train.contains((Linkable)cart.getLinkedParent())) continue;
                    carts.add((Linkable)cart.getLinkedParent());
                }
                for (Linkable cart : train) {
                    AbstractMinecart p = cart.getLinkedParent();
                    AbstractMinecart c = cart.getLinkedChild();
                    cart.setLinkedParent(c);
                    cart.setLinkedChild(p);
                    cart.updateChains();
                }
                server.m_6263_(null, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), SoundEvents.f_11745_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        itemStack.m_41784_().m_128405_("firstCartId", minecart.m_19879_());
    }

    private TrainUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

