/*
 * Decompiled with CFR 0.152.
 */
package com.exdrill.ce;

import com.exdrill.ce.CaveEnhancements;
import com.exdrill.ce.client.render.block.RoseQuartzChimesRenderer;
import com.exdrill.ce.client.render.entity.CruncherEntityRenderer;
import com.exdrill.ce.client.render.entity.DripstonePikeRenderer;
import com.exdrill.ce.client.render.entity.DripstoneTortoiseRenderer;
import com.exdrill.ce.client.render.entity.GoopEntityRenderer;
import com.exdrill.ce.client.render.entity.model.CruncherEntityModel;
import com.exdrill.ce.client.render.entity.model.GoopEntityModel;
import com.exdrill.ce.entity.EntitySpawnPacket;
import com.exdrill.ce.registry.ModBlocks;
import com.exdrill.ce.registry.ModEntities;
import com.exdrill.ce.registry.ModParticles;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_953;

@Environment(value=EnvType.CLIENT)
public class CaveEnhancementsClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ModBlocks.TransparentBlocks();
        ModParticles.registerClientParticles();
        EntityRendererRegistry.register(ModEntities.GOOP, GoopEntityRenderer::new);
        EntityRendererRegistry.register(ModEntities.CRUNCHER, CruncherEntityRenderer::new);
        EntityRendererRegistry.register(ModEntities.DRIPSTONE_TORTOISE, DripstoneTortoiseRenderer::new);
        EntityRendererRegistry.register(ModEntities.DRIPSTONE_PIKE, DripstonePikeRenderer::new);
        EntityRendererRegistry.register(ModEntities.BIG_GOOP_DRIP_PROJECTILE_ENTITY, class_953::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)CruncherEntityModel.ENTITY_MODEL_LAYER, CruncherEntityModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)GoopEntityModel.ENTITY_MODEL_LAYER, GoopEntityModel::getTexturedModelData);
        BlockEntityRendererRegistry.register(ModBlocks.ROSE_QUARTZ_CHIMES_BLOCK_ENTITY, rendererDispatcherIn -> new RoseQuartzChimesRenderer());
        this.receiveEntityPacket();
    }

    public void receiveEntityPacket() {
        ClientSidePacketRegistry.INSTANCE.register(CaveEnhancements.PacketID, (ctx, byteBuf) -> {
            class_1299 et = (class_1299)class_2378.field_11145.method_10200(byteBuf.method_10816());
            UUID uuid = byteBuf.method_10790();
            int entityId = byteBuf.method_10816();
            class_243 pos = EntitySpawnPacket.PacketBufUtil.readVec3d(byteBuf);
            float pitch = EntitySpawnPacket.PacketBufUtil.readAngle(byteBuf);
            float yaw = EntitySpawnPacket.PacketBufUtil.readAngle(byteBuf);
            ctx.getTaskQueue().execute(() -> {
                if (class_310.method_1551().field_1687 == null) {
                    throw new IllegalStateException("Tried to spawn entity in a null world!");
                }
                class_1297 e = et.method_5883((class_1937)class_310.method_1551().field_1687);
                if (e == null) {
                    throw new IllegalStateException("Failed to create instance of entity \"" + class_2378.field_11145.method_10221((Object)et) + "\"!");
                }
                e.method_30228(pos);
                e.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
                e.method_36457(pitch);
                e.method_36456(yaw);
                e.method_5838(entityId);
                e.method_5826(uuid);
                class_310.method_1551().field_1687.method_2942(entityId, e);
            });
        });
    }
}

