/*
 * Decompiled with CFR 0.152.
 */
package com.exdrill.ce.entity;

import com.exdrill.ce.entity.DripstonePikeEntity;
import com.exdrill.ce.registry.ModEntities;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DripstoneTortoiseEntity
extends class_1588
implements IAnimatable,
class_5354 {
    private static final class_2940<Integer> ANGER = class_2945.method_12791(DripstoneTortoiseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SHOULD_STOMP = class_2945.method_12791(DripstoneTortoiseEntity.class, (class_2941)class_2943.field_13323);
    public int stompTimer;
    public int soothed;
    @Nullable
    private UUID angryAt;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public DripstoneTortoiseEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 30;
    }

    public boolean method_7076(class_1657 player) {
        return false;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANGER, (Object)0);
        this.field_6011.method_12784(SHOULD_STOMP, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("shouldStomp", this.getShouldStomp());
        this.method_29517(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setShouldStomp(nbt.method_10577("shouldStomp"));
        this.method_29512(this.field_6002, nbt);
    }

    public void setShouldStomp(boolean shouldStomp) {
        this.field_6011.method_12778(SHOULD_STOMP, (Object)shouldStomp);
    }

    public boolean getShouldStomp() {
        return (Boolean)this.field_6011.method_12789(SHOULD_STOMP);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::controller));
    }

    private <E extends IAnimatable> PlayState controller(AnimationEvent<E> event) {
        if (this.getShouldStomp()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dripstone_tortoise.stomp", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dripstone_tortoise.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14856;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15183;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14722;
    }

    protected void method_5959() {
        this.field_6185.method_6277(1, (class_1352)new DripstoneTortoiseRevengeGoal(this).method_6318(new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, this::shouldAngerAt));
        this.field_6201.method_6277(4, (class_1352)new SpikeAttackGoal((class_1314)this, 1.5, true));
        this.field_6201.method_6277(5, (class_1352)new class_1379((class_1314)this, 1.5));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(6, (class_1352)new RandomSpikeGoal());
    }

    public static class_5132.class_5133 createDripstoneTortoiseAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23719, 0.125).method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23725, 2.0).method_26868(class_5134.field_23718, 0.6).method_26868(class_5134.field_23721, 3.0);
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource == class_1282.field_28400 || damageSource == class_1282.field_28099 || damageSource.method_5533() || damageSource.method_5529() instanceof DripstoneTortoiseEntity) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public boolean shouldAngerAt(Object entity) {
        if (!this.method_18395((class_1309)entity)) {
            return false;
        }
        return ((class_1309)entity).method_5864() == class_1299.field_6097 && this.method_29923(((class_1309)entity).field_6002) || ((class_1309)entity).method_5667().equals(this.method_29508());
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    protected void method_5632(double x, double y, double z) {
        super.method_5632(x, y, z);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER);
    }

    public void method_29514(int angerTime) {
        this.field_6011.method_12778(ANGER, (Object)angerTime);
    }

    public void method_29509() {
        this.method_29514(400);
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void sooth() {
        this.soothed = 2;
        this.method_29513(null);
        this.method_29514(0);
    }

    protected void method_5958() {
        if (!this.field_6002.field_9236) {
            this.method_29510((class_3218)this.field_6002, false);
            --this.stompTimer;
            if (this.stompTimer <= 0) {
                this.setShouldStomp(false);
            }
            --this.soothed;
        }
    }

    public void summonPike(class_243 pos) {
        float y = (float)pos.method_10214();
        class_2338 blockDownPos = new class_2338(pos.method_10216(), (double)(y - 1.0f), pos.method_10215());
        while (y < (float)this.field_6002.method_31600() && !this.field_6002.method_8320(blockDownPos).method_26169((class_1922)this.field_6002, blockDownPos, (class_1297)this, class_2350.field_11036)) {
            blockDownPos = new class_2338((double)blockDownPos.method_10263(), (double)(y -= 0.1f), (double)blockDownPos.method_10260());
        }
        if (y >= (float)this.field_6002.method_31600()) {
            y = (float)pos.method_10214();
        }
        DripstonePikeEntity spellPart = new DripstonePikeEntity(ModEntities.DRIPSTONE_PIKE, this.field_6002);
        spellPart.method_23327(pos.method_10216(), y, pos.method_10215());
        spellPart.owner = this;
        this.field_6002.method_8649((class_1297)spellPart);
    }

    private class DripstoneTortoiseRevengeGoal
    extends class_1399 {
        DripstoneTortoiseRevengeGoal(DripstoneTortoiseEntity dripstoneTortoise) {
            super((class_1314)dripstoneTortoise, new Class[0]);
        }

        public boolean method_6266() {
            return DripstoneTortoiseEntity.this.method_29511() && super.method_6266();
        }

        protected void method_6319(class_1308 mob, class_1309 target) {
            if (mob instanceof DripstoneTortoiseEntity && mob.method_6057((class_1297)target)) {
                mob.method_5980(target);
            }
        }
    }

    private class SpikeAttackGoal
    extends class_1352 {
        protected final class_1314 mob;
        private final double speed;
        private final boolean pauseWhenMobIdle;
        private class_11 path;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int updateCountdownTicks;
        private int cooldown;
        private long lastUpdateTime;

        protected double getSquaredMaxAttackDistance(class_1309 entity) {
            return 20.0;
        }

        protected void attack(class_1309 target, double squaredDistance) {
            double d = this.getSquaredMaxAttackDistance(target);
            if (squaredDistance <= d && this.cooldown <= 0) {
                this.resetCooldown();
                class_243 targetPos = target.method_19538();
                for (int i = 0; i < 10; ++i) {
                    DripstoneTortoiseEntity.this.summonPike(new class_243((double)DripstoneTortoiseEntity.this.field_5974.nextFloat(-1.5f, 1.5f) + targetPos.method_10216(), targetPos.method_10214(), (double)DripstoneTortoiseEntity.this.field_5974.nextFloat(-1.5f, 1.5f) + targetPos.method_10215()));
                }
                DripstoneTortoiseEntity.this.setShouldStomp(true);
                DripstoneTortoiseEntity.this.stompTimer = 10;
                DripstoneTortoiseEntity.this.field_6002.method_8396(null, new class_2338(DripstoneTortoiseEntity.this.method_19538()), class_3417.field_28038, class_3419.field_15251, 1.0f, 1.0f);
            }
        }

        public SpikeAttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            this.mob = mob;
            this.speed = speed;
            this.pauseWhenMobIdle = pauseWhenMobIdle;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            long l = this.mob.field_6002.method_8510();
            if (l - this.lastUpdateTime < 20L) {
                return false;
            }
            this.lastUpdateTime = l;
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            this.path = this.mob.method_5942().method_6349((class_1297)livingEntity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getSquaredMaxAttackDistance(livingEntity) >= this.mob.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
        }

        public boolean method_6266() {
            if (DripstoneTortoiseEntity.this.soothed > 0) {
                return false;
            }
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (!this.pauseWhenMobIdle) {
                return !this.mob.method_5942().method_6357();
            }
            if (!this.mob.method_18407(livingEntity.method_24515())) {
                return false;
            }
            return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657)livingEntity).method_7337();
        }

        public void method_6269() {
            this.mob.method_5942().method_6334(this.path, this.speed);
            this.mob.method_19540(true);
            this.updateCountdownTicks = 0;
            this.cooldown = 0;
        }

        public void method_6270() {
            class_1309 livingEntity = this.mob.method_5968();
            if (!class_1301.field_6156.test(livingEntity)) {
                this.mob.method_5980(null);
            }
            this.mob.method_19540(false);
            this.mob.method_5942().method_6340();
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity != null) {
                this.mob.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
                double d = this.mob.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
                this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
                if ((this.pauseWhenMobIdle || this.mob.method_5985().method_6369((class_1297)livingEntity)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.method_6051().nextFloat() < 0.05f)) {
                    this.targetX = livingEntity.method_23317();
                    this.targetY = livingEntity.method_23318();
                    this.targetZ = livingEntity.method_23321();
                    this.updateCountdownTicks = 4 + this.mob.method_6051().nextInt(7);
                    if (d > 1024.0) {
                        this.updateCountdownTicks += 10;
                    } else if (d > 256.0) {
                        this.updateCountdownTicks += 5;
                    }
                    if (!this.mob.method_5942().method_6335((class_1297)livingEntity, this.speed)) {
                        this.updateCountdownTicks += 15;
                    }
                    this.updateCountdownTicks = this.method_38847(this.updateCountdownTicks);
                }
                this.cooldown = Math.max(this.cooldown - 1, 0);
                this.attack(livingEntity, d);
            }
        }

        protected void resetCooldown() {
            this.cooldown = 20;
        }
    }

    private class RandomSpikeGoal
    extends class_1352 {
        private int cooldown;
        private long lastUpdateTime;

        protected void spike() {
            if (this.cooldown <= 0) {
                this.resetCooldown();
                class_243 targetPos = DripstoneTortoiseEntity.this.method_19538();
                for (int i = 0; i < 10; ++i) {
                    DripstoneTortoiseEntity.this.summonPike(new class_243((double)DripstoneTortoiseEntity.this.field_5974.nextFloat(-1.5f, 1.5f) + targetPos.method_10216(), targetPos.method_10214(), (double)DripstoneTortoiseEntity.this.field_5974.nextFloat(-1.5f, 1.5f) + targetPos.method_10215()));
                }
                DripstoneTortoiseEntity.this.setShouldStomp(true);
                DripstoneTortoiseEntity.this.stompTimer = 10;
                DripstoneTortoiseEntity.this.field_6002.method_8396(null, new class_2338(DripstoneTortoiseEntity.this.method_19538()), class_3417.field_28038, class_3419.field_15251, 1.0f, 1.0f);
            }
        }

        public boolean method_6264() {
            if (DripstoneTortoiseEntity.this.method_6510()) {
                return false;
            }
            long l = DripstoneTortoiseEntity.this.field_6002.method_8510();
            if (l - this.lastUpdateTime < 20L) {
                return false;
            }
            this.lastUpdateTime = l;
            return true;
        }

        public boolean method_6266() {
            return !DripstoneTortoiseEntity.this.method_6510();
        }

        public void method_6269() {
            this.cooldown = 0;
        }

        public void method_6270() {
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            this.cooldown = Math.max(this.cooldown - 1, 0);
            this.spike();
        }

        protected void resetCooldown() {
            this.cooldown = 400;
        }
    }
}

